/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.enterprise;

import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;

final class EnterpriseAgentNamingPolicy {
    private static final int kInitialAgentNamingSleepTimeInMillis = 15000;
    public static final String kDefaultAgentNameSystemPropertyKey = "com.wily.introscope.agent.agentName";
    public static final char[] kIllegalAgentNameChars = new char[]{'%', '|', ':'};
    private final EnterpriseAgent fAgent;
    private IRegisteredBehavior fInitialAgentNamingBehavior = null;
    private Object fInitialAgentNamingBehaviorLock = new Object();
    private String fUnscrubbedConfiguredAgentName = null;
    private final Object fAgentNameLock = new Object();
    private IRegisteredBehavior fAgentRenamingBehavior = null;
    private Object fAgentRenamingBehaviorLock = new Object();

    public EnterpriseAgentNamingPolicy(EnterpriseAgent agent) {
        this.fAgent = agent;
    }

    private IndexedProperties getProperties() {
        return this.fAgent.IAgent_getIndexedProperties();
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fAgent.IAgent_getStringLocalizer();
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fAgent.IAgent_getModuleFeedback();
    }

    public boolean canAutoNameAgent() {
        String agentNameSystemKey;
        String agentName;
        try {
            agentName = System.getProperty(kDefaultAgentNameSystemPropertyKey);
            if (!StringUtils.isEmpty(agentName)) {
                return true;
            }
        }
        catch (SecurityException securityException) {}
        if (!StringUtils.isEmpty(agentNameSystemKey = this.getProperties().getTrimmedProperty("introscope.agent.agentNameSystemPropertyKey"))) {
            try {
                agentName = System.getProperty(agentNameSystemKey);
                if (!StringUtils.isEmpty(agentName)) {
                    return true;
                }
            }
            catch (SecurityException securityException) {}
        }
        boolean step3Enabled = this.getProperties().getBooleanProperty("introscope.agent.agentAutoNamingEnabled", false);
        return step3Enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nameAgentAsync() {
        Object object = this.fInitialAgentNamingBehaviorLock;
        synchronized (object) {
            this.fInitialAgentNamingBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new InitialAgentNamingBehavior(), "InitialAgentNamingBehavior", true, 15000L, true);
        }
    }

    private void startAutoRenameAgentBehavior() {
        int sleepTimeInMinutes = this.getProperties().safeGetNonNegativeIntProperty("introscope.agent.agentAutoRenamingIntervalInMinutes", 10, this.getModuleFeedback(), this.getStringLocalizer());
        long autoRenamingSleepTimeInMillis = 60000 * sleepTimeInMinutes;
        if (autoRenamingSleepTimeInMillis == 0L) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Auto_Renaming_Disabled_Message"));
        } else {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Auto_Renaming_Enabled_Message", Integer.toString(sleepTimeInMinutes)));
            this.fAgentRenamingBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new AutoRenamingAgentBehavior(), "AutoRenamingAgentBehavior", true, autoRenamingSleepTimeInMillis, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopInitialAgentNamingBehavior() {
        Object object = this.fInitialAgentNamingBehaviorLock;
        synchronized (object) {
            return this.fAgent.IAgent_getCommonHeartbeat().removeBehavior(this.fInitialAgentNamingBehavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAgentName(String agentName) {
        Assertion.wilyAssert(agentName != null, "Should not attempt to set agent name to null in EnterpriseAgentNamingPolicy.setAgentName");
        boolean firstAgentName = false;
        Object object = this.fAgentNameLock;
        synchronized (object) {
            if (this.fUnscrubbedConfiguredAgentName == null) {
                firstAgentName = true;
            }
            this.fUnscrubbedConfiguredAgentName = agentName;
        }
        if (firstAgentName) {
            this.stopInitialAgentNamingBehavior();
        }
        agentName = this.cleanupAgentName(agentName);
        this.fAgent.setAgentName(agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameAgentIfNameChanged(String agentName) {
        Object object = this.fAgentNameLock;
        synchronized (object) {
            if (this.fUnscrubbedConfiguredAgentName != null && this.fUnscrubbedConfiguredAgentName.compareTo(agentName) != 0) {
                this.setAgentName(agentName);
            }
        }
    }

    private String getAgentNameFromDefaultSystemProperty() {
        String agentName = null;
        String[] defaultSystemProperty = new String[]{kDefaultAgentNameSystemPropertyKey, "agentName"};
        int i = 0;
        while (i < defaultSystemProperty.length) {
            try {
                agentName = System.getProperty(defaultSystemProperty[i]);
            }
            catch (SecurityException securityException) {
                this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Security_Exception_Getting_Agent_Name_From_System_Property_Message", defaultSystemProperty[i]));
            }
            if (!StringUtils.isEmpty(agentName)) {
                this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Got_Agent_Name_From_Default_System_Property_Message", agentName, defaultSystemProperty[i]));
                return agentName;
            }
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Missing_Or_Blank_Default_Default_Agent_Name_System_Property_Message", defaultSystemProperty[i]));
            ++i;
        }
        return null;
    }

    private String getAgentNameFromCustomSystemProperty() {
        String agentName = null;
        String agentNameSystemKey = this.getProperties().getTrimmedProperty("introscope.agent.agentNameSystemPropertyKey");
        if (StringUtils.isEmpty(agentNameSystemKey)) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Missing_Or_Blank_Custom_Agent_Name_System_Property_Key_Message", "introscope.agent.agentNameSystemPropertyKey"));
            return null;
        }
        try {
            agentName = System.getProperty(agentNameSystemKey);
        }
        catch (SecurityException securityException) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Security_Exception_Getting_Agent_Name_From_System_Property_Message", agentNameSystemKey));
            return null;
        }
        if (StringUtils.isEmpty(agentName)) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Missing_Or_Blank_Default_Custom_Agent_Name_System_Property_Message", agentNameSystemKey));
            return null;
        }
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Got_Agent_Name_From_Custom_System_Property_Message", agentName, agentNameSystemKey));
        return agentName;
    }

    private String getAgentNameFromAppserver() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String agentName = null;
        agentName = this.fAgent.IAgent_getEnvironmentAdministrator().getAppserverGeneratedAgentName();
        if (StringUtils.isEmpty(agentName)) {
            throw new CallbackFailedTemporarilyException(new SimpleLocalizableMessage("Agent_Empty_Appserver_Generated_Agent_Name_Message"));
        }
        return agentName;
    }

    private String getAgentNameFromWilyProperty() {
        String agentName = this.getProperties().getProperty("introscope.agent.agentName");
        if (StringUtils.isEmpty(agentName)) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Missing_Or_Blank_Agent_Name_Wily_Property_Message", "introscope.agent.agentName"));
            return null;
        }
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Got_Agent_Name_From_Wily_Property_Message", agentName, "introscope.agent.agentName"));
        return agentName;
    }

    private String getDefaultAgentName() {
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Using_Default_Agent_Name", "UnknownAgent"));
        return "UnknownAgent";
    }

    private String getUnnamedAgentName() {
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Using_Unnamed_Agent_Name", "UnnamedAgent"));
        return "UnnamedAgent";
    }

    private String cleanupAgentName(String agentName) {
        String cleaned;
        if (agentName != null && (cleaned = agentName.trim()).compareTo(agentName) != 0) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Trimming_Agent_Name_Message", agentName));
            agentName = cleaned;
        }
        if ((cleaned = StringUtils.replaceIllegalChars(agentName, kIllegalAgentNameChars, '_')) != null && cleaned.compareTo(agentName) != 0) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Illegal_Characters_In_Agent_Name_Message", agentName));
            agentName = cleaned;
        }
        if (!StringUtils.isEmpty(agentName) && !Character.isLetter(agentName.charAt(0))) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Agent_Name_Must_Begin_With_Letter_Message", agentName, "A"));
            agentName = String.valueOf('A') + agentName;
        }
        if (StringUtils.isEmpty(agentName)) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Empty_Agent_Name_Message", "UnnamedAgent"));
            agentName = "UnnamedAgent";
        }
        return agentName;
    }

    String debug_cleanupAgentName(String name) {
        return this.cleanupAgentName(name);
    }

    String debug_getAgentNameFromDefaultSystemProperty() {
        return this.getAgentNameFromDefaultSystemProperty();
    }

    String debug_getAgentNameFromCustomSystemProperty() {
        return this.getAgentNameFromCustomSystemProperty();
    }

    String debug_getAgentNameFromWilyProperty() {
        return this.getAgentNameFromWilyProperty();
    }

    private final class AutoRenamingAgentBehavior
    implements ITimestampedRunnable {
        private static final int kMaxLogAttemptCount = 10;
        private int fAttemptCount = 0;

        private AutoRenamingAgentBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            EnterpriseAgentNamingPolicy thisPolicy = EnterpriseAgentNamingPolicy.this;
            String agentName = null;
            try {
                agentName = thisPolicy.getAgentNameFromAppserver();
            }
            catch (CallbackFailedTemporarilyException cfte) {
                EnterpriseAgentNamingPolicy.this.getModuleFeedback().verbose(cfte.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(EnterpriseAgentNamingPolicy.this.getStringLocalizer()));
                if (cfte.getCause() != null) {
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().verbose(cfte.getCause());
                }
            }
            catch (CallbackFailedPermanentlyException cfpe) {
                EnterpriseAgentNamingPolicy.this.getModuleFeedback().verbose(cfpe);
            }
            if (agentName != null) {
                this.fAttemptCount = 0;
                thisPolicy.renameAgentIfNameChanged(agentName);
            } else {
                ++this.fAttemptCount;
                if (this.fAttemptCount <= 10) {
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().verbose(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Auto_Rename_Attempt_Failed_Message", Integer.toString(this.fAttemptCount)));
                }
            }
        }
    }

    private final class InitialAgentNamingBehavior
    implements ITimestampedRunnable {
        private long fStartupDelayInMillis;
        private boolean fFirstTry = true;
        private boolean fStep3Enabled = false;

        public InitialAgentNamingBehavior() {
            EnterpriseAgentNamingPolicy thisPolicy = EnterpriseAgentNamingPolicy.this;
            this.fStartupDelayInMillis = 1000 * thisPolicy.getProperties().safeGetNonNegativeIntProperty("introscope.agent.agentAutoNamingMaximumConnectionDelayInSeconds", 120, EnterpriseAgentNamingPolicy.this.getModuleFeedback(), EnterpriseAgentNamingPolicy.this.getStringLocalizer());
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            EnterpriseAgentNamingPolicy thisPolicy = EnterpriseAgentNamingPolicy.this;
            String agentName = null;
            if (this.fFirstTry) {
                this.fFirstTry = false;
                EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Naming_Algorithm_Beginning_Message"));
                agentName = thisPolicy.getAgentNameFromDefaultSystemProperty();
                if (agentName == null) {
                    agentName = thisPolicy.getAgentNameFromCustomSystemProperty();
                }
                if (agentName != null) {
                    thisPolicy.setAgentName(agentName);
                    return;
                }
                this.fStep3Enabled = EnterpriseAgentNamingPolicy.this.getProperties().safeGetBooleanProperty("introscope.agent.agentAutoNamingEnabled", false, EnterpriseAgentNamingPolicy.this.getModuleFeedback(), EnterpriseAgentNamingPolicy.this.getStringLocalizer());
                if (this.fStep3Enabled) {
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Agent_Auto_Naming_Enabled_Message"));
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Agent_Auto_Naming_Delaying_Connection_Message", Long.toString(this.fStartupDelayInMillis / 1000L)));
                } else {
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Agent_Auto_Naming_Disabled_Message"));
                }
            } else {
                this.fStartupDelayInMillis -= 15000L;
            }
            if (this.fStep3Enabled) {
                boolean step3FailedPermanently = false;
                try {
                    agentName = thisPolicy.getAgentNameFromAppserver();
                }
                catch (CallbackFailedTemporarilyException cfte) {
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(cfte.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(EnterpriseAgentNamingPolicy.this.getStringLocalizer()));
                    if (cfte.getCause() != null) {
                        EnterpriseAgentNamingPolicy.this.getModuleFeedback().verbose(cfte.getCause());
                    }
                }
                catch (CallbackFailedPermanentlyException cpfe) {
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Appserver_Agent_Naming_Permanently_Failed_Message"));
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().verbose(cpfe);
                    step3FailedPermanently = true;
                }
                if (agentName != null) {
                    EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Got_Agent_Name_From_Appserver_Message", agentName));
                    thisPolicy.setAgentName(agentName);
                    thisPolicy.startAutoRenameAgentBehavior();
                    return;
                }
                if (!step3FailedPermanently) {
                    if (this.fStartupDelayInMillis <= 0L) {
                        EnterpriseAgentNamingPolicy.this.getModuleFeedback().info(EnterpriseAgentNamingPolicy.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Could_Not_Get_Agent_Name_From_Appserver_Before_Timeout_Message"));
                        thisPolicy.startAutoRenameAgentBehavior();
                    } else {
                        return;
                    }
                }
            }
            if ((agentName = thisPolicy.getAgentNameFromWilyProperty()) != null) {
                thisPolicy.setAgentName(agentName);
                return;
            }
            agentName = this.fStep3Enabled ? thisPolicy.getDefaultAgentName() : thisPolicy.getUnnamedAgentName();
            thisPolicy.setAgentName(agentName);
        }
    }
}

