/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.DynamicClassLookup;
import java.lang.reflect.Constructor;

public abstract class InstantiableDynamicClassLookup
extends DynamicClassLookup {
    public InstantiableDynamicClassLookup(IAgent agent, Class expectedType, Class[] constructorParameterTypes) {
        super(agent, expectedType, constructorParameterTypes);
    }

    protected abstract Object[] getConstructorParameters(IAgent var1);

    public final Object load(String dynamicName) {
        Object instance = null;
        try {
            DynamicClassLookup.DynamicClassEntry entry = this.loadDynamicClassEntry(dynamicName);
            Class dynamicClass = entry.getDynamicClass();
            IAgent dynamicAgent = entry.getDynamicAgent();
            if (!this.getExpectedType().isAssignableFrom(dynamicClass)) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Wrong_Type_Error", dynamicName));
            } else {
                try {
                    Constructor constructor = dynamicClass.getConstructor(this.getConstructorParameterTypes());
                    instance = constructor.newInstance(this.getConstructorParameters(dynamicAgent));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", dynamicName));
                }
                catch (SecurityException securityException) {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", dynamicName));
                }
                catch (Throwable t) {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", dynamicName));
                    this.getModuleFeedback().verbose(t);
                }
            }
        }
        catch (Throwable t) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Creation_Error", dynamicName));
            this.getModuleFeedback().verbose(t);
        }
        return instance;
    }
}

