/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.OptionalExtensionsBootLoadConfiguration;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalExtensionsIncludeConfiguration {
    private static IAgent fAgent;
    private static volatile HashSet<String> fOptionalExtensionsIncludeList;
    private static volatile HashSet<String> fPrevOptionalExtensionsIncludeList;
    private static HashSet<String> fLoadList;
    private static HashSet<String> fBootLoadList;
    private static OptionalExtensionsManager fOptionalExtensionsManagerSingleton;

    static {
        fOptionalExtensionsIncludeList = new HashSet();
        fPrevOptionalExtensionsIncludeList = null;
        fLoadList = null;
        fBootLoadList = null;
        fOptionalExtensionsManagerSingleton = null;
    }

    public static void init(IAgent agent, OptionalExtensionsManager optionalExtensionsManagerSingleton) {
        fAgent = agent;
        fOptionalExtensionsManagerSingleton = optionalExtensionsManagerSingleton;
        OptionalExtensionsIncludeConfiguration.initializeOptionalExtensionsIncludeList(fOptionalExtensionsManagerSingleton.isDynamic());
    }

    private static void initializeOptionalExtensionsIncludeList(boolean isHot) {
        ConfigurationManager configManager = fAgent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty optionalExtensionsIncludeListHotProperty = new StringSetConfigurationProperty("introscope.agent.extensions.bundles.load", new HashSet(), "List of extensions to be loaded", "", isHot, false, fAgent.IAgent_getModuleFeedback(), fAgent.IAgent_getModule(), fAgent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                OptionalExtensionsIncludeConfiguration.setOptionalExtensionsIncludeList((HashSet)newValue);
            }
        };
        configManager.add(optionalExtensionsIncludeListHotProperty, true);
    }

    public static void setOptionalExtensionsIncludeList(HashSet<String> extensions) {
        boolean firstSet = false;
        if (fPrevOptionalExtensionsIncludeList == null) {
            firstSet = true;
        }
        if (fBootLoadList == null) {
            fBootLoadList = OptionalExtensionsBootLoadConfiguration.getExtensions();
        }
        fLoadList = extensions;
        fPrevOptionalExtensionsIncludeList = fOptionalExtensionsIncludeList;
        fOptionalExtensionsIncludeList = new HashSet<String>(extensions);
        fOptionalExtensionsIncludeList.addAll(fBootLoadList);
        fAgent.IAgent_getModuleFeedback().info("Extensions bundles Include List [before change]:" + fPrevOptionalExtensionsIncludeList.toString());
        fAgent.IAgent_getModuleFeedback().info("Extensions bundles Include List [after change]:" + fOptionalExtensionsIncludeList.toString());
        if (!firstSet) {
            fOptionalExtensionsManagerSingleton.setListDirtyFlag(true);
            fOptionalExtensionsManagerSingleton.startExecutor();
        }
    }

    public static HashSet<String> getPrevIncludedExtensions() {
        return fPrevOptionalExtensionsIncludeList;
    }

    public static HashSet<String> getIncludedExtensions() {
        return fOptionalExtensionsIncludeList;
    }

    public static HashSet<String> getExtensions() {
        return fLoadList;
    }
}

