/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.Map;
import java.util.WeakHashMap;

public class ConditionalAnchorTracer
extends ASingleInstanceTracerFactory
implements ITracer {
    private static ThreadLocal fMethodClassAnchors = new ThreadLocal(){

        protected Object initialValue() {
            AnchorMap result = new AnchorMap();
            return result;
        }
    };

    public ConditionalAnchorTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String callingClassParameter = this.getParameter("callingClass");
        String callingMethodParameter = this.getParameter("callingMethod");
        ConditionalAnchorTracer.getMap().removeCallingClassMethod(callingClassParameter, callingMethodParameter);
    }

    private static AnchorMap getMap() {
        Object result = fMethodClassAnchors.get();
        return (AnchorMap)result;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String callingClassParameter = this.getParameter("callingClass");
        String callingMethodParameter = this.getParameter("callingMethod");
        ConditionalAnchorTracer.getMap().addCallingClassMethod(callingClassParameter, callingMethodParameter);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public static boolean existsAnchor(String className, String method) {
        AnchorMap anchors = ConditionalAnchorTracer.getMap();
        return anchors.existAnchor(className, method);
    }

    private static final class AnchorMap {
        final Map classMap = new WeakHashMap();

        private AnchorMap() {
        }

        protected void addCallingClassMethod(String callingClassParameter, String callingMethodParameter) {
            MutableInteger numberOfCallingMethodsInStack;
            WeakHashMap<String, MutableInteger> methodMap = (WeakHashMap<String, MutableInteger>)this.classMap.get(callingClassParameter);
            if (methodMap == null) {
                methodMap = new WeakHashMap<String, MutableInteger>();
                this.classMap.put(callingClassParameter, methodMap);
            }
            if ((numberOfCallingMethodsInStack = (MutableInteger)methodMap.get(callingMethodParameter)) == null) {
                numberOfCallingMethodsInStack = new MutableInteger(1);
                methodMap.put(callingMethodParameter, numberOfCallingMethodsInStack);
            } else {
                numberOfCallingMethodsInStack.inc();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void removeCallingClassMethod(String callingClassParameter, String callingMethodParameter) {
            MutableInteger numberOfCallingMethodsInStack;
            Assertion.wilyAssert(false);
            Map methodMap = (Map)this.classMap.get(callingClassParameter);
            if (methodMap == null) return;
            Assertion.wilyAssert(false);
            MutableInteger counter = (MutableInteger)methodMap.get(callingMethodParameter);
            if (counter == null) return;
            counter.dec();
            if (counter.getValue() == 0) {
                methodMap.remove(callingMethodParameter);
                if (methodMap.size() == 0) {
                    this.classMap.remove(callingClassParameter);
                }
            }
            if ((numberOfCallingMethodsInStack = (MutableInteger)methodMap.get(callingMethodParameter)) == null) {
                numberOfCallingMethodsInStack = new MutableInteger(1);
                methodMap.put(callingMethodParameter, numberOfCallingMethodsInStack);
                return;
            } else {
                numberOfCallingMethodsInStack.inc();
            }
        }

        protected boolean existAnchor(String callingClassParameter, String callingMethodParameter) {
            MutableInteger numberOfCallingMethodsInStack;
            Map methodMap = (Map)this.classMap.get(callingClassParameter);
            return methodMap != null && (numberOfCallingMethodsInStack = (MutableInteger)methodMap.get(callingMethodParameter)) != null;
        }
    }

    private static final class MutableInteger {
        private int i;

        public MutableInteger(int initVal) {
            this.i = initVal;
        }

        public void inc() {
            ++this.i;
        }

        public void dec() {
            --this.i;
        }

        public int getValue() {
            return this.i;
        }

        public void clear() {
            this.i = 0;
        }
    }
}

