/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class MethodCompletedErrorReportingTracer
extends ASingleInstanceTracerFactory
implements ICacheableInvocationDataTracerFactory {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public MethodCompletedErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        this.doFinishTrace(tracerIndex, data);
    }

    protected void doFinishTrace(int tracerIndex, InvocationData data) {
        String errMsg = this.constructErrorMessage(data);
        if (ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), null, errMsg)) {
            this.decorateTransactionTraceWithErrorData(data, errMsg);
            IStackElement topElement = data.getVirtualCursor().getTopOfStack();
            if (topElement != data) {
                this.incrementErrorMetric(topElement);
                this.constructAndSendErrorSnapshot(topElement, null, errMsg);
            } else {
                this.incrementErrorMetric(data);
                this.constructAndSendErrorSnapshot(data, errMsg);
            }
            data.incrementErrorMetric();
        }
        if (this.calculateBooleanParameter("ownmetric", true)) {
            this.createOwnMetricError(data);
        }
    }

    private void createOwnMetricError(InvocationData data) {
        String errorMessage = this.constructErrorMessageFromProbeInfo(data);
        if (ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), null, errorMessage)) {
            String name = this.formatParameterizedName(data);
            try {
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            catch (ESEException eSEException) {
                Assertion.wilyFail("Metric type conflict");
            }
        }
    }

    protected void decorateTransactionTraceWithErrorData(InvocationData data, String errMsg) {
        ErrorFeature.decorateTransactionsWithError(data, errMsg);
    }

    protected void incrementErrorMetric(IStackElement data) {
        ErrorFeature.incrementErrorMetric(data);
    }

    protected String constructErrorMessage(InvocationData data) {
        String errorMessage = this.constructErrorMessageFromProbeInfo(data);
        String component = this.getComponentNameOfLastBlamePoint(data);
        if (component != null) {
            return String.valueOf(component) + ": " + errorMessage;
        }
        return errorMessage;
    }

    private String constructErrorMessageFromProbeInfo(InvocationData data) {
        ProbeIdentification probe = data.getProbeInformation().getProbeIdentification();
        String errorMessage = String.valueOf(this.getFormattedResource()) + ": " + probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName() + " was called";
        return errorMessage;
    }

    protected void constructAndSendErrorSnapshot(InvocationData data, String errMsg) {
        ErrorFeature.constructAndSendErrorSnapshotToServer(data, errMsg, this.getAgent());
    }

    protected void constructAndSendErrorSnapshot(IStackElement topElement, Throwable error, String errMsg) {
        ErrorFeature.constructAndSendErrorSnapshotToServer(topElement, error, errMsg, this.getAgent());
    }

    public String getComponentNameOfLastBlamePoint(InvocationData data) {
        String componentName = null;
        ITracer[] tracers = data.getTracersByType(null);
        int i = tracers.length - 1;
        while (i >= 0) {
            if (tracers[i] != null && (tracers[i] instanceof BlamePointTracer || tracers[i] instanceof com.wily.introscope.agent.trace.BlamePointTracer) && (componentName = data.getComponentNameAt(i)) != null) break;
            --i;
        }
        return componentName;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public boolean canCacheInvocationData() {
        return true;
    }

    @Override
    public boolean canCacheTracerInstances() {
        return true;
    }

    @Override
    public boolean canCacheComponentNames() {
        return true;
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }
}

