/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoTracingClampHelper {
    public static String kMessage = "Resetting autotraces counter. Number of autotraces identified in this interval: ";
    private static volatile AtomicInteger fTracesPerInterval = new AtomicInteger(0);
    public static volatile int fClampLimit = 0;

    public static void resetCounter() {
        int value = fTracesPerInterval.getAndSet(0);
        if (Logger.isDebugEnabled()) {
            Logger.logDebugMessage(String.valueOf(kMessage) + value);
        }
        int clampedTraces = 0;
        int tracesMatched = value;
        if (tracesMatched > fClampLimit) {
            clampedTraces = tracesMatched - fClampLimit;
        }
        SustainabilityMetricsHelper.reportAutoTracingSustainabilityMetricsClamped(clampedTraces);
    }

    public static boolean checkClampAndIncrement() {
        fTracesPerInterval.getAndIncrement();
        return fTracesPerInterval.get() > fClampLimit;
    }
}

