/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;

public class CrossProcessLogger {
    private static final Module kModule = new Module("CrossProcessAutoPropagation");
    private static volatile IAgent fAgent = null;
    private static volatile LoggingHandler fDelegate;

    static {
        IAgent agent = CrossProcessLogger.getAgent();
        if (agent != null) {
            fDelegate = new LoggingHandler(kModule, agent);
        }
    }

    public static void logException(Exception e) {
        if (fDelegate != null) {
            fDelegate.logException(e);
        }
    }

    public static void logException(String message, Exception e) {
        if (fDelegate != null) {
            fDelegate.logException(message, e);
        }
    }

    public static void logInfoMessage(String message) {
        if (fDelegate != null) {
            fDelegate.logInfoMessage(message);
        }
    }

    public static void logWarnMessage(String message) {
        if (fDelegate != null) {
            fDelegate.logWarningMessage(message);
        }
    }

    public static void logDebugMessage(String message) {
        if (fDelegate != null) {
            fDelegate.logDebugMessage(message);
        }
    }

    public static void logDebugMessage(String message, Throwable e) {
        if (fDelegate != null) {
            fDelegate.logDebugMessage(message, e);
        }
    }

    public static void logTraceMessage(String message) {
        if (fDelegate != null) {
            fDelegate.logTraceMessage(message);
        }
    }

    public static void logMessage(String message, SeverityLevel level) {
        if (fDelegate != null) {
            fDelegate.logMessage(message, level);
        }
    }

    public static boolean isInfoEnabled() {
        return fDelegate != null && fDelegate.isInfoEnabled();
    }

    public static boolean isDebugEnabled() {
        return fDelegate != null && fDelegate.isDebugEnabled();
    }

    public static boolean isTraceEnabled() {
        return fDelegate != null && fDelegate.isTraceEnabled();
    }

    public static IAgent getAgent() {
        if (fAgent == null) {
            try {
                fAgent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException e) {
                AgentShim.handleError("Error while getting Agent instance for Intelligent Instrumentation Logger", e);
            }
        }
        return fAgent;
    }

    public static Module getModule() {
        return kModule;
    }

    public static class LoggingHandler {
        private Module fModule = null;
        private IAgent fAgent = null;

        public LoggingHandler(String moduleName, IAgent agent) {
            if (moduleName != null) {
                this.fModule = new Module(moduleName);
            }
            this.fAgent = agent;
        }

        public LoggingHandler(Module module, IAgent agent) {
            this.fModule = module;
            this.fAgent = agent;
        }

        public void logException(Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error(this.fModule, e.getMessage());
            this.logExceptionDebugLevel(e);
        }

        public void logException(String message, Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error(this.fModule, String.valueOf(message) + " " + e.getMessage());
            this.logExceptionDebugLevel(e);
        }

        private void logExceptionDebugLevel(Exception e) {
            if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.fModule)) {
                this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, e.toString(), e);
            }
        }

        public void logWarningMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().warn(this.fModule, message);
        }

        public void logInfoMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().info(this.fModule, message);
        }

        public void logDebugMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, message);
        }

        public void logDebugMessage(String message, Throwable e) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, message);
            this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, e.toString(), e);
        }

        public void logTraceMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().trace(this.fModule, message);
        }

        public void logMessage(String message, SeverityLevel level) {
            if (level.compareTo(SeverityLevel.ERROR) == 0) {
                this.fAgent.IAgent_getModuleFeedback().error(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.WARN) == 0) {
                this.fAgent.IAgent_getModuleFeedback().warn(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.INFO) == 0) {
                this.fAgent.IAgent_getModuleFeedback().info(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.VERBOSE) == 0) {
                this.fAgent.IAgent_getModuleFeedback().verbose(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.DEBUG) == 0) {
                this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.TRACE) == 0) {
                this.fAgent.IAgent_getModuleFeedback().trace(this.fModule, message);
            }
        }

        public boolean isWarningEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isWarningEnabled(this.fModule);
        }

        public boolean isInfoEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isInfoEnabled(this.fModule);
        }

        public boolean isDebugEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.fModule);
        }

        public boolean isTraceEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isTraceEnabled(this.fModule);
        }

        public Module getModule() {
            return this.fModule;
        }
    }
}

