/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.rules;

import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.MergeException;
import com.wily.introscope.agent.upgrade.merge.rules.DeleteEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.DeleteFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.NoMergeFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.OverwriteFileRule;
import com.wily.introscope.agent.upgrade.merge.rules.PreferredEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.Rules;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RulesParser {
    private Rules fRules = new Rules();

    public RulesParser() {
    }

    public RulesParser(String rulesFile) throws MergeException {
        this.fRules = new Rules();
        if (rulesFile != null) {
            File file = new File(rulesFile);
            if (!file.exists()) {
                throw new MergeException("ERROR: The rule file \"" + rulesFile + "\" doesn't exist.");
            }
            this.parse(rulesFile);
        }
    }

    public Rules getRules() {
        return this.fRules;
    }

    private void parse(String rulesFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(rulesFile);
            this.validateDocument(document);
            Element rootElement = document.getDocumentElement();
            this.parseDeleteFileRules(rootElement);
            this.parseOverwriteFileRules(rootElement);
            this.parseNoMergeRules(rootElement);
            this.parseDeleteEntryRules(rootElement);
            this.parsePreferredEntryRules(rootElement);
        }
        catch (Exception exception) {}
    }

    private void validateDocument(Document document) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream istream = this.getClass().getResourceAsStream("MetadataMergeRules1.0.xsd");
        StreamSource schemaFile = new StreamSource(istream);
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    private void parseDeleteFileRules(Element rootElement) {
        NodeList nodeList = rootElement.getElementsByTagName("delete-file");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(i);
                DeleteFileRule rule = this.getDeleteFileRule(element);
                if (rule != null) {
                    this.fRules.addDeleteFileRule(rule);
                }
                ++i;
            }
        }
    }

    private DeleteFileRule getDeleteFileRule(Element element) {
        DeleteFileRule rule = null;
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        IRulesEngine.MergeableType mergeType = IRulesEngine.MergeableType.getType(type);
        if (mergeType != IRulesEngine.MergeableType.INVALID) {
            rule = new DeleteFileRule(mergeType, name);
        }
        return rule;
    }

    private void parseOverwriteFileRules(Element rootElement) {
        NodeList nodeList = rootElement.getElementsByTagName("overwrite-file");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(i);
                OverwriteFileRule rule = this.getOverwriteFileRule(element);
                if (rule != null) {
                    this.fRules.addOverwriteFileRule(rule);
                }
                ++i;
            }
        }
    }

    private OverwriteFileRule getOverwriteFileRule(Element element) {
        OverwriteFileRule rule = null;
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        IRulesEngine.MergeableType mergeType = IRulesEngine.MergeableType.getType(type);
        if (mergeType != IRulesEngine.MergeableType.INVALID) {
            rule = new OverwriteFileRule(mergeType, name);
        }
        return rule;
    }

    private void parseNoMergeRules(Element rootElement) {
        NodeList nodeList = rootElement.getElementsByTagName("no-merge-file");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(i);
                NoMergeFileRule rule = this.getNoMergeFileRule(element);
                if (rule != null) {
                    this.fRules.addNoMergeFileRule(rule);
                }
                ++i;
            }
        }
    }

    private NoMergeFileRule getNoMergeFileRule(Element element) {
        NoMergeFileRule rule = null;
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        IRulesEngine.MergeableType mergeType = IRulesEngine.MergeableType.getType(type);
        if (mergeType != IRulesEngine.MergeableType.INVALID) {
            rule = new NoMergeFileRule(mergeType, name);
        }
        return rule;
    }

    private void parseDeleteEntryRules(Element rootElement) {
        NodeList nodeList = rootElement.getElementsByTagName("delete-entry");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(i);
                DeleteEntryRule rule = this.getDeleteEntryRule(element);
                if (rule != null) {
                    this.fRules.addDeleteEntryRule(rule);
                }
                ++i;
            }
        }
    }

    private DeleteEntryRule getDeleteEntryRule(Element element) {
        DeleteEntryRule rule = null;
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        IRulesEngine.MergeableType mergeType = IRulesEngine.MergeableType.getType(type);
        if (mergeType != IRulesEngine.MergeableType.INVALID) {
            rule = new DeleteEntryRule(mergeType, name);
        }
        return rule;
    }

    private void parsePreferredEntryRules(Element rootElement) {
        NodeList nodeList = rootElement.getElementsByTagName("preferred-entry");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(i);
                PreferredEntryRule rule = this.getPreferredEntryRule(element);
                if (rule != null) {
                    this.fRules.addPreferredEntryRule(rule);
                }
                ++i;
            }
        }
    }

    private PreferredEntryRule getPreferredEntryRule(Element element) {
        PreferredEntryRule rule = null;
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        String preference = element.getAttribute("preference");
        IRulesEngine.MergeableType mergeType = IRulesEngine.MergeableType.getType(type);
        IRulesEngine.PreferenceType prefType = IRulesEngine.PreferenceType.getType(preference);
        if (mergeType != IRulesEngine.MergeableType.INVALID && prefType != IRulesEngine.PreferenceType.INVALID) {
            rule = new PreferredEntryRule(mergeType, name, prefType);
        }
        return rule;
    }
}

