/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.urlgroup;

import com.wily.introscope.agent.urlgroup.URLComponents;
import com.wily.introscope.agent.urlgroup.URLGroupRule;
import com.wily.introscope.agent.urlgroup.URLMatchResult;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.ListIterator;

public class URLGroupRuleContainer {
    private LinkedList m_list = new LinkedList();
    private boolean m_hasQueryParams = false;
    private volatile boolean m_isNotDefault = false;

    public void add(String prefix, String formatString) throws UnsupportedEncodingException {
        this.add(prefix, formatString, null);
    }

    public void add(String prefix, String formatString, String charEncodingString) throws UnsupportedEncodingException {
        URLGroupRule rule = new URLGroupRule(prefix, formatString, charEncodingString);
        if (rule.hasQueryParams()) {
            this.m_hasQueryParams = true;
        }
        this.m_list.add(rule);
        if (this.m_list.size() > 1 || !rule.isMatchesAll() || rule.hasComplexFormat()) {
            this.m_isNotDefault = true;
        }
    }

    public void clear() {
        this.m_list.clear();
    }

    public int size() {
        return this.m_list.size();
    }

    public boolean hasQueryParams() {
        return this.m_hasQueryParams;
    }

    public URLMatchResult matchFirstRule(URLComponents urlComponents) {
        ListIterator iter = this.m_list.listIterator();
        while (iter.hasNext()) {
            URLGroupRule traverse = (URLGroupRule)iter.next();
            if (!traverse.isMatch(urlComponents)) continue;
            return new URLMatchResult(traverse.format(urlComponents), traverse.getCharEncoding());
        }
        return URLMatchResult.kNotMatched;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("URLGroupRuleContainer(");
        int i = 0;
        ListIterator iter = this.m_list.listIterator();
        while (iter.hasNext()) {
            result.append('[');
            result.append(Integer.toString(i));
            result.append(']');
            result.append(iter.next());
            result.append(' ');
            ++i;
        }
        return result.toString();
    }

    public boolean isNotDefault() {
        return this.m_isNotDefault;
    }
}

