/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.domain.DomainNameConverter;
import com.wily.introscope.spec.metric.AgentMetricPrefix;
import com.wily.introscope.spec.metric.AgentName;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.isengard.data.IIsengardReadResolve;
import com.wily.org.apache.commons.collections.ReferenceMap;
import com.wily.util.HashCodeUtils;
import com.wily.util.text.IStringLocalizer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public final class MetricPrefix
implements Externalizable,
IIsengardReadResolve {
    private static final long serialVersionUID = 7885505708569066810L;
    private AgentName fProcess;
    private AgentMetricPrefix fPath;
    private static ReferenceMap sFullPathCache = new ReferenceMap(0, 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetricPrefix lookupFromCache(Integer hashCode) {
        if (hashCode == null) {
            hashCode = new Integer(0);
        }
        ReferenceMap referenceMap = sFullPathCache;
        synchronized (referenceMap) {
            return (MetricPrefix)sFullPathCache.get(hashCode);
        }
    }

    private static int getHashCode(AgentName process, AgentMetricPrefix path, String suffix) {
        int hash = process.getProcessURLHashCode();
        hash = HashCodeUtils.appendHashCode(hash, "|");
        hash = HashCodeUtils.appendHashCode(hash, path.hashCode(), path.length());
        if (suffix != null) {
            hash = HashCodeUtils.appendHashCode(hash, suffix.hashCode(), suffix.length());
        }
        return hash;
    }

    private static MetricPrefix getFromCache(AgentName process, AgentMetricPrefix path, String suffix) throws BadlyFormedNameException {
        int hash = MetricPrefix.getHashCode(process, path, suffix);
        MetricPrefix result = MetricPrefix.lookupFromCache(new Integer(hash));
        if (result == null) {
            result = MetricPrefix.addToCache(MetricPrefix.createFullPath(process, path, suffix));
        }
        return result;
    }

    private static MetricPrefix getFromCache(AgentName process) throws BadlyFormedNameException {
        int hash = process.getProcessURLHashCode();
        MetricPrefix result = MetricPrefix.lookupFromCache(new Integer(hash));
        if (result == null) {
            result = MetricPrefix.addToCache(process.getProcessURL());
        }
        return result;
    }

    private static MetricPrefix getFromCache(String fullPathURL) throws BadlyFormedNameException {
        MetricPrefix result;
        if (fullPathURL == null) {
            fullPathURL = "";
        }
        if ((result = MetricPrefix.lookupFromCache(new Integer(fullPathURL.hashCode()))) == null) {
            result = MetricPrefix.addToCache(fullPathURL);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized MetricPrefix addToCache(String fullPathURL) throws BadlyFormedNameException {
        Integer hashCode;
        MetricPrefix result;
        if (fullPathURL == null) {
            fullPathURL = "";
        }
        if ((result = MetricPrefix.lookupFromCache(hashCode = new Integer(fullPathURL.hashCode()))) == null) {
            result = new MetricPrefix(fullPathURL);
            ReferenceMap referenceMap = sFullPathCache;
            synchronized (referenceMap) {
                sFullPathCache.put(hashCode, result);
            }
        }
        return result;
    }

    public static MetricPrefix getMetricPrefix(MetricPrefix fullPathToCopy) {
        return fullPathToCopy;
    }

    public static MetricPrefix[] getMetricPrefixes(AgentName process, AgentMetricPrefix[] paths) {
        MetricPrefix[] prefixes = new MetricPrefix[paths.length];
        int i = 0;
        while (i < prefixes.length) {
            prefixes[i] = MetricPrefix.getMetricPrefix(process, paths[i]);
            ++i;
        }
        return prefixes;
    }

    public static MetricPrefix getMetricPrefix(AgentName process, AgentMetricPrefix path) {
        try {
            if (path.isEmpty()) {
                return MetricPrefix.getFromCache(process);
            }
            return MetricPrefix.getFromCache(process, path, null);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            return null;
        }
    }

    public static MetricPrefix getMetricPrefix(MetricPrefix prefixPath, String suffixString) throws BadlyFormedNameException {
        return MetricPrefix.getFromCache(prefixPath.getAgentName(), prefixPath.getAgentMetricPrefix(), suffixString);
    }

    public static MetricPrefix getMetricPrefix(String fullPathString) throws BadlyFormedNameException {
        return MetricPrefix.getFromCache(fullPathString);
    }

    public static MetricPrefix getMetricPrefix(String[] segmentArray) throws BadlyFormedNameException {
        AgentName process = AgentName.getAgentName(segmentArray, 0, 4);
        AgentMetricPrefix path = AgentMetricPrefix.getAgentMetricPrefix(segmentArray, 4, segmentArray.length - 4);
        return MetricPrefix.getMetricPrefix(process, path);
    }

    public MetricPrefix() {
    }

    private MetricPrefix(String fullPathString) throws BadlyFormedNameException {
        String pathName;
        String processName;
        int index = AgentName.findIndexOfPivotSeparatorInFullPath(fullPathString, "|");
        if (index == -1) {
            processName = fullPathString;
            pathName = "";
        } else {
            processName = fullPathString.substring(0, index);
            pathName = fullPathString.substring(index + 1);
        }
        this.fProcess = AgentName.getAgentName(processName);
        this.fPath = AgentMetricPrefix.getAgentMetricPrefix(pathName);
    }

    public AgentName getAgentName() {
        return this.fProcess;
    }

    public AgentMetricPrefix getAgentMetricPrefix() {
        return this.fPath;
    }

    public String getFullPathURLWithoutDomain() {
        if (this.getAgentMetricPrefix().isEmpty()) {
            return this.getAgentName().getProcessURLWithoutDomain();
        }
        return String.valueOf(this.getAgentName().getProcessURLWithoutDomain()) + "|" + this.getAgentMetricPrefix().getPathURL();
    }

    public String getFullPathURL() {
        return MetricPrefix.createFullPath(this.getAgentName(), this.getAgentMetricPrefix(), null);
    }

    private static String createFullPath(AgentName process, AgentMetricPrefix path, String suffixString) {
        if (path.isEmpty()) {
            return process.getProcessURL();
        }
        String processStr = process.getProcessURL();
        String pathStr = path.getPathURL();
        StringBuffer sb = new StringBuffer(processStr.length() + "|".length() * 2 + pathStr.length() + (suffixString == null ? 0 : suffixString.length()));
        sb.append(processStr);
        sb.append("|");
        sb.append(pathStr);
        if (suffixString != null) {
            sb.append("|");
            sb.append(suffixString);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getFullPathURL();
    }

    public Object readResolve() throws ObjectStreamException {
        return MetricPrefix.getMetricPrefix(this.fProcess, this.fPath);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fProcess);
        out.writeObject(this.fPath);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fProcess = (AgentName)in.readObject();
        this.fPath = (AgentMetricPrefix)in.readObject();
    }

    public String getFullPathURLWithSimpleDomain(IStringLocalizer localizer) {
        String fullDomain = this.getAgentName().getDomain();
        DomainNameConverter converter = new DomainNameConverter(localizer);
        String simpleDomain = DomainNameConverter.convertName(fullDomain);
        String processURL = this.getAgentName().getProcessURLWithoutDomain();
        String path = this.getAgentMetricPrefix().getPathURL();
        StringBuffer sb = new StringBuffer(simpleDomain.length() + 1 + processURL.length() + 1 + path.length());
        sb.append(simpleDomain);
        sb.append('|');
        sb.append(processURL);
        sb.append('|');
        sb.append(path);
        return sb.toString();
    }

    public boolean isDirectParentOf(MetricPrefix child) {
        if (!this.fProcess.equals(child.getAgentName())) {
            return false;
        }
        return this.fPath.isDirectParentOf(child.getAgentMetricPrefix());
    }
}

