/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TransactionTypesTraceFilter
extends ATransactionTraceFilter {
    private static final long serialVersionUID = 1708849648374819947L;
    private Set fTypes;

    public TransactionTypesTraceFilter() {
    }

    public TransactionTypesTraceFilter(String[] types) {
        this.fTypes = new HashSet<String>(Arrays.asList(types));
    }

    public int ITransactionTraceFilter_getFilterType() {
        return 7;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        String type = root.getParameterValue("Trace Type");
        type = type == null ? "Normal" : type;
        return this.fTypes.contains(type);
    }

    public boolean shouldCollect(Map parameters) {
        String type = (String)parameters.get("Trace Type");
        type = type == null ? "T" : type;
        return this.fTypes.contains(type);
    }

    public boolean isHeadFilter() {
        return true;
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Trace_Types_Filter_Description_Message", this.fTypes.toString());
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Trace_Types_Filter_Status_Bar_Text_Message", this.fTypes.toString());
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        return localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Trace_Types_Filter_Status_Bar_Text_Message", this.fTypes.toString());
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        out.writeInt(this.fTypes.size());
        Iterator iter = this.fTypes.iterator();
        while (iter.hasNext()) {
            out.writeUTF((String)iter.next());
        }
    }

    private void readInternal(DataInput in) throws IOException {
        int count = in.readInt();
        this.fTypes = new HashSet();
        int i = 0;
        while (i < count) {
            this.fTypes.add(in.readUTF());
            ++i;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.ITransactionTraceFilter_write(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    public int hashCode() {
        int hashCode = 0;
        Iterator i = this.fTypes.iterator();
        while (i.hasNext()) {
            hashCode ^= i.next().hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof TransactionTypesTraceFilter) {
            TransactionTypesTraceFilter t = (TransactionTypesTraceFilter)o;
            if (t.fTypes.size() == this.fTypes.size()) {
                return this.fTypes.containsAll(t.fTypes);
            }
        }
        return false;
    }
}

