/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.AIntegerCombiningGatherer;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class IntegerFluctuatingMinGatherer
extends AIntegerCombiningGatherer {
    private int fValue;
    private int fMax;
    private int fMin;
    private boolean fReset;

    public IntegerFluctuatingMinGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        this.whackInternalState();
        Assertion.wilyAssert(false);
    }

    public int getIntValue() {
        return this.fValue;
    }

    public int getIntMinimum() {
        return this.fMin;
    }

    public int getIntMaximum() {
        return this.fMax;
    }

    protected void directSetIntMinimum(int minimum) {
        this.fMin = minimum;
    }

    protected void directSetIntMaximum(int maximum) {
        this.fMax = maximum;
    }

    public synchronized void recordOneDataPoint(int value) {
        this.updateWithData(value);
        this.syncSinglePointBounds(value);
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
    }

    private void updateWithData(int value) {
        if (this.fReset) {
            this.fValue = Integer.MAX_VALUE;
            this.fMax = Integer.MIN_VALUE;
            this.fMin = Integer.MAX_VALUE;
            this.fReset = false;
        }
        if (value < this.fValue) {
            this.fValue = value;
        }
    }

    protected void doAcceptAggregateIntegerTimeslicedValue(IntegerTimeslicedValue typedAggregate) {
        long count = typedAggregate.getDataPointCount();
        int value = typedAggregate.getValue();
        this.updateWithData(value);
        this.addToDataPointCount(count);
        this.syncAggregateBounds(typedAggregate);
    }

    protected void doResetCombiningGatherer(long when) {
        this.directSetIntMaximum(this.fValue);
        this.directSetIntMinimum(this.fValue);
        this.fReset = true;
    }

    protected void doReinitializeCombiningGatherer() {
        this.whackInternalState();
    }

    private void whackInternalState() {
        this.directSetIntMaximum(0);
        this.directSetIntMinimum(0);
        this.fValue = 0;
        this.fReset = true;
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        IntegerTimeslicedValue value1 = (IntegerTimeslicedValue)pvalue1;
        IntegerTimeslicedValue value2 = (IntegerTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return IntegerFluctuatingMinGatherer.absentInt(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        int min = Math.min(value1.getMinimum(), value2.getMinimum());
        int max = Math.max(value1.getMaximum(), value2.getMaximum());
        int value = Math.min(value1.getValue(), value2.getValue());
        return new IntegerTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, value, min, max);
    }
}

