/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.AConstantGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class LongConstantGatherer
extends AConstantGatherer {
    private long fValue;

    public LongConstantGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    public LongConstantGatherer(int typeCookie, long startTimestamp, long constantValue) {
        super(typeCookie, startTimestamp);
        this.noteDataIsPresent();
        this.setLongValue(constantValue);
    }

    public long getLongValue() {
        return this.fValue;
    }

    private void setLongValue(long newValue) {
        this.fValue = newValue;
    }

    protected ATimeslicedValue doConstantHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        return new LongTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getLongValue());
    }

    protected void doAcceptAggregateTimeslicedValue(IMetricDataValue value) throws IncompatibleTypesException {
        LongTimeslicedValue typedValue = LongTimeslicedValue.checkedCast(value);
        this.setLongValue(typedValue.getValue());
    }
}

