/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.threaddump.common;

import com.wily.introscope.common15.properties.Messages;
import com.wily.introscope.threaddump.common.IWilyThreadDump;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ThreadDumpError
extends IWilyThreadDump {
    private String errorDescr;
    private int errcode;
    private Throwable err;
    private static final long serialVersionUID = 10L;

    public ThreadDumpError() {
    }

    public ThreadDumpError(String message, Throwable cause, Status status) {
        this.errorDescr = message;
        this.setStatus(status.code);
        this.err = cause;
    }

    public ThreadDumpError(String message, Status status) {
        this.errorDescr = message;
        this.setStatus(status.code);
    }

    public ThreadDumpError(Throwable cause) {
        this.err = cause;
    }

    public void setErrorDesc(String errorDescr) {
        this.errorDescr = errorDescr;
    }

    public String getErrorDesc() {
        return this.errorDescr;
    }

    public void setStatus(int errcode) {
        this.errcode = errcode;
        if (this.errorDescr == null) {
            this.setErrorDesc(Status.descr(errcode));
        }
    }

    public Status getStatus() {
        return Status.get(this.errcode);
    }

    public boolean getErrorFlag() {
        return true;
    }

    public String getMessage() {
        return this.err.getMessage();
    }

    public String getLocalizedMessage() {
        String msg;
        if (this.errorDescr != null) {
            return this.errorDescr;
        }
        if (this.err != null && (msg = this.err.getLocalizedMessage()) == null) {
            msg = this.err.toString();
            return msg;
        }
        return Messages.getString("ThreadDumpError.DefaultMessage");
    }

    public Throwable getCause() {
        return this.err;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.errorDescr = in.readUTF();
        this.errcode = in.readInt();
        this.err = (Throwable)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.errorDescr);
        out.writeInt(this.errcode);
        out.writeObject(this.err);
    }

    public boolean isSerializedVersion() {
        return false;
    }

    public long getTimestamp() {
        return 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nErrorDescr=");
        sb.append(this.errorDescr);
        sb.append("\nErrorCode=");
        sb.append(this.errcode);
        sb.append("\nThrowable=");
        sb.append(this.err);
        sb.append("\n");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status implements Serializable
    {
        NORMAL(0),
        NULL(1),
        GENERICERROR(100),
        ConnectionExceptionErrorStatus(101),
        FileNotAvailableErrorStatus(102),
        UnableTogetThreadDumpStatus(104),
        OperationNotAvailable(105),
        ServiceNotAvailable(106),
        SizeoFTDExceedMax(107),
        InvalidName(108),
        AgentNotConnected(109),
        ThreadDumpNotActive(110),
        ServiceAvailable(111),
        ServiceDisabled(112),
        InvalidThreadDump(113),
        IOIssue(114),
        AgentBusy(115),
        NotAuthorized(116),
        UnsupportedTD(117),
        TDPersistanceError(118);

        private static Map<Integer, Status> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, Status>();
            for (Status s : EnumSet.allOf(Status.class)) {
                lookup.put(s.getCode(), s);
            }
        }

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Status get(int code) {
            return lookup.get(code);
        }

        public static String descr(int code) {
            return lookup.get(code).toString();
        }
    }
}

