/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.pipe;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.messageprimitives.CompressedMethodCallMessage;
import com.wily.isengard.messageprimitives.InterfaceUtilities;
import com.wily.isengard.messageprimitives.InterfaceValidationUtilities;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.MethodCallUtilities;
import com.wily.isengard.messageprimitives.UnexpectedMessageError;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.messageprimitives.pipe.IMessagePipeData;
import com.wily.isengard.messageprimitives.pipe.IMessagePipeNotification;
import com.wily.isengard.messageprimitives.pipe.PipeCloseMessage;
import com.wily.isengard.messageprimitives.pipe.PipeNotOpenException;
import com.wily.isengard.messageprimitives.pipe.PipeOpenMessage;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.MessageUndeliverableMessage;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.LinkedList;

public class AAsyncMessagePipeEndpoint
extends Mailbox
implements InvocationHandler {
    private static Module sModule = new Module("AAsyncMessagePipeEndpoint");
    private static final int kCreated = 1;
    private static final int kOpen = 2;
    private static final int kClosing = 3;
    private static final int kClosed = 4;
    private int fState;
    private Address fConnectedTo;
    private Object fPublisherInterface;
    private IMessagePipeData fMethodHandler;
    private boolean fTraceMessages;
    private int fInterfaceVersion;
    private boolean fCompressed;
    private short fWriteSequenceNumber;
    private short fReadSequenceNumber;
    private LinkedList fOutOfSequenceList;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AAsyncMessagePipeEndpoint() {
    }

    public AAsyncMessagePipeEndpoint(PostOffice po, Class pipeInterface, IMessagePipeData callHandler) throws InvalidIsengardInterface {
        super(po);
        this.initialize(pipeInterface, callHandler);
    }

    public AAsyncMessagePipeEndpoint(PostOffice po, Class pipeInterface) throws InvalidIsengardInterface {
        super(po);
        try {
            this.initialize(pipeInterface, (IMessagePipeData)((Object)this));
        }
        catch (ClassCastException e) {
            this.getFeedbackChannel().error(sModule, "The class " + this.getClass() + " must implement the interface IMessagePipeData");
            throw new UnexpectedExceptionError(e);
        }
    }

    private void initialize(Class pipeInterface, IMessagePipeData callHandler) throws InvalidIsengardInterface {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.isengard.messageprimitives.pipe.IMessagePipeData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InterfaceValidationUtilities.validateInterface(pipeInterface, clazz);
        this.fInterfaceVersion = InterfaceUtilities.getInterfaceVersion(pipeInterface);
        this.fPublisherInterface = Proxy.newProxyInstance(pipeInterface.getClassLoader(), new Class[]{pipeInterface}, (InvocationHandler)this);
        this.setInvocationHandler(callHandler);
        this.fMethodHandler = callHandler;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.wily.isengard.messageprimitives.service.IIsengardCompressed");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fCompressed = clazz2.isAssignableFrom(pipeInterface);
        this.fState = 2;
    }

    public final void connectToPipeEndpoint(Address connectTo) throws EndpointNotFoundException {
        this.fConnectedTo = connectTo;
        this.closeOnPODisconnect(this.fConnectedTo.getPostOffice());
        PipeOpenMessage open = new PipeOpenMessage();
        try {
            this.sendMessage(open, this.fConnectedTo);
        }
        catch (MessageUndeliverableException messageUndeliverableException) {
            throw new EndpointNotFoundException();
        }
    }

    public final Object getPublisher() {
        return this.fPublisherInterface;
    }

    public void setShouldTrace(boolean shouldTrace) {
        this.fTraceMessages = shouldTrace;
    }

    public final Address getPipeAddress() {
        return this.getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        short sequenceNumber;
        Address connectedTo;
        int state;
        AAsyncMessagePipeEndpoint aAsyncMessagePipeEndpoint = this;
        synchronized (aAsyncMessagePipeEndpoint) {
            state = this.fState;
            connectedTo = this.fConnectedTo;
            short s = this.fWriteSequenceNumber;
            this.fWriteSequenceNumber = (short)(s + 1);
            sequenceNumber = s;
        }
        switch (state) {
            case 1: 
            case 3: 
            case 4: {
                throw new PipeNotOpenException();
            }
            case 2: {
                Assertion.wilyAssert(connectedTo != null);
                MethodCallMessage message = this.fCompressed ? new CompressedMethodCallMessage(method, this.fInterfaceVersion, args) : new MethodCallMessage(method, this.fInterfaceVersion, args);
                if (this.fTraceMessages) {
                    message.setShouldTrace();
                }
                message.setSequenceNumber(sequenceNumber);
                this.sendMessage(message, connectedTo);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        int state;
        AAsyncMessagePipeEndpoint aAsyncMessagePipeEndpoint = this;
        synchronized (aAsyncMessagePipeEndpoint) {
            state = this.fState;
            this.fState = 4;
        }
        this.onPipeClosed();
        if (state == 2) {
            this.sendCloseMessage();
        }
        if (state != 4) {
            super.close();
        }
    }

    public synchronized boolean isOpen() {
        return this.fState == 2;
    }

    public synchronized boolean isClosed() {
        return this.fState != 2;
    }

    public synchronized boolean isConnected() {
        return this.isOpen() && this.fConnectedTo != null;
    }

    private synchronized void sendCloseMessage() {
        if (this.fConnectedTo != null) {
            PipeCloseMessage close = new PipeCloseMessage();
            try {
                this.sendMessage(close, this.fConnectedTo);
            }
            catch (MessageUndeliverableException messageUndeliverableException) {}
        }
    }

    private void queueOutOfSequenceMessages(AMessage message) {
        if (this.fOutOfSequenceList == null) {
            this.fOutOfSequenceList = new LinkedList();
        }
        this.fOutOfSequenceList.add(message);
    }

    private AMessage dequeueOutOfSequenceMessages(short sequenceNumber) {
        if (this.fOutOfSequenceList == null || this.fOutOfSequenceList.isEmpty()) {
            return null;
        }
        Iterator i = this.fOutOfSequenceList.iterator();
        while (i.hasNext()) {
            AMessage message = (AMessage)i.next();
            if (message.getSequenceNumber() != sequenceNumber) continue;
            i.remove();
            return message;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(AMessage message) {
        block28: {
            AAsyncMessagePipeEndpoint aAsyncMessagePipeEndpoint;
            while (message instanceof MethodCallMessage) {
                aAsyncMessagePipeEndpoint = this;
                synchronized (aAsyncMessagePipeEndpoint) {
                    if (this.fState != 2) {
                        this.sendCloseMessage();
                        return;
                    }
                    short incomingSequence = message.getSequenceNumber();
                    if (incomingSequence != this.fReadSequenceNumber) {
                        this.queueOutOfSequenceMessages(message);
                        return;
                    }
                    this.fReadSequenceNumber = (short)(this.fReadSequenceNumber + 1);
                    try {
                        MethodCallUtilities.callInterface(this.fMethodHandler, (MethodCallMessage)message);
                    }
                    catch (Throwable e) {
                        IModuleFeedbackChannel fb = this.getFeedbackChannel();
                        if (!(e instanceof PipeNotOpenException)) {
                            if (fb.isDebugEnabled()) {
                                fb.error(sModule, "Caught exception while handling stream message. " + e.toString(), e);
                            } else {
                                fb.error(sModule, "Caught exception while handling stream message. " + e.toString());
                            }
                        }
                        fb.debug(sModule, "Caught exception while handling stream message.", e);
                    }
                    message = this.dequeueOutOfSequenceMessages(this.fReadSequenceNumber);
                    if (message != null) {
                        continue;
                    }
                    break block28;
                }
            }
            if (message instanceof PipeCloseMessage) {
                aAsyncMessagePipeEndpoint = this;
                synchronized (aAsyncMessagePipeEndpoint) {
                    if (this.fState == 4) {
                        return;
                    }
                    this.fState = 3;
                }
                this.close();
            } else {
                if (message instanceof PipeOpenMessage) {
                    aAsyncMessagePipeEndpoint = this;
                    synchronized (aAsyncMessagePipeEndpoint) {
                        Assertion.wilyAssert(this.fConnectedTo == null);
                        this.fConnectedTo = message.getSourceAddress();
                        AAsyncMessagePipeEndpoint aAsyncMessagePipeEndpoint2 = this;
                        synchronized (aAsyncMessagePipeEndpoint2) {
                            if (this.fState != 2) {
                                this.sendCloseMessage();
                                return;
                            }
                        }
                    }
                }
                if (message instanceof MessageUndeliverableMessage) {
                    this.close();
                } else {
                    throw new UnexpectedMessageError(message);
                }
            }
        }
    }

    protected void onPipeClosed() {
        if (this.fMethodHandler instanceof IMessagePipeNotification) {
            ((IMessagePipeNotification)((Object)this.fMethodHandler)).pipeClosed();
        }
    }

    public synchronized String toString() {
        String result = "Local Address: " + this.getAddress();
        if (this.fConnectedTo != null) {
            result = String.valueOf(result) + ", Remote Address: " + this.fConnectedTo;
        }
        return result;
    }
}

