/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.stream;

import com.wily.isengard.message.AControlMessage;
import com.wily.isengard.message.AMessage;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.IRawMethodHandler;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.MethodCallUtilities;
import com.wily.isengard.messageprimitives.stream.IMessageStream;
import com.wily.isengard.messageprimitives.stream.IMessageStreamPublisherService;
import com.wily.isengard.messageprimitives.stream.MessageStreamPublisher;
import com.wily.isengard.messageprimitives.stream.StreamCloseMessage;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;

public class MessageStreamSubscriber
extends Mailbox
implements IPostOfficeNotification {
    private static Module sModule = new Module("MessageStreamSubscriber");
    private volatile Address fSubscribedTo;
    private IMessageStream fCallHandler;

    public MessageStreamSubscriber(PostOffice po) {
        super(po);
        this.receivePostOfficeNotification(this);
    }

    public void subscribeTo(Address streamAddress, IMessageStream callHandler) throws ConnectionException {
        Assertion.wilyAssert(this.fSubscribedTo == null);
        IMessageStreamPublisherService request = MessageStreamPublisher.getInterface(this.getPostOffice(), streamAddress);
        String interfaceName = request.getInterfaceName();
        try {
            Class<?> dataClass = callHandler.getClass();
            Class<?> subscribedToClass = dataClass.getClassLoader().loadClass(interfaceName);
            if (!subscribedToClass.isAssignableFrom(dataClass) && !(callHandler instanceof IRawMethodHandler)) {
                throw new ClassCastException("Stream handler " + callHandler.getClass().getName() + " does not implement published interface " + subscribedToClass.getName());
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoClassDefFoundError(cnfe.getMessage());
        }
        this.fSubscribedTo = streamAddress;
        this.fCallHandler = callHandler;
        this.setInvocationHandler(callHandler);
        request.subscribeToStream(this.getAddress());
    }

    public void unsubscribe() {
        Address subscribeTo = this.fSubscribedTo;
        if (subscribeTo != null) {
            IMessageStreamPublisherService request = MessageStreamPublisher.getInterface(this.getPostOffice(), subscribeTo);
            try {
                request.unsubscribeToStream(this.getAddress());
            }
            catch (ConnectionException connectionException) {}
            this.fSubscribedTo = null;
        }
    }

    public void close() {
        this.unsubscribe();
        this.cancelPostOfficeNotification(this);
        super.close();
    }

    private void publisherStoppedInternal() {
        this.fSubscribedTo = null;
        this.publisherStopped();
    }

    public Address getPublisherAddress() {
        return this.fSubscribedTo;
    }

    protected void publisherStopped() {
    }

    public final void receiveMessage(AMessage message) {
        if (message instanceof AControlMessage) {
            if (message instanceof StreamCloseMessage) {
                this.publisherStoppedInternal();
            }
        } else {
            MethodCallMessage streamData = (MethodCallMessage)message;
            try {
                MethodCallUtilities.callInterface(this.fCallHandler, streamData);
            }
            catch (Throwable e) {
                this.getFeedbackChannel().error(sModule, "Caught exception while handling stream message.", e);
            }
        }
    }

    public void postOfficeAdded(PostOfficeSpecifier postOffice) {
    }

    public void postOfficeRemoved(PostOfficeSpecifier postOffice) {
        Address subscribeTo = this.fSubscribedTo;
        if (subscribeTo != null && postOffice.equals(subscribeTo.getPostOffice())) {
            this.publisherStoppedInternal();
        }
    }
}

