/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.synchronizer;

import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.sink.IMessageSink;
import com.wily.isengard.messageprimitives.sink.IRawMessageSink;
import com.wily.isengard.messageprimitives.sink.ISinkNotification;
import com.wily.isengard.messageprimitives.sink.MessageSink;
import com.wily.isengard.messageprimitives.stream.MessageStreamPublisher;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import java.lang.reflect.Method;

public class MessageSynchronizer
extends MessageStreamPublisher {
    private LocalSink fLocalSink;
    private boolean fIsPublishing = false;

    public MessageSynchronizer(PostOffice po, Class interfaceClass) throws InvalidIsengardInterface {
        super(po, interfaceClass);
        this.fLocalSink = new LocalSink(po, interfaceClass);
    }

    public void close() {
        this.fLocalSink.close();
        super.close();
    }

    public Address getSinkAddress() {
        return this.fLocalSink.getAddress();
    }

    protected final void startPublishing() {
        this.fIsPublishing = true;
    }

    protected final void stopPublishing() {
        this.fIsPublishing = false;
    }

    protected final Object replyToSubscription() {
        return this.fLocalSink.getAddress();
    }

    public void SubscriptionsFinished() {
    }

    private class LocalSink
    implements IRawMessageSink,
    ISinkNotification {
        private MessageSink fSink;

        public LocalSink(PostOffice po, Class interfaceClass) throws InvalidIsengardInterface {
            this.fSink = new MessageSink(po, interfaceClass, this);
        }

        public void close() {
            this.fSink.close();
        }

        public Address getAddress() {
            return this.fSink.getAddress();
        }

        public Object rawMethodHandler(Method method, int interfaceVersion, Object[] params) {
            if (MessageSynchronizer.this.fIsPublishing) {
                MessageSynchronizer.this.sendData(method, params);
            }
            return null;
        }

        public IMessageSink sinkPublisherStarted(Address address) {
            return this;
        }

        public void sinkPublisherStopped(Address address) {
        }
    }
}

