/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link;

import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postofficehub.link.ClientHandShaker;
import com.wily.isengard.postofficehub.link.IOutgoingConnection;
import com.wily.isengard.postofficehub.link.IRemoteClientTransport;
import com.wily.isengard.postofficehub.link.IRemoteTransport;
import com.wily.isengard.postofficehub.link.TransportFactory;
import com.wily.isengard.postofficehub.link.http.HttpTransportAdapter;
import com.wily.isengard.postofficehub.link.http.client.HttpTunnelingClientLifecycleManager;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;

public class HttpOutgoingConnection
implements IOutgoingConnection {
    private static Module sModule = new Module("HttpOutgoingConnection");
    private final TransportConfiguration fTransportConfig;
    private final ServerInstanceLocator fLocator;
    private final PostOfficeHub fHub;
    private final IModuleFeedbackChannel fFeedback;
    private IRemoteClientTransport fTransport;
    private HttpTransportAdapter fTransportAdapter;
    private HttpTunnelingClientLifecycleManager fTunnelingClientMgr;

    public HttpOutgoingConnection(TransportConfiguration transportConfig, ServerInstanceLocator locator, PostOfficeHub hub) {
        this.fTransportConfig = transportConfig;
        this.fLocator = locator;
        this.fHub = hub;
        this.fFeedback = hub.getFeedbackChannel();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String connect(String groupName, String credential) throws IOException {
        String hubName = null;
        IRemoteClientTransport transport = null;
        try {
            this.fTransportAdapter = new HttpTransportAdapter(this.fLocator);
            TransportFactory factory = new TransportFactory();
            transport = factory.newHttpTransportInstance(this.fTransportAdapter, 3);
            transport.setThreadFactory(this.fHub.getThreadFactory());
            transport.setTransportConfiguration(this.fTransportConfig);
            IModuleFeedbackChannel feedback = this.getFeedbackChannel();
            this.fTunnelingClientMgr = new HttpTunnelingClientLifecycleManager(this.fTransportAdapter, feedback);
            if (feedback.isDebugEnabled(sModule)) {
                feedback.debug(sModule, "Established client connection: host: " + this.fLocator.getHostName() + ", port: " + this.fLocator.getPort() + ", socket send buffer size [bytes]: " + this.fLocator.getSocketSendBufferSize() + ", socket receive buffer size [bytes]: " + this.fLocator.getSocketReceiveBufferSize());
            }
            this.fTunnelingClientMgr.start(this.fHub.getThreadFactory(), "HTTP Tunneling Client");
            ClientHandShaker handShaker = new ClientHandShaker();
            handShaker.doInitialHandshake(transport);
            transport.initialize(this.fHub);
            hubName = transport.connect(groupName, credential, new IndexedProperties());
            this.fTransport = transport;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeTransportOnConnectionFailure(hubName, transport);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.closeTransportOnConnectionFailure(hubName, transport);
            return hubName;
        }
    }

    public boolean isConnected() {
        return this.fTransport != null && !this.fTransport.isClosed();
    }

    public void close() {
        if (this.isConnected()) {
            this.fTransport.close();
        }
        this.closeTunnelingClient();
        this.closeTransportAdapter();
    }

    private void closeTransportOnConnectionFailure(String hubName, IRemoteTransport transport) {
        if (hubName == null && transport != null) {
            transport.close();
            this.closeTunnelingClient();
            this.closeTransportAdapter();
        }
    }

    private void closeTransportAdapter() {
        if (this.fTransportAdapter != null) {
            this.fTransportAdapter.close();
        }
    }

    private void closeTunnelingClient() {
        if (this.fTunnelingClientMgr != null) {
            this.fTunnelingClientMgr.stop(true);
        }
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }
}

