/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.registry;

import com.wily.isengard.registry.IRegistryServiceLocal;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.DirectoryPathAndEntry;
import com.wily.isengard.util.tree.DirectoryPathTokenizer;
import com.wily.isengard.util.tree.DirectoryTreeNode;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import java.util.Iterator;
import java.util.LinkedList;

public class RegistryServiceLocal
implements IRegistryServiceLocal {
    private DirectoryTreeNode fTreeRoot = new DirectoryTreeNode(null, "", null);

    public synchronized void addEntry(DirectoryPath path, RegistryEntry entry) throws EntryAlreadyExistsException {
        DirectoryPathTokenizer pathTokenizer = new DirectoryPathTokenizer(path);
        this.fTreeRoot.addIfNotExists(pathTokenizer, entry);
    }

    public synchronized void deleteEntry(DirectoryPath path) throws InvalidPathException {
        DirectoryPathTokenizer pathTokenizer = new DirectoryPathTokenizer(path);
        this.fTreeRoot.deleteEntry(pathTokenizer);
    }

    public synchronized RegistryEntry getEntry(DirectoryPath path) throws InvalidPathException, EntryNotFoundException {
        DirectoryPathTokenizer pathTokenizer = new DirectoryPathTokenizer(path);
        return (RegistryEntry)this.fTreeRoot.getEntry(pathTokenizer);
    }

    public synchronized String[] getSubDirectories(DirectoryPath path) throws InvalidPathException {
        DirectoryPathTokenizer pathTokenizer = new DirectoryPathTokenizer(path);
        LinkedList<String> results = new LinkedList<String>();
        Iterator iterator = this.fTreeRoot.getSubDirectoryIterator(pathTokenizer);
        while (iterator.hasNext()) {
            DirectoryPathAndEntry entry = (DirectoryPathAndEntry)iterator.next();
            results.add(entry.getPath().getPathString());
        }
        return results.toArray(new String[results.size()]);
    }
}

