/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.io;

import com.wily.isengard.util.io.CustomSerializationThrowableCarrier;
import com.wily.isengard.util.io.ISerializationHandler;
import com.wily.isengard.util.io.SerializationNotSupportedException;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.IKeyedClassLoader;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ThrowableOnlySerializationHandler
implements ISerializationHandler {
    private static final String kLineSeparator = System.getProperty("line.separator");
    private final IModuleFeedbackChannel fFeedback;
    private final Module fModule;

    public ThrowableOnlySerializationHandler(IModuleFeedbackChannel feedback, Module module) {
        CheckParameter.notNull("Feedback Channel", feedback);
        CheckParameter.notNull("Module", module);
        this.fFeedback = feedback;
        this.fModule = module;
    }

    public void serialize(ObjectOutput output, Object object, IKeyedClassLoader keyedClassLoader) throws IOException {
        if (!(object instanceof Throwable)) {
            throw new SerializationNotSupportedException(object);
        }
        String classLoaderName = keyedClassLoader.getClassLoaderKey(object.getClass());
        Assertion.wilyAssert(classLoaderName != null, "Classloader for class " + object.getClass().getName() + " was not registered.");
        output.writeUTF(classLoaderName);
        Throwable throwable = (Throwable)object;
        CustomSerializationThrowableCarrier carrier = new CustomSerializationThrowableCarrier(throwable);
        output.writeObject(carrier);
    }

    public Object deserialize(ObjectInput input, IKeyedClassLoader keyedClassLoader) throws ClassNotFoundException, IOException {
        String classLoaderName = input.readUTF();
        CustomSerializationThrowableCarrier carrier = (CustomSerializationThrowableCarrier)input.readObject();
        if (carrier.atTopOfChain()) {
            if (carrier.getMessage() == null) {
                this.fFeedback.verbose(this.fModule, "Explicit Deserialization required for Throwable: " + carrier.getClassName());
            } else {
                this.fFeedback.verbose(this.fModule, "Explicit Deserialization required for Throwable: " + carrier.getClassName() + "; with Message: " + carrier.getMessage());
            }
            if (this.fFeedback.isDebugEnabled() && carrier.getStackTrace() != null) {
                this.fFeedback.debug(this.fModule, "Stacktrace: " + kLineSeparator + carrier.getStackTrace());
            }
        }
        Throwable throwable = carrier.reconstitute(keyedClassLoader, classLoaderName, this.fFeedback, this.fModule);
        return throwable;
    }
}

