/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io;

import com.wily.org.apache.commons.io.FilenameUtils;
import com.wily.org.apache.commons.io.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE = new FileSystemUtils();
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int OS;

    static {
        int os = 0;
        try {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new IOException("os.name not found");
            }
            os = (osName = osName.toLowerCase()).indexOf("windows") != -1 ? 1 : (osName.indexOf("linux") != -1 || osName.indexOf("sun os") != -1 || osName.indexOf("sunos") != -1 || osName.indexOf("solaris") != -1 || osName.indexOf("mpe/ix") != -1 || osName.indexOf("hp-ux") != -1 || osName.indexOf("aix") != -1 || osName.indexOf("freebsd") != -1 || osName.indexOf("irix") != -1 || osName.indexOf("digital unix") != -1 || osName.indexOf("unix") != -1 || osName.indexOf("mac os x") != -1 ? 2 : 0);
        }
        catch (Exception ex) {
            os = -1;
        }
        OS = os;
    }

    public static long freeSpace(String path) throws IOException {
        return INSTANCE.freeSpaceOS(path, OS);
    }

    long freeSpaceOS(String path, int os) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (os) {
            case 1: {
                return this.freeSpaceWindows(path);
            }
            case 2: {
                return this.freeSpaceUnix(path);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long freeSpaceWindows(String path) throws IOException {
        if ((path = FilenameUtils.normalize(path)).length() > 2 && path.charAt(1) == ':') {
            path = path.substring(0, 2);
        }
        String[] cmdAttrbs = new String[]{"cmd.exe", "/C", "dir /c " + path};
        BufferedReader in = null;
        String line = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            in = this.openProcessStream(cmdAttrbs);
            line = in.readLine();
            while (line != null) {
                line = line.toLowerCase().trim();
                lines.add(line);
                line = in.readLine();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        IOUtils.closeQuietly(in);
        if (lines.size() == 0) {
            throw new IOException("Command line 'dir /c' did not return any info for command '" + cmdAttrbs[2] + "'");
        }
        long bytes = -1L;
        int i = lines.size() - 1;
        int bytesStart = 0;
        int bytesEnd = 0;
        block4: while (i > 0) {
            char c;
            line = (String)lines.get(i);
            if (line.length() <= 0) continue;
            int j = line.length() - 1;
            while (j >= 0) {
                c = line.charAt(j);
                if (Character.isDigit(c)) {
                    bytesEnd = j + 1;
                    break;
                }
                --j;
            }
            while (j >= 0) {
                c = line.charAt(j);
                if (!Character.isDigit(c) && c != ',' && c != '.') {
                    bytesStart = j + 1;
                    break block4;
                }
                --j;
            }
            break block4;
        }
        StringBuffer buf = new StringBuffer(line.substring(bytesStart, bytesEnd));
        int k = 0;
        while (k < buf.length()) {
            if (buf.charAt(k) == ',' || buf.charAt(k) == '.') {
                buf.deleteCharAt(k--);
            }
            ++k;
        }
        return Long.parseLong(buf.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long freeSpaceUnix(String path) throws IOException {
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        path = FilenameUtils.normalize(path);
        String[] cmdAttribs = new String[]{"df", path};
        long bytes = -1L;
        BufferedReader in = null;
        try {
            StringTokenizer tok;
            block11: {
                in = this.openProcessStream(cmdAttribs);
                String line1 = in.readLine();
                String line2 = in.readLine();
                String line3 = in.readLine();
                if (line2 == null) {
                    throw new IOException("Command line 'df' did not return info as expected for path '" + path + "'- response on first line was '" + line1 + "'");
                }
                tok = new StringTokenizer(line2 = line2.trim(), " ");
                if (tok.countTokens() < 4) {
                    if (tok.countTokens() == 1 && line3 != null) {
                        line3 = line3.trim();
                        tok = new StringTokenizer(line3, " ");
                        break block11;
                    } else {
                        throw new IOException("Command line 'df' did not return data as expected for path '" + path + "'- check path is valid");
                    }
                }
                tok.nextToken();
            }
            tok.nextToken();
            tok.nextToken();
            String freeSpace = tok.nextToken();
            try {
                bytes = Long.parseLong(freeSpace);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Command line 'df' did not return numeric data as expected for path '" + path + "'- check path is valid");
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        {
            Object var12_13 = null;
        }
        IOUtils.closeQuietly(in);
        if (bytes < 0L) {
            throw new IOException("Command line 'df' did not find free space in response for path '" + path + "'- check path is valid");
        }
        return bytes;
    }

    BufferedReader openProcessStream(String[] params) throws IOException {
        Process proc = Runtime.getRuntime().exec(params);
        return new BufferedReader(new InputStreamReader(proc.getInputStream()));
    }
}

