/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueWrapper {
    final int fMaxSize;
    final AtomicInteger estimateCount = new AtomicInteger();
    final ConcurrentLinkedQueue list = new ConcurrentLinkedQueue();

    public QueueWrapper(int maxSize) {
        this.fMaxSize = maxSize;
    }

    public int offer(Object obj) {
        int estimate = this.estimateCount.incrementAndGet();
        if (estimate <= this.fMaxSize) {
            this.list.offer(obj);
        } else {
            estimate = this.estimateCount.decrementAndGet();
        }
        return estimate;
    }

    public void removeCurrentInIterator(Iterator<?> i) {
        try {
            i.remove();
            this.estimateCount.decrementAndGet();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public Iterator<?> iterator() {
        return this.list.iterator();
    }

    public int size() {
        return this.list.size();
    }

    public int getEstimateSize() {
        return this.estimateCount.get();
    }
}

