/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;

public final class ExtensionUtilities {
    private static final int kNoExpectedVersion = -1;
    private static final Class kNoExpectedType = null;

    private ExtensionUtilities() {
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin) {
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, -1, kNoExpectedType, null, null);
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, expectedVersion, kNoExpectedType, null, null);
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, Class expectedType) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, -1, expectedType, null, null);
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, expectedVersion, expectedType, null, null);
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, Class[] parameterTypes, Object[] initargs) {
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, -1, kNoExpectedType, parameterTypes, initargs);
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class[] parameterTypes, Object[] initargs) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, expectedVersion, kNoExpectedType, parameterTypes, initargs);
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, Class expectedType, Class[] parameterTypes, Object[] initargs) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, -1, expectedType, parameterTypes, initargs);
    }

    public static final Object createEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType, Class[] parameterTypes, Object[] initargs) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doCreateEntryPointClass(feedback, localizer, plugin, expectedVersion, expectedType, parameterTypes, initargs);
    }

    public static final Object createClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType, String className, Class[] parameterTypes, Object[] initargs) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doCreateClass(feedback, localizer, plugin, expectedVersion, expectedType, className, parameterTypes, initargs);
    }

    private static final Object doCreateEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType, Class[] parameterTypes, Object[] initargs) {
        Assertion.wilyAssert(false);
        String className = plugin.IPlugin_getEntryPointClassName();
        return ExtensionUtilities.doCreateClass(feedback, localizer, plugin, expectedVersion, expectedType, className, parameterTypes, initargs);
    }

    private static final Object doCreateClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType, String className, Class[] parameterTypes, Object[] initargs) {
        Object instance = null;
        Class pluginClass = ExtensionUtilities.doLoadClass(feedback, localizer, plugin, expectedVersion, className, expectedType);
        if (pluginClass != null) {
            instance = ExtensionUtilities.createNewInstance(feedback, localizer, plugin, pluginClass, parameterTypes, initargs);
        }
        return instance;
    }

    public static Class loadEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin) {
        return ExtensionUtilities.doLoadEntryPointClass(feedback, localizer, plugin, -1, kNoExpectedType, null);
    }

    public static Class loadEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doLoadEntryPointClass(feedback, localizer, plugin, expectedVersion, kNoExpectedType, null);
    }

    public static Class loadEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, Class expectedType) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doLoadEntryPointClass(feedback, localizer, plugin, -1, expectedType, null);
    }

    public static Class loadEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType) {
        return ExtensionUtilities.loadEntryPointClass(feedback, localizer, plugin, expectedVersion, expectedType, null);
    }

    public static Class loadEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType, IValidationFeedbackChannel validationFeedbackChannel) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doLoadEntryPointClass(feedback, localizer, plugin, expectedVersion, expectedType, validationFeedbackChannel);
    }

    private static Class doLoadEntryPointClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, Class expectedType, IValidationFeedbackChannel validationFeedbackChannel) {
        Assertion.wilyAssert(false);
        return ExtensionUtilities.doLoadClass(feedback, localizer, plugin, expectedVersion, plugin.IPlugin_getEntryPointClassName(), expectedType, validationFeedbackChannel);
    }

    private static final Class doLoadClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, String className, Class expectedType) {
        return ExtensionUtilities.doLoadClass(feedback, localizer, plugin, expectedVersion, className, expectedType, null);
    }

    private static final Class doLoadClass(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion, String className, Class expectedType, IValidationFeedbackChannel validationFeedbackChannel) {
        Class<?> pluginClass;
        block4: {
            Assertion.wilyAssert(false);
            Assertion.wilyAssert(false);
            pluginClass = null;
            if (expectedVersion == -1 || ExtensionUtilities.isExpectedVersion(feedback, localizer, plugin, expectedVersion)) {
                try {
                    ClassLoader classloader = plugin.IPlugin_getOwningExtension().IExtension_getClassLoader();
                    pluginClass = classloader.loadClass(className);
                    if (expectedType != kNoExpectedType && !ExtensionUtilities.isExpectedType(feedback, localizer, plugin, pluginClass, expectedType)) {
                        pluginClass = null;
                    }
                }
                catch (ClassNotFoundException t) {
                    String errorMessage = MessageFormat.format("Could not find entry point class {3} for plugin \"{2}\" in extension \"{1}\" loaded from \"{0}\"", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName(), className);
                    feedback.error(errorMessage);
                    if (validationFeedbackChannel == null) break block4;
                    validationFeedbackChannel.error(errorMessage, t);
                }
            }
        }
        return pluginClass;
    }

    public static boolean isExpectedVersion(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, int expectedVersion) {
        boolean result;
        boolean bl = result = plugin.IPlugin_getVersion() == expectedVersion;
        if (!result) {
            feedback.error(localizer.IStringLocalizer_getFormattedLocalizedString("Extension_Unexpected_Plugin_Version_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName(), String.valueOf(expectedVersion), String.valueOf(plugin.IPlugin_getVersion())));
        }
        return result;
    }

    public static boolean isExpectedType(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, Class pluginClass, Class expectedType) {
        boolean result = expectedType.isAssignableFrom(pluginClass);
        if (!result) {
            feedback.error(localizer.IStringLocalizer_getFormattedLocalizedString("Extension_Class_Is_Not_Expected_Type_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName(), pluginClass.getName(), expectedType.getName()));
        }
        return result;
    }

    public static Object createNewInstance(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, Class pluginClass) {
        return ExtensionUtilities.createNewInstance(feedback, localizer, plugin, pluginClass, null, null);
    }

    public static Object createNewInstance(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IPlugin plugin, Class pluginClass, Class[] parameterTypes, Object[] initargs) {
        Object instance = null;
        try {
            Constructor c = pluginClass.getConstructor(parameterTypes);
            instance = c.newInstance(initargs);
        }
        catch (Throwable t) {
            feedback.error(localizer.IStringLocalizer_getFormattedLocalizedString("Extension_Create_New_Instance_Failed_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName(), pluginClass.getName()));
            feedback.verbose(t);
        }
        return instance;
    }
}

