/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.preflight.modules;

import com.wily.util.preflight.KPreflightErrorMessages;
import com.wily.util.preflight.PreflightCaptain;
import com.wily.util.preflight.PreflightMessage;
import com.wily.util.preflight.modules.IPreflightModule;
import com.wily.util.preflight.modules.LibraryDescriptor;
import com.wily.util.preflight.modules.LibraryModule;

public class LibraryListModule
implements IPreflightModule,
KPreflightErrorMessages {
    private final LibraryModule[] fModules;
    private final String fCustomErrorMessageSegment;

    public LibraryListModule(LibraryModule[] modules, String customErrorMessageSegment) {
        this.fModules = modules;
        this.fCustomErrorMessageSegment = customErrorMessageSegment;
    }

    public LibraryListModule(LibraryDescriptor[] descriptorArray, String customErrorMessageSegment) {
        this(LibraryListModule.makeModuleArray(descriptorArray), customErrorMessageSegment);
    }

    private static LibraryModule[] makeModuleArray(LibraryDescriptor[] descriptorArray) {
        int limit = descriptorArray.length;
        LibraryModule[] result = new LibraryModule[limit];
        int i = 0;
        while (i < limit) {
            result[i] = new LibraryModule(descriptorArray[i]);
            ++i;
        }
        return result;
    }

    public PreflightMessage[] IPreflightModule_doCheck() {
        PreflightMessage[] messageList = PreflightCaptain.performCheck(this.fModules);
        boolean succeeded = true;
        boolean fatal = false;
        int i = 0;
        while (i < messageList.length) {
            succeeded = succeeded && messageList[i].isSuccessful();
            fatal = fatal || messageList[i].isFatal();
            ++i;
        }
        if (!succeeded) {
            PreflightMessage[] temp = messageList;
            messageList = new PreflightMessage[temp.length + 2];
            System.arraycopy(temp, 0, messageList, 0, temp.length);
            int nextIndex = temp.length;
            messageList[nextIndex++] = new PreflightMessage(this.fCustomErrorMessageSegment, succeeded, fatal);
            StringBuffer classPathMessage = new StringBuffer();
            classPathMessage.append("Your class path is: ");
            classPathMessage.append(System.getProperty("java.class.path"));
            messageList[nextIndex++] = new PreflightMessage(classPathMessage.toString(), succeeded, fatal);
        }
        return messageList;
    }
}

