/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extensions.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.extensions.KIntroscopeExtensionConstants;
import com.wily.introscope.agent.extensions.transactiontrace.BoundaryOnlyBlameStack;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class MapEnablingTracer
extends ASingleInstanceTracerFactory {
    private String fName;
    private static final String kMetricSeparator = "|";
    private static final String kShouldMapTracerRun = "shouldMapTracerRun";

    public MapEnablingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        Boolean res = (Boolean)data.get(kShouldMapTracerRun);
        if (res != null && !res.booleanValue()) {
            return;
        }
        String component = data.getComponentNameAt(tracerIndex);
        IBlameStack stack = data.getStack(componentTracer, true);
        componentTracer.removeMapComponent(stack, BoundaryOnlyBlameStack.kStackType, component);
    }

    private boolean isNodeTypeValid(String nodeType) {
        boolean valid = false;
        int type = -1;
        if (nodeType != null) {
            try {
                type = Integer.parseInt(nodeType);
            }
            catch (NumberFormatException numberFormatException) {
                type = -1;
            }
        }
        if (type > 0) {
            valid = true;
        } else {
            this.getAgent().IAgent_getModuleFeedback().debug("MapEnablingTracer will not run for this component: tracerParameter nodeType has to be set to a positive integer (" + nodeType + ")");
        }
        return valid;
    }

    public String getNodeType(InvocationData data) {
        return this.getParameter("nodeType");
    }

    public void decorateOptionalParams(HashMap params, InvocationData data) {
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String component = this.getMapComponent(data);
        ComponentTracer componentTracer = this.getComponentTracer();
        SharedCrossProcessData cache = componentTracer.getCrossProcessDataCache();
        String[] triplet = this.getAgent().IAgent_getHostProcessAgentTriplet();
        StringBuffer temp = new StringBuffer();
        if (triplet.length == 3) {
            int i = 0;
            while (i < triplet.length) {
                if (triplet[i] == null) {
                    if (this.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                        this.getAgent().IAgent_getModuleFeedback().debug("MapEnablingTracer: error while accessing agent name (has null strings). MapTracer will not run for this invocation of  " + component);
                    }
                    data.put(kShouldMapTracerRun, (Object)new Boolean(false));
                    return;
                }
                if (triplet[i].trim().length() == 0) {
                    if (this.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                        this.getAgent().IAgent_getModuleFeedback().debug("MapEnablingTracer: error while accessing agent name (has empty strings). MapTracer will not run for this invocation of  " + component);
                    }
                    data.put(kShouldMapTracerRun, (Object)new Boolean(false));
                    return;
                }
                temp.append(triplet[i]);
                temp.append(kMetricSeparator);
                ++i;
            }
        } else {
            if (this.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                this.getAgent().IAgent_getModuleFeedback().debug("MapEnablingTracer: error while accessing agent name. MapTracer may not run correctly for " + component);
            }
            data.put(kShouldMapTracerRun, (Object)new Boolean(false));
            return;
        }
        temp.append(component);
        String currentOutgoingNode = temp.toString();
        if (cache != null) {
            cache.setOutgoingCallerNodeId(currentOutgoingNode);
        }
        data.setComponentNameAt(component, tracerIndex);
        String nodeType = this.getNodeType(data);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KIntroscopeExtensionConstants.kOutgoingNode, currentOutgoingNode);
        this.decorateOptionalParams(params, data);
        String paramVal1 = this.fetchCurentOutgoingSeqId(cache);
        String paramName1 = "OutgoingSeqNo";
        if (paramVal1 != null) {
            params.put(paramName1, paramVal1);
        }
        if (this.isNodeTypeValid(nodeType)) {
            params.put("nodeType", nodeType);
            IBlameStack stack = data.getStack(componentTracer, true);
            componentTracer.addMapComponent(stack, BoundaryOnlyBlameStack.kStackType, component, params);
            if (cache != null) {
                cache.setOutgoingCallerNodeType(nodeType);
            }
        } else {
            data.put(kShouldMapTracerRun, (Object)new Boolean(false));
            return;
        }
    }

    private String fetchCurentOutgoingSeqId(SharedCrossProcessData cache) {
        SequenceId seq;
        String outSeqId = null;
        if (cache != null && (seq = cache.getSeqID()) != null) {
            outSeqId = seq.getSequenceIdOutgoingFormat();
        }
        return outSeqId;
    }

    private String getMapComponent(InvocationData data) {
        String component = this.formatParameterizedName(data);
        return component;
    }
}

