/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.launch;

import com.ca.apm.introscope.upgrade.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentClassLoader
extends URLClassLoader {
    private volatile boolean fClose;

    public AgentClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public synchronized void close() {
        this.fClose = true;
        ClassLoaderUtils utils = new ClassLoaderUtils();
        utils.close(this);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.fClose) {
            throw new ClassNotFoundException(name);
        }
        return super.findClass(name);
    }

    @Override
    public URL findResource(String name) {
        if (this.fClose) {
            return null;
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.fClose) {
            return null;
        }
        return super.findResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.fClose) {
            return null;
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.fClose) {
            throw new ClassNotFoundException(name);
        }
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.fClose) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = this.findLoadedClass(name);
        ClassLoader parentCL = this.getParent();
        if (clazz == null && parentCL != null && name.startsWith("java.")) {
            clazz = parentCL.loadClass(name);
        }
        if (clazz == null) {
            try {
                clazz = super.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null && parentCL != null && !AgentClassLoader.isApmClass(name)) {
            clazz = parentCL.loadClass(name);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private static boolean isApmClass(String name) {
        boolean apmClass = false;
        if (name != null && (name.startsWith("com.wily.") || name.startsWith("com.ca.") || name.startsWith("agent."))) {
            apmClass = true;
        }
        return apmClass;
    }
}

