/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.upgrade.KLauncherConstants;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnitMetadata {
    private String fName;
    private String fProvider;
    private String fVersion;
    private String fCreatedBy;
    private String fCreatedOn;
    private Map<String, Unit> fOrderToUnitMap = new LinkedHashMap<String, Unit>();
    private Map<String, Unit> fNametoUnitMap = new HashMap<String, Unit>();
    private int fOrder;
    private Set<String> fAgentJars = new HashSet<String>();

    public InstallableUnitMetadata() {
    }

    public InstallableUnitMetadata(String name, String provider, String version) {
        this.fName = name;
        this.fProvider = provider;
        this.fVersion = version;
        this.fCreatedBy = System.getProperty("user.name", "unknown user");
        this.fCreatedOn = new Date().toString();
    }

    public void addUnit(String name, long size) {
        ++this.fOrder;
        Unit unit = new Unit(name, size);
        this.fOrderToUnitMap.put(Integer.toString(this.fOrder), unit);
        this.fNametoUnitMap.put(name, unit);
    }

    public boolean addEntry(String entry) {
        boolean success = true;
        String[] tokens = entry.split("=");
        if (tokens.length == 2) {
            if (tokens[0].equalsIgnoreCase("installable.unit.name")) {
                this.fName = tokens[1];
            } else if (tokens[0].equalsIgnoreCase("installable.unit.provider")) {
                this.fProvider = tokens[1];
            } else if (tokens[0].equalsIgnoreCase("installable.unit.version")) {
                this.fVersion = tokens[1];
            } else if (tokens[0].equalsIgnoreCase("installable.unit.created.by")) {
                this.fCreatedBy = tokens[1];
            } else if (tokens[0].equalsIgnoreCase("installable.unit.created.on")) {
                this.fCreatedOn = tokens[1];
            } else {
                String[] keys = tokens[0].split("\\.");
                if (keys.length >= 3 && keys[0].equalsIgnoreCase("units")) {
                    String order = keys[1];
                    Unit unit = this.fOrderToUnitMap.get(order);
                    if (unit == null) {
                        unit = new Unit();
                        this.fOrderToUnitMap.put(order, unit);
                    }
                    if (keys[2].equalsIgnoreCase("name")) {
                        unit.fName = tokens[1];
                        this.fNametoUnitMap.put(tokens[1], unit);
                        String name = unit.fName;
                        if (name.startsWith("upgrade")) {
                            name = name.substring("upgrade".length() + 1);
                        }
                        if (KLauncherConstants.sPattern.matcher(name).matches()) {
                            this.fAgentJars.add(name.toLowerCase());
                        }
                    } else if (keys[2].equalsIgnoreCase("size")) {
                        try {
                            long size = Long.parseLong(tokens[1]);
                            unit.fSize = size;
                        }
                        catch (NumberFormatException numberFormatException) {
                            success = false;
                        }
                    }
                } else {
                    success = false;
                }
            }
        } else {
            success = false;
        }
        return success;
    }

    public String getName() {
        return this.fName;
    }

    public String getProvider() {
        return this.fProvider;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getCreatedBy() {
        return this.fCreatedBy;
    }

    public String getCreatedOn() {
        return this.fCreatedOn;
    }

    public boolean validate(Unit otherUnit) {
        boolean success = false;
        Unit unit = this.fNametoUnitMap.get(otherUnit.fName);
        if (unit != null && unit.equals(otherUnit)) {
            success = true;
        } else {
            System.err.println(otherUnit);
        }
        return success;
    }

    public boolean validate(List<Unit> units) {
        boolean success = true;
        if (this.fNametoUnitMap.isEmpty() || this.fNametoUnitMap.size() != units.size()) {
            System.err.println("Number of artifacts in installable unit doesn't match the metadata.");
            return false;
        }
        HashSet<String> keys = new HashSet<String>(this.fNametoUnitMap.keySet());
        for (Unit otherUnit : units) {
            Unit unit = this.fNametoUnitMap.get(otherUnit.fName);
            keys.remove(otherUnit.fName);
            if (unit.equals(otherUnit)) continue;
            success = false;
            System.err.println("Problem with: " + unit);
            break;
        }
        if (success && !keys.isEmpty()) {
            success = false;
            System.err.println("Missing artifact(s).");
        }
        return success;
    }

    public boolean hasAgentJar(String agentJarName) {
        return this.fAgentJars.contains(agentJarName.toLowerCase());
    }

    public boolean hasAgentJars() {
        return !this.fAgentJars.isEmpty();
    }

    public String getXmlFormattedMetadata() {
        StringBuilder strBldr = new StringBuilder();
        strBldr.append("<installable-unit>\n").append("\t<name>" + this.fName + "</" + "name" + ">\n").append("\t<provider>" + this.fProvider + "</" + "provider" + ">\n").append("\t<version>" + this.fVersion + "</" + "version" + ">\n").append("\t<created-by>" + this.fCreatedBy + "</" + "created-by" + ">\n").append("\t<created-on>" + this.fCreatedOn + "</" + "created-on" + ">\n").append("</installable-unit>");
        return strBldr.toString();
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder();
        strBldr.append("installable.unit.name=" + this.fName + "\n").append("installable.unit.provider=" + this.fProvider + "\n").append("installable.unit.version=" + this.fVersion + "\n").append("installable.unit.created.by=" + this.fCreatedBy + "\n").append("installable.unit.created.on=" + this.fCreatedOn + "\n");
        for (String order : this.fOrderToUnitMap.keySet()) {
            Unit unit = this.fOrderToUnitMap.get(order);
            strBldr.append("units." + order + ".name" + "=" + unit.fName + "\n").append("units." + order + ".size" + "=" + unit.fSize + "\n");
        }
        return strBldr.toString();
    }

    public static class Unit {
        private String fName;
        private long fSize;

        public Unit() {
        }

        public Unit(String name, long size) {
            this.fName = name;
            this.fSize = size;
        }

        public int hashCode() {
            int result = 17;
            int hash = this.fName == null ? 0 : this.fName.hashCode();
            result = 31 * result + hash;
            result = 31 * result + (int)(this.fSize ^ this.fSize >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            boolean retValue = false;
            if (this == obj) {
                retValue = true;
            } else if (obj instanceof Unit) {
                Unit otherObj = (Unit)obj;
                if (this.fName != null && this.fName.equals(otherObj.fName) && this.fSize == otherObj.fSize) {
                    retValue = true;
                }
            }
            return retValue;
        }

        public String toString() {
            StringBuilder strBldr = new StringBuilder("Class: Unit");
            strBldr.append("\n\tName: " + this.fName).append("\n\tSize: " + this.fSize);
            return strBldr.toString();
        }
    }
}

