/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LaunchProperties {
    private List<String> fLines = new ArrayList<String>();
    private Map<String, String> fProperties = new HashMap<String, String>();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public String getProperty(String key) {
        return this.fProperties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.fProperties.get(key);
        return value == null ? defaultValue : value;
    }

    public synchronized String put(String key, String value) {
        String retValue = null;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (!this.fProperties.containsKey(key)) {
            this.fLines.add(key);
        }
        retValue = this.fProperties.get(key);
        this.fProperties.put(key, value);
        return retValue;
    }

    public synchronized void load(InputStream istream) throws IOException {
        int limit;
        char[] buffer = new char[1024];
        LineReader reader = new LineReader(istream);
        while ((limit = reader.readLine()) >= 0) {
            char aChar = reader.fLine[0];
            if (aChar == '#' || aChar == '!') {
                this.parseComment(reader.fLine, limit, buffer);
                continue;
            }
            this.parseProperty(reader.fLine, limit, buffer);
        }
    }

    public synchronized void store(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        for (String line : this.fLines) {
            if (line.trim().length() == 0) {
                writer.newLine();
                continue;
            }
            char aChar = line.charAt(0);
            if (aChar == '#' || aChar == '!') {
                String comment = line;
                writer.write(comment);
                writer.newLine();
                continue;
            }
            String key = line;
            String value = this.getProperty(key);
            key = this.saveConvert(key, true);
            value = this.saveConvert(value, false);
            writer.write(String.valueOf(key) + "=" + value);
            writer.newLine();
        }
        writer.flush();
    }

    public synchronized void clear() {
        this.fLines.clear();
        this.fProperties.clear();
    }

    private void parseComment(char[] line, int limit, char[] buffer) {
        String comment = this.loadConvert(line, 0, limit, buffer);
        this.fLines.add(comment);
    }

    private void parseProperty(char[] line, int limit, char[] buffer) {
        int keyLen = 0;
        int valueStart = limit;
        char aChar = '\u0000';
        boolean hasSep = false;
        boolean precedingBackslash = false;
        while (keyLen < limit) {
            aChar = line[keyLen];
            if (!(aChar != '=' && aChar != ':' || precedingBackslash)) {
                valueStart = keyLen + 1;
                hasSep = true;
                break;
            }
            if (!(aChar != ' ' && aChar != '\t' && aChar != '\f' || precedingBackslash)) {
                valueStart = keyLen + 1;
                break;
            }
            precedingBackslash = aChar == '\\' ? !precedingBackslash : false;
            ++keyLen;
        }
        while (valueStart < limit) {
            aChar = line[valueStart];
            if (aChar != ' ' && aChar != '\t' && aChar != '\f') {
                if (hasSep || aChar != '=' && aChar != ':') break;
                hasSep = true;
            }
            ++valueStart;
        }
        String key = this.loadConvert(line, 0, keyLen, buffer);
        String value = this.loadConvert(line, valueStart, limit - valueStart, buffer);
        this.put(key, value);
    }

    private String loadConvert(char[] input, int off, int len, char[] buffer) {
        if (buffer.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            buffer = new char[newLen];
        }
        char[] out = buffer;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = input[off++]) == 92) {
                if ((aChar = input[off++]) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = input[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(LaunchProperties.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(LaunchProperties.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(LaunchProperties.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(LaunchProperties.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    class LineReader {
        byte[] inBuf = new byte[8192];
        char[] fLine = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream fIstream;

        public LineReader(InputStream istream) {
            this.fIstream = istream;
        }

        int readLine() throws IOException {
            int len = 0;
            char aChar = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            int newLineCount = 0;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.fIstream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                aChar = (char)(0xFF & this.inBuf[this.inOff++]);
                if (skipLF) {
                    skipLF = false;
                    if (aChar == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (aChar == ' ' || aChar == '\t' || aChar == '\f') continue;
                    if (!(appendedLineBegin || aChar != '\r' && aChar != '\n')) {
                        ++newLineCount;
                        continue;
                    }
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                    if (newLineCount > 1 && len == 0) {
                        LaunchProperties.this.fLines.add("");
                    }
                }
                if (isNewLine) {
                    isNewLine = false;
                }
                if (aChar != '\n' && aChar != '\r') {
                    this.fLine[len++] = aChar;
                    if (len == this.fLine.length) {
                        int newLength = this.fLine.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.fLine, 0, buf, 0, this.fLine.length);
                        this.fLine = buf;
                    }
                    if (aChar == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.fIstream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (aChar != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

