/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.connection;

import com.wily.introscope.agent.connection.IConsolidableAgentCommand;
import com.wily.introscope.agent.connection.IConsolidableAppMapAgentServiceCommand;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.spec.server.beans.agent.IAppMapAgentService;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DependencyMapEdgeCommand
implements IConsolidableAppMapAgentServiceCommand {
    private static Module kModule = new Module("AppMapEdgeCommand");
    private final List fData;
    private final List fCallbacks;
    private IModuleFeedbackChannel fLog;

    public DependencyMapEdgeCommand(List callback, IModuleFeedbackChannel log, List data) {
        this.fCallbacks = callback;
        this.fData = data;
        this.fLog = log;
    }

    public DependencyMapEdgeCommand(IAppMapDecisionSupportBean.ICallBackOnSent callback, IModuleFeedbackChannel log, List data) {
        this.fCallbacks = new ArrayList();
        this.fCallbacks.add(callback);
        this.fData = data;
        this.fLog = log;
    }

    public void handleAgentCommand(IAppMapAgentService service) throws ConnectionException {
        if (this.fLog.isTraceEnabled(kModule)) {
            this.fLog.trace(kModule, "Sending metrics for " + this.fData);
        }
        service.handleUpdateEdgeData(this.fData);
    }

    public void onAgentCommandCompletion(int success) {
        boolean successCondition;
        int consecutiveErrors;
        if (success == 2) {
            consecutiveErrors = AppMapService.getConsecutiveProblems().next();
            if (consecutiveErrors < AppMapService.getMaxConsecutiveErrors()) {
                this.fLog.error(kModule, "Cannot send " + this.fData);
                this.fLog.debug(kModule, "This is the " + consecutiveErrors + " error");
            } else if (consecutiveErrors == AppMapService.getMaxConsecutiveErrors()) {
                this.fLog.error(kModule, "Cannot send " + this.fData);
                this.fLog.error(kModule, "Reached the limit of " + consecutiveErrors + " for reporting app map data send errors. " + " Additional errors will not be logged until " + "at least one packet of app map data get successfully delivered");
                AppMapService.evaluateShutdown();
            }
        } else if (success == 1) {
            consecutiveErrors = AppMapService.getConsecutiveProblems().next();
            if (consecutiveErrors < AppMapService.getMaxConsecutiveErrors()) {
                if (this.fLog.isDebugEnabled(kModule)) {
                    this.fLog.debug(kModule, "Rolling back data because connection is not available." + this.fData);
                }
            } else if (consecutiveErrors == AppMapService.getMaxConsecutiveErrors()) {
                this.fLog.error(kModule, "Reached the limit of " + consecutiveErrors + " for reporting app map data send errors. " + " Additional errors will not be logged until " + "at least one packet of app map data get successfully delivered");
                AppMapService.evaluateShutdown();
            }
        }
        boolean bl = successCondition = success == 0;
        if (successCondition && AppMapService.getConsecutiveProblems().peek() >= AppMapService.getMaxConsecutiveErrors()) {
            this.fLog.info(kModule, "A packet of data was successfully transmitted. Resuming logging for errors");
        }
        if (successCondition) {
            AppMapService.getConsecutiveProblems().reset();
        }
        Iterator i = this.fCallbacks.iterator();
        while (i.hasNext()) {
            ((IAppMapDecisionSupportBean.ICallBackOnSent)i.next()).onSent(success == 0);
        }
    }

    public void merge(IConsolidableAgentCommand command) {
        if (command instanceof DependencyMapEdgeCommand) {
            this.fData.addAll(((DependencyMapEdgeCommand)command).fData);
            this.fCallbacks.addAll(((DependencyMapEdgeCommand)command).fCallbacks);
        }
    }

    public String getKey() {
        return this.getClass().getName();
    }
}

