/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.trace.IOwnerCrossProcessHelper;

public abstract class AppMapCrossProcessHelper
implements IOwnerCrossProcessHelper {
    public static final String kCallerClassNameKey = "AppMapCallerClassName";
    public static final String kCallerMethodNameKey = "AppMapCallerMethodName";
    public static final String kCallerTypeKey = "AppMapCallerType";
    public static final String kCallerAgentKey = "AppMapCallerAgent";
    public static final String kCallerHostKey = "AppMapCallerHost";
    public static final String kCallerProcessKey = "AppMapCallerProcess";
    public static final String kExternalCallerClassName = "OutsideWorld";
    public static final String kExternalCallerMethodName = "OutsideWorld";
    public static final String kExternalCallerType = "External";
    public static final String kExternalCallerAgent = "None";
    public static final String kExternalCallerHost = "Unknown";
    public static final String kExternalCallerProcess = "Unknown";

    public static String getCallingComponentName(SharedCrossProcessData cache, IStackType stackType) {
        if (stackType.equals(AppMapService.kStackTypeClassMethodApp) || stackType.equals(AppMapService.kStackTypeClassMethodBT)) {
            return AppMapCrossProcessHelper.getCallingComponentMethodName(cache);
        }
        if (stackType.equals(AppMapService.kStackTypeClassApp) || stackType.equals(AppMapService.kStackTypeClassBT)) {
            return AppMapCrossProcessHelper.getCallingComponentClassName(cache);
        }
        return "OutsideWorld";
    }

    public static void setCallingComponentName(SharedCrossProcessData cache, IStackType stackType, String name) {
        if (stackType.equals(AppMapService.kStackTypeClassMethodApp) || stackType.equals(AppMapService.kStackTypeClassMethodBT)) {
            AppMapCrossProcessHelper.setCallingComponentMethodName(cache, name);
        } else if (stackType.equals(AppMapService.kStackTypeClassApp) || stackType.equals(AppMapService.kStackTypeClassBT)) {
            AppMapCrossProcessHelper.setCallingComponentClassName(cache, name);
        }
    }

    public static void setCallingComponentName(SharedCrossProcessData cache, IStackType stackType, CrossCorrelationStringParameterProvider name) {
        if (stackType.equals(AppMapService.kStackTypeClassMethodApp) || stackType.equals(AppMapService.kStackTypeClassMethodBT)) {
            AppMapCrossProcessHelper.setCallingComponentMethodName(cache, name);
        } else if (stackType.equals(AppMapService.kStackTypeClassApp) || stackType.equals(AppMapService.kStackTypeClassBT)) {
            AppMapCrossProcessHelper.setCallingComponentClassName(cache, name);
        }
    }

    private static String getCallingComponentClassName(SharedCrossProcessData cache) {
        if (cache != null) {
            String retVal = cache.getStringParamIn(kCallerClassNameKey);
            if (retVal == null) {
                retVal = "OutsideWorld";
            }
            return retVal;
        }
        return "OutsideWorld";
    }

    private static void setCallingComponentClassName(SharedCrossProcessData cache, String name) {
        if (cache != null) {
            cache.addParamOut(kCallerClassNameKey, name);
        }
    }

    private static void setCallingComponentClassName(SharedCrossProcessData cache, CrossCorrelationStringParameterProvider name) {
        if (cache != null) {
            cache.addParamOut(kCallerClassNameKey, name);
        }
    }

    private static String getCallingComponentMethodName(SharedCrossProcessData cache) {
        if (cache != null) {
            String retVal = cache.getStringParamIn(kCallerMethodNameKey);
            if (retVal == null) {
                retVal = "OutsideWorld";
            }
            return retVal;
        }
        return "OutsideWorld";
    }

    private static void setCallingComponentMethodName(SharedCrossProcessData cache, String name) {
        if (cache != null) {
            cache.addParamOut(kCallerMethodNameKey, name);
        }
    }

    private static void setCallingComponentMethodName(SharedCrossProcessData cache, CrossCorrelationStringParameterProvider name) {
        if (cache != null) {
            cache.addParamOut(kCallerMethodNameKey, name);
        }
    }

    public static String getCallingComponentType(SharedCrossProcessData cache) {
        if (cache != null) {
            String retVal = cache.getStringParamIn(kCallerTypeKey);
            if (retVal == null) {
                retVal = kExternalCallerType;
            }
            return retVal;
        }
        return kExternalCallerType;
    }

    public static void setCallingComponentType(SharedCrossProcessData cache, String typeStr) {
        if (cache != null) {
            cache.addParamOut(kCallerTypeKey, typeStr);
        }
    }

    public static void setCallingComponentType(SharedCrossProcessData cache, CrossCorrelationStringParameterProvider typeStr) {
        if (cache != null) {
            cache.addParamOut(kCallerTypeKey, typeStr);
        }
    }

    public static String getCallingAgent(SharedCrossProcessData cache) {
        if (cache != null) {
            String retVal = cache.getStringParamIn(kCallerAgentKey);
            if (retVal == null) {
                retVal = kExternalCallerAgent;
            }
            return retVal;
        }
        return kExternalCallerAgent;
    }

    public static void setCallingAgent(SharedCrossProcessData cache, String agent) {
        if (cache != null) {
            cache.addParamOut(kCallerAgentKey, agent);
        }
    }

    public static String getCallingHost(SharedCrossProcessData cache) {
        if (cache != null) {
            String retVal = cache.getStringParamIn(kCallerHostKey);
            if (retVal == null) {
                retVal = "Unknown";
            }
            return retVal;
        }
        return "Unknown";
    }

    public static void setCallingHost(SharedCrossProcessData cache, String host) {
        if (cache != null) {
            cache.addParamOut(kCallerHostKey, host);
        }
    }

    public static String getCallingProcess(SharedCrossProcessData cache) {
        if (cache != null) {
            String retVal = cache.getStringParamIn(kCallerProcessKey);
            if (retVal == null) {
                retVal = "Unknown";
            }
            return retVal;
        }
        return "Unknown";
    }

    public static void setCallingProcess(SharedCrossProcessData cache, String process) {
        if (cache != null) {
            cache.addParamOut(kCallerProcessKey, process);
        }
    }
}

