/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.util.adt.WeakWeakIdentityHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class MetricNamesThreadLocalHelper {
    private static final Module kModule = new Module("MetricNamesThreadLocalHelper");
    private static ThreadLocal fCurrentComponentMetricNames = new ThreadLocal(){

        protected Object initialValue() {
            return new Stack();
        }
    };
    private static MetricNameMapWrapper kStaticMap = new MetricNameMapWrapper(new WeakWeakIdentityHashMap(), null);

    public static void pushActiveMetricNameMap(IAppMapDecisionSupportBean.IUniqueCandidate candidate) {
        WeakWeakIdentityHashMap newComponentMetricNames = new WeakWeakIdentityHashMap();
        Stack myMetricStack = (Stack)fCurrentComponentMetricNames.get();
        myMetricStack.push(new MetricNameMapWrapper(newComponentMetricNames, candidate));
    }

    public static void popMetricNamesMap() {
        Stack myMetricStack = (Stack)fCurrentComponentMetricNames.get();
        myMetricStack.pop();
    }

    public static void addMetricName(String nameParameter, String result, IModuleFeedbackChannel feedback) {
        boolean isTraceEnabled = feedback.isTraceEnabled(kModule);
        if (isTraceEnabled) {
            feedback.trace(kModule, "Tring to add metric " + nameParameter + ";" + result);
        }
        if (result != null && nameParameter != null) {
            Stack myMetricStack = (Stack)fCurrentComponentMetricNames.get();
            if (!myMetricStack.isEmpty()) {
                MetricNameMapWrapper myMap = (MetricNameMapWrapper)myMetricStack.peek();
                if (myMap != null && myMap != kStaticMap) {
                    myMap.newComponentMetricNames.put((Object)nameParameter, (Object)result);
                } else if (isTraceEnabled) {
                    feedback.trace(kModule, "not added for dummy map metric " + nameParameter + ";" + result);
                }
            } else if (isTraceEnabled) {
                feedback.trace(kModule, "not added for stack empty metric " + nameParameter + ";" + result);
            }
        }
    }

    private static Map getActiveMetricNameMap() {
        MetricNameMapWrapper myMap;
        Stack myMetricStack = (Stack)fCurrentComponentMetricNames.get();
        if (!myMetricStack.empty() && (myMap = (MetricNameMapWrapper)myMetricStack.peek()) != kStaticMap) {
            HashMap myMetrics = new HashMap();
            if (myMap != null) {
                MetricNamesThreadLocalHelper.extractEntriesInMap(myMap, myMetrics);
            }
            return myMetrics;
        }
        return null;
    }

    private static void extractEntriesInMap(MetricNameMapWrapper myMap, Map myMetrics) {
        for (Map.Entry entry : myMap.newComponentMetricNames.entrySet()) {
            WeakReference reference = (WeakReference)entry.getValue();
            Object value = reference.get();
            if (value == null) continue;
            myMetrics.put(entry.getKey(), value);
        }
    }

    private static IAppMapDecisionSupportBean.IUniqueCandidate getActiveMapUniqueCandidate() {
        MetricNameMapWrapper myMap;
        Stack myMetricStack = (Stack)fCurrentComponentMetricNames.get();
        if (!myMetricStack.empty() && (myMap = (MetricNameMapWrapper)myMetricStack.peek()) != kStaticMap) {
            return myMap.candidate;
        }
        return null;
    }

    public static Map evaluateMetrixUniquenes(IAppMapDecisionSupportBean oracle) {
        MetricNameMapWrapper myMap;
        HashMap uniqueMetrics = null;
        Stack myMetricStack = (Stack)fCurrentComponentMetricNames.get();
        if (!myMetricStack.empty() && (myMap = (MetricNameMapWrapper)myMetricStack.peek()) != kStaticMap && myMap != null) {
            HashMap possibleMetrics = new HashMap();
            MetricNamesThreadLocalHelper.extractEntriesInMap(myMap, possibleMetrics);
            IAppMapDecisionSupportBean.IUniqueCandidate candidate = myMap.candidate;
            if (possibleMetrics != null && candidate != null && possibleMetrics.size() > 0) {
                for (Map.Entry entry : possibleMetrics.entrySet()) {
                    String metric = (String)entry.getValue();
                    IAppMapDecisionSupportBean.IUniqueCandidate metricCandidate = candidate.getMetricEnabledCandidateFromCandidate(metric);
                    if (!oracle.evaluateNodeMetricUniquenes(metricCandidate)) continue;
                    if (uniqueMetrics == null) {
                        uniqueMetrics = new HashMap();
                    }
                    uniqueMetrics.put(entry.getKey(), metricCandidate);
                }
            }
        }
        return uniqueMetrics;
    }

    public static void reset() {
        Stack myMetricStack = (Stack)fCurrentComponentMetricNames.get();
        myMetricStack.clear();
    }

    private static class MetricNameMapWrapper {
        final WeakWeakIdentityHashMap newComponentMetricNames;
        final IAppMapDecisionSupportBean.IUniqueCandidate candidate;

        MetricNameMapWrapper(WeakWeakIdentityHashMap map, IAppMapDecisionSupportBean.IUniqueCandidate candidate) {
            this.newComponentMetricNames = map;
            this.candidate = candidate;
        }
    }
}

