/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.appmap.impl;

import com.wily.introscope.agent.connection.IAgentBridgeCommand;
import com.wily.introscope.spec.server.appmap.impl.AppMapAgingFetchBehavior;
import com.wily.introscope.spec.server.appmap.impl.AppMapOracle;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.isengard.messageprimitives.ConnectionException;

public class AgingFetchCommand
implements IAgentBridgeCommand {
    private long edgeAgingValue = 0L;
    private final AppMapOracle fOracle;
    private final AppMapAgingFetchBehavior fBehavior;

    public AgingFetchCommand(AppMapOracle oracle, AppMapAgingFetchBehavior behavior) {
        this.fOracle = oracle;
        this.fBehavior = behavior;
    }

    public void handleAgentCommand(IAgentBridgeService service) throws ConnectionException {
        this.edgeAgingValue = service.getGranularityForAgent();
    }

    public void onAgentCommandCompletion(int success) {
        if (success == 0) {
            boolean successSetAging = false;
            try {
                this.fOracle.startDataStructureAging(this.edgeAgingValue);
                successSetAging = true;
            }
            catch (Throwable throwable) {
                successSetAging = false;
            }
            if (successSetAging) {
                this.fBehavior.kill();
            } else {
                this.fBehavior.reset();
            }
        } else {
            this.fBehavior.reset();
        }
    }
}

