/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.appmap.impl;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.agent.environment.EnvironmentAdministrator;
import com.wily.introscope.agent.trace.ITraceSupport;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppDef;
import com.wily.introscope.appmap.agent.trace.AppMapNameHelperFactory;
import com.wily.introscope.appmap.agent.trace.IAppMapNameHelper;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.spec.agent.beans.appmap.IOwnerRepository;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.appmap.impl.AgentInformationReporter;
import com.wily.introscope.spec.server.appmap.impl.AppMapAgingFetchBehavior;
import com.wily.introscope.spec.server.transactiontrace.IAppMapStackCollectDataStructure;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.util.INameChangeListener;
import com.wily.util.adt.IAgedSet;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.LongConfigurationProperty;
import java.util.ArrayList;
import java.util.Map;

public abstract class AppMapOracle
extends AIsengardBean
implements IAppMapDecisionSupportBean,
ITraceSupport {
    private static final int kSendEnvironmentCycleTime = 30000;
    private final int[] kHasBeenSet = new int[1];
    private static int kSetValue = 1;
    private volatile IAgent fAgent;
    public EdgeAgingConfigurationProperty fEdgeAgingProperty;
    private static final String kAppMapEdgeAgingProperty = "introscope.agent.appmap.aging.agingTime";
    private static final long kDefaultAgingTime = 2592000000L;
    protected static final Module kModule = new Module("AppMapOracle");
    private volatile boolean fShouldSendEnvironmentVariables = false;
    private AgentInformationReporter reporter = new AgentInformationReporter();

    protected AppMapOracle() {
    }

    public void activate() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAgent(IAgent agent) {
        int[] nArray = this.kHasBeenSet;
        synchronized (this.kHasBeenSet) {
            block4: {
                if (this.kHasBeenSet[0] != 0) break block4;
                this.kHasBeenSet[0] = kSetValue;
                this.fAgent = agent;
                this.startAging(this.fAgent);
                this.reporter.setAgent(this.fAgent);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private void startAging(IAgent agent) {
        this.initializeAgingStructures(agent);
        this.fEdgeAgingProperty = new EdgeAgingConfigurationProperty(agent);
        this.getAgent().IAgent_getConfigurationManager().add((ConfigurationProperty)this.fEdgeAgingProperty, true);
        IntervalHeartbeat configHeartbeat = this.getAgent().IAgent_getConfigHeartbeat();
        if (configHeartbeat != null) {
            new AppMapAgingFetchBehavior(this, configHeartbeat, 1000L, "Fetch behavior for app map");
        } else {
            this.getAgent().IAgent_getModuleFeedback().debug("No heartbeat available. This should happen in tests only");
        }
        this.initializeEnvironmentPropertiesListenersAndBehavior();
    }

    protected abstract boolean initializeAgingStructures(IAgent var1);

    protected IAgent getAgent() {
        return this.fAgent;
    }

    protected boolean shouldNotRun() {
        return this.fAgent == null;
    }

    public IOwnerRepository getCurrentOwnerList(String ownerType) {
        if (this.shouldNotRun()) {
            return null;
        }
        IAppMapNameHelper helper = AppMapNameHelperFactory.getNameHelper(this.getAgent(), ownerType);
        IOwnerRepository result = helper.getCurrentOwnerList(AppMapOracle.getSharedProcessDataCache());
        return result;
    }

    public boolean evaluateCrossProcessUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.shouldNotRun()) {
            return false;
        }
        IAgedSet edgeMap = this.getCrossProcessEdgeMap();
        if (edgeMap.containsAged((Object)component)) {
            return false;
        }
        return edgeMap.addAged((Object)component);
    }

    public boolean evaluateDependencyUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.shouldNotRun()) {
            return false;
        }
        IAgedSet noticedDependencies = this.getNoticedDependenciesMap();
        if (noticedDependencies.containsAged((Object)component)) {
            return false;
        }
        return noticedDependencies.addAged((Object)component);
    }

    public boolean evaluateNodeMetricUniquenes(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.shouldNotRun()) {
            return false;
        }
        IAgedSet noticedNodeMetrics = this.getNoticedMetrics();
        if (noticedNodeMetrics.containsAged((Object)component)) {
            return false;
        }
        return noticedNodeMetrics.addAged((Object)component);
    }

    public boolean evaluateParentChildUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.shouldNotRun()) {
            return false;
        }
        IAgedSet set = this.getNoticedParentChildDependency();
        if (set.containsAged((Object)component)) {
            return false;
        }
        return set.addAged((Object)component);
    }

    public void revertCrossProcessUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.shouldNotRun()) {
            return;
        }
        Object removed = this.getCrossProcessEdgeMap().remove((Object)component);
        if (removed == null && this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
            this.getAgent().IAgent_getModuleFeedback().trace(kModule, "Could not find object to be removed in revertCrossProcessUniqueness" + component);
        }
    }

    public void revertDependencyUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.shouldNotRun()) {
            return;
        }
        Object removed = this.getNoticedDependenciesMap().remove((Object)component);
        if (removed == null && this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
            this.getAgent().IAgent_getModuleFeedback().trace(kModule, "Could not find obejct to be removed in revertDependencyUniqueness" + component);
        }
    }

    public void revertNodeMetricUniquenes(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.shouldNotRun()) {
            return;
        }
        Object removed = this.getNoticedMetrics().remove((Object)component);
        if (removed == null && this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
            this.getAgent().IAgent_getModuleFeedback().trace(kModule, "Could not find obejct to be removed in revertNodeMetricUniquenes" + component);
        }
    }

    public void revertParentChildUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        if (this.fAgent == null) {
            return;
        }
        Object removed = this.getNoticedParentChildDependency().remove((Object)component);
        if (removed == null && this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
            this.getAgent().IAgent_getModuleFeedback().trace(kModule, "Could not find obejct to be removed in revertParentChildUniqueness" + component);
        }
    }

    protected abstract IAgedSet getCrossProcessEdgeMap();

    protected abstract IAgedSet getNoticedDependenciesMap();

    protected abstract IAgedSet getNoticedMetrics();

    protected abstract IAgedSet getNoticedParentChildDependency();

    public long getEdgeAging() {
        if (this.shouldNotRun()) {
            return Long.MAX_VALUE;
        }
        return this.fEdgeAgingProperty.getAgingValue();
    }

    public long getCheckAging(long edgeAgingValue) {
        if (this.shouldNotRun()) {
            return Long.MAX_VALUE;
        }
        return Math.max(edgeAgingValue / 30L, 60000L);
    }

    protected static SharedCrossProcessData getSharedProcessDataCache() {
        return ComponentTracer.staticGetCrossProcessDataCache();
    }

    private void initializeEnvironmentPropertiesListenersAndBehavior() {
        final INameChangeListener listener1 = new INameChangeListener(){

            public void INameChangeListener_nameChanged(String newName) {
                AppMapOracle.this.fShouldSendEnvironmentVariables = true;
            }
        };
        final EnvironmentAdministrator.IEnvironmentChangeListener listener2 = new EnvironmentAdministrator.IEnvironmentChangeListener(){

            public void environmentChanged() {
                AppMapOracle.this.fShouldSendEnvironmentVariables = true;
            }
        };
        final IServerConnectionObserver observer = new IServerConnectionObserver(){

            public void serverConnected() {
                AppMapOracle.this.fShouldSendEnvironmentVariables = true;
            }

            public void serverDisconnected() {
                AppMapOracle.this.fShouldSendEnvironmentVariables = false;
            }

            public void serverConnectionCycleFailed(int cycleCount) {
                AppMapOracle.this.fShouldSendEnvironmentVariables = false;
            }

            public void agentControlSetReportingState(boolean report) {
            }

            public void agentControlStopReportingMetric(AgentMetric metric) {
            }

            public void agentControlStartReportingMetric(AgentMetric metric) {
            }

            public void agentControlAddTTFilter(ITransactionTraceFilter filter) {
            }

            public void agentControlRemoveTTFilter(ITransactionTraceFilter filter) {
            }
        };
        final IServerConnectionNotification notification = new IServerConnectionNotification(){

            public void connectionUp() {
                AppMapOracle.this.fShouldSendEnvironmentVariables = true;
            }

            public void connectionDown() {
                AppMapOracle.this.fShouldSendEnvironmentVariables = false;
            }
        };
        new WaitAndExecuteBehavior(this.fAgent.IAgent_getCommonHeartbeat(), 30000L, "Check Connection for Send Environment App Map Edge"){

            protected boolean execute() {
                IsengardServerConnectionManager m = AppMapOracle.this.fAgent.IAgent_getIsengardServerConnection();
                if (m != null && m.getConnectedServer() != null && m.getConnectedServer().isConnected()) {
                    AppMapOracle.this.fAgent.IAgent_addNameChangeListener(listener1);
                    AppMapOracle.this.fAgent.IAgent_addNegotiatedNameChangeListener(listener1);
                    AppMapOracle.this.fAgent.IAgent_getEnvironmentAdministrator().addEnvironmentChangeListener(listener2);
                    AppMapOracle.this.fAgent.IAgent_getIsengardServerConnection().addConnectionObserver(observer);
                    AppMapOracle.this.fAgent.IAgent_getIsengardServerConnection().addConnectionObserver(notification);
                    AppMapOracle.this.fShouldSendEnvironmentVariables = true;
                    return true;
                }
                return false;
            }
        };
        new WaitAndExecuteBehavior(this.fAgent.IAgent_getCommonHeartbeat(), 30000L, "Send Environment App Map Edge"){

            protected boolean execute() {
                AppMapOracle.this.reportEnvironmentInformation(false);
                return false;
            }
        };
    }

    public void reportEnvironmentInformation(final boolean force) {
        if (this.fShouldSendEnvironmentVariables || force) {
            this.fShouldSendEnvironmentVariables = false;
            EnvironmentAdministrator ea = this.fAgent.IAgent_getEnvironmentAdministrator();
            Map properties = ea.calculateNetInterfaceProperties();
            AppDef environmentOwner = AppDef.getInstance("<ENVIRONMENT_IDENTIFIERS_OWNER>");
            IAppMapStackCollectDataStructure startNode = this.getNode(null, null, null, "ENVIRONMENT_IDENTIFIERS_HEAD", "<ENVIRONMENT_IDENTIFIERS_OWNER>", "MethodClass", false, properties, environmentOwner);
            IAppMapStackCollectDataStructure endNode = this.getNode(null, null, null, "ENVIRONMENT_IDENTIFIERS_TAIL", "<ENVIRONMENT_IDENTIFIERS_OWNER>", "MethodClass", false, properties, environmentOwner);
            IAppMapStackCollectDataStructure edge = this.getEdge(environmentOwner, startNode, endNode, endNode.getOwner(), startNode.getOwner());
            ArrayList<IAppMapStackCollectDataStructure> newList = new ArrayList<IAppMapStackCollectDataStructure>();
            newList.add(edge);
            boolean wasEdgeQueued = this.reportEdge(new IAppMapDecisionSupportBean.ICallBackOnSent(){

                public void onSent(boolean sucess) {
                    if (!sucess && !force) {
                        AppMapOracle.this.fAgent.IAgent_getModuleFeedback().error(kModule, "Unable to send environment variables to app map");
                    }
                }
            }, newList);
            if (!wasEdgeQueued) {
                this.fShouldSendEnvironmentVariables = true;
            }
        }
    }

    public final class EdgeAgingConfigurationProperty
    extends LongConfigurationProperty {
        long value;

        EdgeAgingConfigurationProperty(IAgent agent) {
            super(AppMapOracle.kAppMapEdgeAgingProperty, new Long(2592000000L), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public long getAgingValue() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Long)newValue;
            AppMapOracle.this.fShouldSendEnvironmentVariables = true;
        }
    }
}

