/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.rave.agent.ConfigurationException;
import com.wily.rave.agent.IAgentConfiguration;
import com.wily.util.PropertyNotFoundException;
import com.wily.util.PropertySubstitutionStringParser;
import com.wily.util.RaveUtil;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Random;
import org.apache.regexp.RE;

class RaveConfiguration
implements IAgentConfiguration {
    private static final String RAVE_ROOT_DIR_NAME = "change_detector";
    private static final String RAVE_PROFILE_DIR_NAME = "changeDetector_profiles";
    private static final String PARAM_PREFIX = "introscope.changeDetector.";
    public static final String PARAM_PROFILE_FILE_NAME = "introscope.changeDetector.profile";
    public static final String PARAM_PROFILE_DIR = "introscope.changeDetector.profileDir";
    public static final String PARAM_AGENT_ROOT_NAME = "introscope.changeDetector.rootDir";
    public static final String PARAM_RAVE_AGENT_NAME = "introscope.changeDetector.agentName";
    public static final String PARAM_RAVE_AGENT_ID = "introscope.changeDetector.agentID";
    public static final String PARAM_RAVE_EPA_AGENT_ENABLE = "introscope.changeDetector.enableEPA";
    public static final String PARAM_ENABLE_CD = "introscope.changeDetector.enable";
    private static final String PARAM_ISENGARD_STARTUP_WAIT_TIME = "introscope.changeDetector.isengardStartupWaitTimeInSec";
    private static final String PARAM_ISENGARD_STARTUP_WAIT_COUNT = "introscope.changeDetector.isengardStartupWaitCount";
    private static final String PARAM_WAIT_TM_BTWN_RECONNECTS = "introscope.changeDetector.waitTimeBetweenReconnectInSec";
    public static final String CHANGE_DETECTOR_AUTO_ID_EXTENSION = ".id";
    public static final String CHANGE_DETECTOR_AUTO_ID_TMP_EXTENSION = ".tmp";
    public static final String CHANGE_DETECTOR_AUTO_ID_REGEXP = "[a-fA-F0-9]+";
    private final IModuleFeedbackChannel feedback;
    private final String dataSourcesProfileFileName;
    private final String dataSourcesProfileDir;
    private final String raveRootDirName;
    private final String raveAgentID;
    private final boolean enableEPAAgent;
    private final IndexedProperties agentProps;

    RaveConfiguration(IModuleFeedbackChannel feedback, IAgent coreAgent) throws ConfigurationException {
        this.feedback = feedback;
        this.agentProps = coreAgent.IAgent_getIndexedProperties();
        String tmpDataSourcesProfileFileName = this.getPropertyFromConfigOrParam(PARAM_PROFILE_FILE_NAME);
        if (tmpDataSourcesProfileFileName != null) {
            try {
                PropertySubstitutionStringParser parser = new PropertySubstitutionStringParser(tmpDataSourcesProfileFileName, this.agentProps, true);
                tmpDataSourcesProfileFileName = parser.getPropertySubstitutedString();
            }
            catch (PropertyNotFoundException pnfe) {
                feedback.warn("Error while substituting property in data sources profile file name property");
                feedback.verbose(pnfe);
            }
            catch (IllegalArgumentException iae) {
                feedback.warn("Error while substituting property in data sources profile file name property");
                feedback.verbose(iae);
            }
        } else {
            tmpDataSourcesProfileFileName = "ChangeDetector-config.xml";
            feedback.warn("ChangeDetector data source configuration file not specified.  The default 'ChangeDetector-config.xml' will be used.");
        }
        if (tmpDataSourcesProfileFileName != null && tmpDataSourcesProfileFileName.length() > 1 && tmpDataSourcesProfileFileName.charAt(0) != '\\' && tmpDataSourcesProfileFileName.charAt(0) != '/' && tmpDataSourcesProfileFileName.charAt(1) != ':') {
            IResource resource = coreAgent.IAgent_getConfigurationResource();
            URL agentConfigUrl = null;
            try {
                agentConfigUrl = resource.IResource_getURL();
            }
            catch (MalformedURLException e) {
                String errMsg = "Failed retrieving ChangeDetector root location!";
                feedback.error(errMsg, e);
            }
            String agentWilyFolder = new File(agentConfigUrl.getFile()).getParentFile().getAbsolutePath();
            agentWilyFolder = URLDecoder.decode(agentWilyFolder);
            StringBuffer agentDirNameBuf = new StringBuffer(agentWilyFolder).append(File.separatorChar).append(tmpDataSourcesProfileFileName);
            tmpDataSourcesProfileFileName = agentDirNameBuf.toString();
        }
        this.dataSourcesProfileFileName = tmpDataSourcesProfileFileName;
        this.dataSourcesProfileDir = this.resolveRaveProfileDirName(coreAgent, this.agentProps);
        String raveRootParentDirName = this.resolveRaveRootParentDirName(coreAgent, this.agentProps);
        try {
            RaveUtil.checkCreateMandatoryDirectory(raveRootParentDirName, feedback);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        this.raveAgentID = this.resolveRaveAgentID(raveRootParentDirName);
        this.raveRootDirName = String.valueOf(raveRootParentDirName) + this.raveAgentID + File.separatorChar;
        this.enableEPAAgent = this.getPropertyFromConfigOrParamWithDefault(PARAM_RAVE_EPA_AGENT_ENABLE, true);
    }

    private final String resolveRaveAgentID(String raveRootParentDirName) throws ConfigurationException {
        String tmpRaveAgentID = this.getPropertyFromConfigOrParam(PARAM_RAVE_AGENT_ID);
        if (tmpRaveAgentID == null && (tmpRaveAgentID = this.getPropertyFromConfigOrParam(PARAM_RAVE_AGENT_NAME)) != null) {
            this.feedback.warn("The property introscope.changeDetector.agentName has been deprecated. Please use introscope.changeDetector.agentID instead. The next release of the product will not support introscope.changeDetector.agentName.");
        }
        if (tmpRaveAgentID != null) {
            tmpRaveAgentID = tmpRaveAgentID.trim();
        }
        if (tmpRaveAgentID == null || tmpRaveAgentID.length() == 0) {
            tmpRaveAgentID = this.readOrCreateNewAutoID(raveRootParentDirName);
        } else {
            try {
                PropertySubstitutionStringParser parser = new PropertySubstitutionStringParser(tmpRaveAgentID, this.agentProps);
                tmpRaveAgentID = parser.getPropertySubstitutedString();
            }
            catch (PropertyNotFoundException pnfe) {
                this.feedback.warn("Error while substituting property in agent id property, agent id will be " + tmpRaveAgentID);
                this.feedback.verbose(pnfe);
            }
            catch (IllegalArgumentException iae) {
                this.feedback.warn("Error while substituting property in agent id property, agent id will be " + tmpRaveAgentID);
                this.feedback.verbose(iae);
            }
            this.checkValidRaveAgentID(tmpRaveAgentID);
        }
        this.feedback.info("ChangeDetector agent ID is " + tmpRaveAgentID);
        return tmpRaveAgentID;
    }

    private final String readOrCreateNewAutoID(String rootParentDirName) throws ConfigurationException {
        File raveRootParent = new File(rootParentDirName);
        File[] files = raveRootParent.listFiles(new AgentIDFileNameFilter(CHANGE_DETECTOR_AUTO_ID_EXTENSION, this.feedback));
        if (files.length > 1) {
            throw new ConfigurationException("Found more than one ChangeDetector agent ID file in " + raveRootParent.getAbsolutePath() + ". Can't determine ID automatically, ID must be provided via configuration!");
        }
        String tmpRaveAgentID = files.length == 0 ? this.createIDAtomically(raveRootParent) : files[0].getName().substring(0, files[0].getName().length() - CHANGE_DETECTOR_AUTO_ID_EXTENSION.length());
        return tmpRaveAgentID;
    }

    private String createIDAtomically(File raveRootParent) throws ConfigurationException {
        String tmpRaveAgentID = "CDAID_";
        String tentativeRaveAgentID = String.valueOf(tmpRaveAgentID) + GUIDGenerator.getInstance().generateKey();
        int count = 0;
        while (count++ < 3) {
            String actualRaveAgentID;
            if (count > 1) {
                int time = new Random().nextInt(10);
                this.feedback.info("Found more than one tmp file while attempting to automatically create a ChangeDetector agent ID, retrying after " + time + " seconds...");
                try {
                    Thread.sleep(time * 1000);
                }
                catch (InterruptedException e) {
                    this.feedback.info("Thread shouldn't have been interupted, ignoring...", e);
                }
            }
            if ((actualRaveAgentID = this.createIDFileAtomically(raveRootParent, tentativeRaveAgentID)) == null) continue;
            return actualRaveAgentID;
        }
        this.feedback.error("Failed automatically generating ChangeDetector agent ID. This might have been caused by stale files with the prefix 'CDAID_' and extension '.tmp' lying in the directory '" + raveRootParent.getAbsolutePath() + "'. If so, delete these files and retry.");
        throw new ConfigurationException("Failed auto generating ChangeDetector agent ID.");
    }

    protected String createIDFileAtomically(File raveRootParent, String tmpRaveAgentID) throws ConfigurationException {
        File tmpFile = this.createIDTmpFile(raveRootParent, tmpRaveAgentID);
        File[] files = raveRootParent.listFiles(new AgentIDFileNameFilter(CHANGE_DETECTOR_AUTO_ID_TMP_EXTENSION, this.feedback));
        if (files.length > 1) {
            if (!tmpFile.delete()) {
                this.feedback.error("Failed deleting file " + tmpFile.getAbsolutePath() + ". This error will be ignored and the file left behind, but it must be manually deleted.");
            }
        } else if (files.length == 1) {
            if (!files[0].getName().equals(tmpFile.getName())) {
                throw new ConfigurationException("Tmp file " + tmpFile.getAbsolutePath() + "inadvertedly deleted!");
            }
            files = raveRootParent.listFiles(new AgentIDFileNameFilter(CHANGE_DETECTOR_AUTO_ID_EXTENSION, this.feedback));
            if (files.length == 0) {
                tmpFile.renameTo(new File(raveRootParent, String.valueOf(tmpRaveAgentID) + CHANGE_DETECTOR_AUTO_ID_EXTENSION));
            } else {
                if (!tmpFile.delete()) {
                    this.feedback.error("Failed deleting file " + tmpFile.getAbsolutePath() + ". This error will be ignored and the file left behind, but it must be manually deleted.");
                }
                if (files.length > 1) {
                    throw new ConfigurationException("Found more than one ChangeDetector agent ID file in " + raveRootParent.getAbsolutePath() + ". Can't determine ID automatically, ID must be provided via configuration!");
                }
                tmpRaveAgentID = files[0].getName().substring(0, files[0].getName().length() - CHANGE_DETECTOR_AUTO_ID_EXTENSION.length());
            }
            return tmpRaveAgentID;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final File createIDTmpFile(File raveRootParent, String id) throws ConfigurationException {
        FileOutputStream fos = null;
        File idFile = new File(raveRootParent, String.valueOf(id) + CHANGE_DETECTOR_AUTO_ID_TMP_EXTENSION);
        try {
            try {
                fos = new FileOutputStream(idFile);
                fos.write(id.getBytes("ASCII"));
                fos.write(10);
            }
            catch (FileNotFoundException e) {
                String msg = "Failed creating ChangeDetector agent ID file " + idFile.getAbsolutePath();
                this.feedback.error(msg, e);
                throw new ConfigurationException(msg);
            }
            catch (UnsupportedEncodingException e) {
                String msg = "Failed creating ChangeDetector agent ID file " + idFile.getAbsolutePath();
                this.feedback.error(msg, e);
                throw new ConfigurationException(msg);
            }
            catch (IOException e) {
                String msg = "Failed creating ChangeDetector agent ID file " + idFile.getAbsolutePath();
                this.feedback.error(msg, e);
                throw new ConfigurationException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                String msg = "Failed closing ChangeDetector agent ID file " + idFile.getAbsolutePath();
                this.feedback.error(msg, e);
                throw new ConfigurationException(msg);
            }
        }
        {
            Object var7_13 = null;
        }
        try {}
        catch (IOException e) {
            String msg = "Failed closing ChangeDetector agent ID file " + idFile.getAbsolutePath();
            this.feedback.error(msg, e);
            throw new ConfigurationException(msg);
        }
        if (fos == null) return idFile;
        fos.close();
        return idFile;
    }

    private final void checkValidRaveAgentID(String raveAgentName) throws ConfigurationException {
        int i = 0;
        while (i < raveAgentName.length()) {
            char character = raveAgentName.charAt(i);
            if (!(character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '_' || character == '-' || character == '.')) {
                throw new ConfigurationException("Invalid ChangeDetector agent ID! The ChangeDetector agent ID must be a combination of alphanumeric characters and the characters '_' and '-'");
            }
            ++i;
        }
    }

    String getDataSourceProfileFileName() {
        return this.dataSourcesProfileFileName;
    }

    String getDataSourceProfileDir() {
        return this.dataSourcesProfileDir;
    }

    String getRaveRootDirName() {
        return this.raveRootDirName;
    }

    String getRaveAgentID() {
        return this.raveAgentID;
    }

    int getIsengardWaitTimeInSec() {
        return this.getPropertyFromConfigOrParamWithDefault(PARAM_ISENGARD_STARTUP_WAIT_TIME, 30);
    }

    int getIsengardWaitCount() {
        return this.getPropertyFromConfigOrParamWithDefault(PARAM_ISENGARD_STARTUP_WAIT_COUNT, 20);
    }

    boolean isEPAAgentEnabled() {
        return this.enableEPAAgent;
    }

    int getWaitTimeBetweenConnectsInSec() {
        return this.getPropertyFromConfigOrParamWithDefault(PARAM_WAIT_TM_BTWN_RECONNECTS, 15);
    }

    private String resolveRaveProfileDirName(IAgent coreAgent, IndexedProperties agentProps) {
        String agentWilyFolder;
        String errMsg;
        URL agentConfigUrl;
        IResource resource;
        StringBuffer raveProfileDirNameBuf = null;
        String profileDir = this.getPropertyFromConfigOrParam(PARAM_PROFILE_DIR);
        if (profileDir != null) {
            try {
                PropertySubstitutionStringParser parser = new PropertySubstitutionStringParser(profileDir, agentProps, true);
                profileDir = parser.getPropertySubstitutedString();
            }
            catch (PropertyNotFoundException pnfe) {
                this.feedback.warn("Error while substituting property in data sources profile directory property");
                this.feedback.verbose(pnfe);
            }
            catch (IllegalArgumentException iae) {
                this.feedback.warn("Error while substituting property in data sources profile directory property");
                this.feedback.verbose(iae);
            }
            if (profileDir != null && profileDir.length() > 1 && profileDir.charAt(0) != '\\' && profileDir.charAt(0) != '/' && profileDir.charAt(1) != ':') {
                resource = coreAgent.IAgent_getConfigurationResource();
                agentConfigUrl = null;
                try {
                    agentConfigUrl = resource.IResource_getURL();
                }
                catch (MalformedURLException e) {
                    errMsg = "Failed retrieving ChangeDetector root location!";
                    this.feedback.error(errMsg, e);
                }
                agentWilyFolder = new File(agentConfigUrl.getFile()).getParentFile().getAbsolutePath();
                agentWilyFolder = URLDecoder.decode(agentWilyFolder);
                StringBuffer agentDirNameBuf = new StringBuffer(agentWilyFolder).append(File.separatorChar).append(profileDir);
                profileDir = agentDirNameBuf.toString();
            }
            if ((raveProfileDirNameBuf = new StringBuffer(profileDir)).length() == 0) {
                this.feedback.warn("Value for ChangeDetector profile directory is blank, will use default if it exists.");
            }
        }
        if (raveProfileDirNameBuf == null || raveProfileDirNameBuf.length() == 0) {
            resource = coreAgent.IAgent_getConfigurationResource();
            agentConfigUrl = null;
            if (resource == null) {
                return null;
            }
            try {
                agentConfigUrl = resource.IResource_getURL();
            }
            catch (MalformedURLException e) {
                errMsg = "Failed retrieving ChangeDetector root location!";
                this.feedback.error(errMsg, e);
            }
            agentWilyFolder = new File(agentConfigUrl.getFile()).getParentFile().getAbsolutePath();
            agentWilyFolder = URLDecoder.decode(agentWilyFolder);
            raveProfileDirNameBuf = new StringBuffer(agentWilyFolder).append(File.separatorChar).append(RAVE_ROOT_DIR_NAME).append(File.separatorChar);
            File profileDirFile = new File(raveProfileDirNameBuf.toString());
            if (!profileDirFile.exists()) {
                return null;
            }
        }
        if (raveProfileDirNameBuf.charAt(raveProfileDirNameBuf.length() - 1) != File.separatorChar) {
            raveProfileDirNameBuf.append(File.separatorChar);
        }
        return raveProfileDirNameBuf.toString();
    }

    private String resolveRaveRootParentDirName(IAgent coreAgent, IndexedProperties agentProps) throws ConfigurationException {
        String rootName = this.getPropertyFromConfigOrParam(PARAM_AGENT_ROOT_NAME);
        if (rootName != null) {
            try {
                PropertySubstitutionStringParser parser = new PropertySubstitutionStringParser(rootName, agentProps, true);
                rootName = parser.getPropertySubstitutedString();
            }
            catch (PropertyNotFoundException pnfe) {
                this.feedback.warn("Error while substituting property in root directory property");
                this.feedback.verbose(pnfe);
            }
            catch (IllegalArgumentException iae) {
                this.feedback.warn("Error while substituting property in root directory property");
                this.feedback.verbose(iae);
            }
            if (rootName == null || rootName.length() == 0) {
                this.feedback.warn("Value for ChangeDetector root directory is blank, will use default.");
                rootName = RAVE_ROOT_DIR_NAME;
            }
        } else {
            rootName = RAVE_ROOT_DIR_NAME;
        }
        StringBuffer raveRootDirNameBuf = null;
        File rootFile = new File(rootName);
        if (!rootFile.isAbsolute()) {
            IResource resource = coreAgent.IAgent_getConfigurationResource();
            URL agentConfigUrl = null;
            try {
                agentConfigUrl = resource.IResource_getURL();
            }
            catch (MalformedURLException e) {
                String errMsg = "Failed retrieving ChangeDetector root location!";
                this.feedback.error(errMsg, e);
                throw new ConfigurationException(String.valueOf(errMsg) + e.getMessage());
            }
            String agentWilyFolder = new File(agentConfigUrl.getFile()).getParentFile().getAbsolutePath();
            agentWilyFolder = URLDecoder.decode(agentWilyFolder);
            raveRootDirNameBuf = new StringBuffer(agentWilyFolder).append(File.separatorChar).append(rootName).append(File.separatorChar);
            this.feedback.info("ChangeDetector agent root dir is " + raveRootDirNameBuf);
        } else {
            raveRootDirNameBuf = new StringBuffer(rootName);
        }
        if (raveRootDirNameBuf.charAt(raveRootDirNameBuf.length() - 1) != File.separatorChar) {
            raveRootDirNameBuf.append(File.separatorChar);
        }
        return raveRootDirNameBuf.toString();
    }

    private String getMandatoryPropertyFromConfigOrParam(String propName) throws ConfigurationException {
        String propValue = this.getPropertyFromConfigOrParam(propName);
        if (propValue == null) {
            String errMsg = "Mandatory property '" + propName + "' not specified! This property must be specified in the configuration file!";
            this.feedback.error(errMsg);
            throw new ConfigurationException(errMsg);
        }
        return propValue;
    }

    private boolean getPropertyFromConfigOrParamWithDefault(String propName, boolean defaultValue) {
        String retVal = this.getPropertyFromConfigOrParam(propName);
        if (retVal == null) {
            return defaultValue;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(retVal)) {
            return true;
        }
        if (!Boolean.FALSE.toString().equalsIgnoreCase(retVal)) {
            this.feedback.warn("Invalid value for boolean property '" + propName + "'. Must be either 'true' or 'false', defaulting to false.");
        }
        return false;
    }

    private int getPropertyFromConfigOrParamWithDefault(String propName, int defaultValue) {
        String retVal = this.getPropertyFromConfigOrParam(propName);
        if (retVal == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(retVal);
        }
        catch (NumberFormatException numberFormatException) {
            this.feedback.warn("Invalid value for integer property '" + propName + "'. Default value of " + defaultValue + " will be used instead.");
            return defaultValue;
        }
    }

    private final String getPropertyFromConfigOrParam(String propName) {
        String propValue = System.getProperty(propName);
        if (propValue != null) {
            this.feedback.debug("Using ChangeDetector configuration property (" + propName + ") specified in system property!");
        } else {
            propValue = (String)this.agentProps.get(propName);
        }
        this.feedback.debug("Property Name: '" + propName + "'; Value: '" + propValue + "'");
        return propValue;
    }

    public String getProperty(String propertyName) {
        return this.getPropertyFromConfigOrParam(propertyName);
    }

    public int getProperty(String propertyName, int defaultValue) {
        return this.getPropertyFromConfigOrParamWithDefault(propertyName, defaultValue);
    }

    public boolean getProperty(String propertyName, boolean defaultValue) {
        return this.getPropertyFromConfigOrParamWithDefault(propertyName, defaultValue);
    }

    public static final class AgentIDFileNameFilter
    implements FilenameFilter {
        private final RE regExp;
        private String extension;
        private IModuleFeedbackChannel feedback;

        public AgentIDFileNameFilter(String extension, IModuleFeedbackChannel feedback) {
            this.extension = extension;
            this.feedback = feedback;
            String tmpRaveAgentID = "CDAID_";
            this.regExp = new RE(String.valueOf(tmpRaveAgentID) + RaveConfiguration.CHANGE_DETECTOR_AUTO_ID_REGEXP + extension);
        }

        public boolean accept(File parentDir, String name) {
            if (this.regExp.match(name)) {
                return this.checkValidIDFile(parentDir, name);
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        private final boolean checkValidIDFile(File parentDir, String name) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [11 : 241->244)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

