/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.config.parser;

import com.wily.introscope.agent.IAgent;
import com.wily.rave.agent.IAgentConfiguration;
import com.wily.rave.agent.IListenerContainer;
import com.wily.rave.agent.config.ConfigException;
import com.wily.rave.agent.config.IDataSourceConfig;
import com.wily.rave.agent.config.IUpdatingDataSourceConfig;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.IPolledDataSource;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.util.PropertyNotFoundException;
import com.wily.util.PropertySubstitutionStringParser;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.crimson.jaxp.DocumentBuilderFactoryImpl;
import org.apache.crimson.tree.CommentNode;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigFileParser {
    public static final String CURRENT_VERSION = "8.0";
    public static final String VERSION_71 = "7.1";
    private static final String CHANGE_DETECTOR = "change-detector";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DATA_SOURCE_INST = "datasource-instance";
    private static final String DATA_SOURCE_TYPE = "datasource-type";
    private static final String BATCH_SIZE = "batch-size";
    private static final String assumeWindowsProperty = "introscope.changeDetector.config.assumeWindows";
    protected HashMap fElementTypeToParserMap;
    private final IAgent fAgent;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private IListenerContainer fListenerContainer;
    private Set fContexts;
    private HashMap fUpdatedDataSourceConfigElements;
    private HashMap fOverridingDataSourceConfigElements;
    private Document fCachedDocument;
    private IAgentConfiguration fConfig;
    static /* synthetic */ Class class$0;

    public ConfigFileParser(IListenerContainer listenerContainer, IAgentConfiguration config, IAgent agent, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(listenerContainer, config, new HashSet(), agent, feedback, localizer);
    }

    public ConfigFileParser(IListenerContainer listenerContainer, IAgentConfiguration config, HashSet existingContexts, IAgent agent, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.fListenerContainer = listenerContainer;
        this.fAgent = agent;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fElementTypeToParserMap = new HashMap();
        this.fContexts = existingContexts;
        this.fUpdatedDataSourceConfigElements = new HashMap();
        this.fOverridingDataSourceConfigElements = new HashMap();
        this.fConfig = config;
    }

    public void resetParser(HashSet contexts) {
        this.fElementTypeToParserMap.clear();
        this.fContexts = contexts;
        this.fUpdatedDataSourceConfigElements.clear();
        this.fOverridingDataSourceConfigElements.clear();
        this.fCachedDocument = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream input) {
        ClassLoader tmpClassLoader = Thread.currentThread().getContextClassLoader();
        Thread thread = Thread.currentThread();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("com.wily.rave.agent.config.parser.ConfigFileParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        thread.setContextClassLoader(clazz.getClassLoader());
        try {
            Document document;
            DocumentBuilder builder;
            InputSource source = new InputSource(input);
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            try {
                builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                this.fFeedback.error("Fatal error, config file will not be parsed!", e);
                Object var8_8 = null;
                Thread.currentThread().setContextClassLoader(tmpClassLoader);
                return;
            }
            try {
                document = builder.parse(source);
            }
            catch (SAXException e) {
                this.fFeedback.error("Fatal error, config file will not be parsed!", e);
                Object var8_9 = null;
                Thread.currentThread().setContextClassLoader(tmpClassLoader);
                return;
            }
            catch (IOException e) {
                this.fFeedback.error("Fatal error, config file will not be parsed!", e);
                Object var8_10 = null;
                Thread.currentThread().setContextClassLoader(tmpClassLoader);
                return;
            }
            this.parseDocument(document);
            this.fCachedDocument = document;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            Thread.currentThread().setContextClassLoader(tmpClassLoader);
            throw throwable;
        }
        {
            Object var8_12 = null;
            Thread.currentThread().setContextClassLoader(tmpClassLoader);
            return;
        }
    }

    private void updateDocument(OutputStream out, boolean isOverridingExistingDocument) throws IOException {
        StringBuffer outBuffer = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        outBuffer.append("<change-detector>");
        this.updateDocument(this.fCachedDocument, isOverridingExistingDocument, outBuffer);
        outBuffer.append("</change-detector>");
        if (lineSeparator.equals("\r\n")) {
            String output = outBuffer.toString();
            outBuffer = new StringBuffer();
            int index = 0;
            while (index != -1) {
                int tempIndex = output.indexOf(10, index);
                if (tempIndex == -1) {
                    outBuffer.append(output.substring(index));
                    outBuffer.append(lineSeparator);
                    index = -1;
                    continue;
                }
                outBuffer.append(output.substring(index, tempIndex));
                outBuffer.append(lineSeparator);
                index = tempIndex + 1;
            }
        }
        out.write(outBuffer.toString().getBytes());
        if (!isOverridingExistingDocument) {
            this.fUpdatedDataSourceConfigElements.clear();
        }
        this.fOverridingDataSourceConfigElements.clear();
    }

    public void overrideDocument(OutputStream out) throws IOException {
        this.updateDocument(out, true);
    }

    public void updateDocument(OutputStream out) throws IOException {
        this.updateDocument(out, false);
    }

    private void updateDocument(Document document, boolean isOverridingExistingDocument, StringBuffer out) throws IOException {
        Node child = document.getFirstChild();
        String childName = child.getNodeName();
        if (!CHANGE_DETECTOR.equals(childName)) {
            this.fFeedback.error("Fatal error, mal-formed rave configuration file!");
            return;
        }
        child = child.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                if (DATA_SOURCE_INST.equals(child.getNodeName())) {
                    this.updateAndWriteElementIfNeeded((Element)child, isOverridingExistingDocument, out);
                } else {
                    out.append(child.toString());
                }
            } else if (child instanceof CommentNode || child instanceof TextNode) {
                StringWriter stringWriter = new StringWriter();
                XmlWriteContext writeContext = new XmlWriteContext(stringWriter);
                if (child instanceof CommentNode) {
                    ((CommentNode)child).writeXml(writeContext);
                } else {
                    ((TextNode)child).writeXml(writeContext);
                }
                out.append(stringWriter.getBuffer());
            } else {
                out.append(child.toString());
            }
            child = child.getNextSibling();
        }
    }

    private void updateAndWriteElementIfNeeded(Element element, boolean isOverridingExistingDocument, StringBuffer out) {
        String contextName = "<undef>";
        try {
            HashMap mapToUse;
            contextName = ElementParserHelper.getRequiredAttribute(element, NAME);
            HashMap hashMap = mapToUse = isOverridingExistingDocument ? this.fOverridingDataSourceConfigElements : this.fUpdatedDataSourceConfigElements;
            if (mapToUse.containsKey(contextName)) {
                Element updatedElement = (Element)mapToUse.get(contextName);
                out.append(updatedElement.toString());
            } else {
                out.append(element.toString());
            }
        }
        catch (ConfigException e) {
            this.fFeedback.error("Could not parse context " + contextName + "; Context will be ignored!", e);
        }
    }

    public boolean configNeedsUpdating() {
        return !this.fUpdatedDataSourceConfigElements.isEmpty();
    }

    public boolean configNeedsOverriding() {
        return !this.fOverridingDataSourceConfigElements.isEmpty();
    }

    public boolean configHasElementsThatNeedOnlyUpdating() {
        if (this.fUpdatedDataSourceConfigElements.isEmpty()) {
            return false;
        }
        return this.fUpdatedDataSourceConfigElements.size() != this.fOverridingDataSourceConfigElements.size();
    }

    private void parseDocument(Document document) {
        Node firstChild = document.getFirstChild();
        String childName = firstChild.getNodeName();
        if (!CHANGE_DETECTOR.equals(childName)) {
            this.fFeedback.error("Fatal error, mal-formed rave configuration file!");
            return;
        }
        Node child = firstChild.getFirstChild();
        while (child != null) {
            if (child instanceof Element && DATA_SOURCE_TYPE.equals(child.getNodeName())) {
                this.addDataSource((Element)child);
            }
            child = child.getNextSibling();
        }
        child = firstChild.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                if (DATA_SOURCE_INST.equals(child.getNodeName())) {
                    this.parseElement((Element)child);
                } else if (!DATA_SOURCE_TYPE.equals(child.getNodeName())) {
                    this.fFeedback.error("Unknown element " + child.getNodeName() + " will be skipped!");
                }
            }
            child = child.getNextSibling();
        }
    }

    private void addDataSource(Element element) {
        block12: {
            String name = null;
            String className = null;
            String jarFileLocation = null;
            try {
                name = ElementParserHelper.getRequiredAttribute(element, NAME);
                className = ElementParserHelper.getRequiredAttribute(element, CLASS);
                jarFileLocation = ElementParserHelper.getOptionalAttribute(element, "jarFile");
            }
            catch (ConfigException e) {
                this.fFeedback.error("Could not register data source!", e);
            }
            Class<?> dataSourceClass = null;
            try {
                if (jarFileLocation == null) {
                    dataSourceClass = Class.forName(className);
                    this.fElementTypeToParserMap.put(name, dataSourceClass);
                    break block12;
                }
                try {
                    String[] urlStrings = ConfigFileParser.getDriverURLStrings(jarFileLocation);
                    URL[] jarURLs = ConfigFileParser.getURLFromStrings(urlStrings);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.wily.rave.agent.config.parser.ConfigFileParser");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    URLClassLoader cl = new URLClassLoader(jarURLs, clazz.getClassLoader());
                    dataSourceClass = cl.loadClass(className);
                    this.fElementTypeToParserMap.put(name, dataSourceClass);
                }
                catch (PropertyNotFoundException pnfe) {
                    this.fFeedback.error("Property in jarFile attribute for data source " + name + " could not be resolved.  Data source not registered!");
                    this.fFeedback.verbose(pnfe);
                }
                catch (MalformedURLException mue) {
                    this.fFeedback.error("Malformed URL Exception caught while creating URLs based on jarFile attribute for data source " + name + ".  Data source not registered!");
                    this.fFeedback.verbose(mue);
                }
                catch (SecurityException se) {
                    this.fFeedback.error("Class " + className + " for data source " + name + " could not be loaded due to security permissions. Data souce not registered!");
                    this.fFeedback.verbose(se);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.fFeedback.error("Class " + className + " for data source " + name + " not found. Data souce not registered!");
            }
        }
    }

    private void parseElement(Element element) {
        String contextName = "<undef>";
        try {
            Element updatedElement;
            IDataSourceConfig config;
            contextName = ElementParserHelper.getRequiredAttribute(element, NAME);
            if (this.fContexts.contains(contextName)) {
                throw new ConfigException("A context with this name (" + contextName + ") already exists!");
            }
            if (!ConfigFileParser.isValidDataSourceName(contextName)) {
                throw new ConfigException("Invalid context name.  Context name cannot include the following characters: \\, /, #, ?, \", <, >, |.  Use the displayName attribute if you wish to have a datasource that is identified by a string with one of these elments");
            }
            String contextDisplayName = ElementParserHelper.getOptionalAttribute(element, DISPLAY_NAME);
            if (contextDisplayName == null) {
                contextDisplayName = contextName;
            }
            String contextType = ElementParserHelper.getRequiredAttribute(element, "type");
            int eventBatchSize = ElementParserHelper.getOptionalIntegerAttribute(element, BATCH_SIZE, this.fConfig.getProperty("introscope.changeDetector.eventBatchSize", 10));
            Class elementConfigClass = (Class)this.fElementTypeToParserMap.get(contextType);
            if (elementConfigClass == null) {
                throw new ConfigException("Datasource type \"" + contextType + "\" for datasource instance \"" + contextName + "\" is unknown.  Please verify that the correct type is being used and is defined.");
            }
            try {
                config = (IDataSourceConfig)elementConfigClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ConfigException("Could not create parser: " + elementConfigClass.getName() + "\n" + e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Could not create parser: " + elementConfigClass.getName() + "\n" + e);
            }
            this.initConfig(config, contextName, contextDisplayName, element, eventBatchSize);
            if (config instanceof IUpdatingDataSourceConfig && (updatedElement = ((IUpdatingDataSourceConfig)config).getUpdatedXMLElement()) != null) {
                this.fUpdatedDataSourceConfigElements.put(contextName, updatedElement);
                if (!((IUpdatingDataSourceConfig)config).shouldExistingElementBeBackedUp()) {
                    this.fOverridingDataSourceConfigElements.put(contextName, updatedElement);
                }
            }
            this.fContexts.add(contextName);
        }
        catch (ConfigException e) {
            this.fFeedback.error("Could not parse context " + contextName + "; Context will be ignored!", e);
        }
    }

    protected void initConfig(IDataSourceConfig config, String contextName, String contextDisplayName, Element dataSourceRoot, int eventBatchSize) throws ConfigException {
        IPolledDataSource dataSourceMainCollection;
        try {
            dataSourceMainCollection = config.parseConfig(dataSourceRoot, this.fAgent, this.fFeedback, this.fLocalizer);
        }
        catch (Exception ex) {
            this.fFeedback.error("Error while parsing configuration element for " + contextName + "/" + config.getDataSourceType() + ". Data source WILL NOT be run!", ex);
            return;
        }
        try {
            eventBatchSize = config.supportsEventBatching() ? eventBatchSize : 1;
            IDataSourceListener listener = this.fListenerContainer.getListener(contextName, contextDisplayName, config.getDataSourceType(), config.supportsEventDeletion(), eventBatchSize);
            listener.addCollectionTask(dataSourceMainCollection, config.getMainTaskSchedule(), String.valueOf(config.getDataSourceType()) + ":" + contextName);
        }
        catch (StopCollectionException stopCollectionException) {
            this.fFeedback.error("Collection " + contextName + "/" + config.getDataSourceType() + " failed to start and will not run!");
        }
    }

    public static boolean isValidDataSourceName(String dsName) {
        char[] chars = dsName.toCharArray();
        int x = 0;
        while (x < chars.length) {
            switch (chars[x]) {
                case '\"': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '|': {
                    return false;
                }
            }
            ++x;
        }
        return true;
    }

    public static String[] getDriverURLStrings(String classpath) throws PropertyNotFoundException {
        boolean substituteBefore = false;
        if (classpath.indexOf("${path.separator}") != -1) {
            substituteBefore = true;
        }
        if (substituteBefore) {
            PropertySubstitutionStringParser substitutionParser = new PropertySubstitutionStringParser(classpath, ElementParserHelper.getAgentProps());
            classpath = substitutionParser.getPropertySubstitutedString();
        }
        String classpathSeparator = null;
        if (substituteBefore) {
            classpathSeparator = System.getProperty("path.separator");
        } else {
            IndexedProperties agentProps;
            boolean assumeWindows = false;
            boolean checkForWindowsCharacters = true;
            String assumeWindowsPropertyVal = System.getProperty(assumeWindowsProperty);
            if (assumeWindowsPropertyVal == null && (agentProps = ElementParserHelper.getAgentProps()) != null) {
                assumeWindowsPropertyVal = agentProps.getProperty(assumeWindowsProperty);
            }
            if (assumeWindowsPropertyVal != null) {
                if (assumeWindowsPropertyVal.equalsIgnoreCase("true")) {
                    assumeWindows = true;
                    checkForWindowsCharacters = false;
                } else if (assumeWindowsPropertyVal.equalsIgnoreCase("false")) {
                    assumeWindows = false;
                    checkForWindowsCharacters = false;
                }
            }
            if (checkForWindowsCharacters && (classpath.indexOf(59) != -1 || classpath.indexOf(92) != -1)) {
                assumeWindows = true;
            }
            classpathSeparator = assumeWindows ? ";" : ":";
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, classpathSeparator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            token = new PropertySubstitutionStringParser(token, ElementParserHelper.getAgentProps()).getPropertySubstitutedString();
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static URL[] getURLFromStrings(String[] urlStrings) throws MalformedURLException {
        URL[] jarURLs = new URL[urlStrings.length];
        int x = 0;
        while (x < jarURLs.length) {
            jarURLs[x] = new URL("file:" + urlStrings[x]);
            ++x;
        }
        return jarURLs;
    }
}

