/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.config.parser;

import com.wily.rave.agent.config.ConfigException;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import org.w3c.dom.Element;

public final class PropertyParser {
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String BYTES = "bytes";
    private static final String KBYTES = "kbytes";
    private static final String MBYTES = "mbytes";
    private Element element;

    public PropertyParser(Element element) throws ConfigException {
        this.element = element;
    }

    public String getName() throws ConfigException {
        return this.getAttributeValue("name");
    }

    public String getValue() throws ConfigException {
        return this.getAttributeValue("value");
    }

    public String getAttributeValue(String attributeName, String defaultAttributeVal) throws ConfigException {
        return ElementParserHelper.getAttribute(this.element, attributeName, defaultAttributeVal);
    }

    public String getAttributeValue(String attributeName) throws ConfigException {
        return ElementParserHelper.getRequiredAttribute(this.element, attributeName);
    }

    public String getOptionalAttributeValue(String attributeName) throws ConfigException {
        return ElementParserHelper.getOptionalAttribute(this.element, attributeName);
    }

    public boolean getBooleanValue() throws ConfigException {
        return ElementParserHelper.getBooleanAttribute(this.element, "value");
    }

    public int getIntValue() throws ConfigException {
        return ElementParserHelper.getRequiredIntegerAttribute(this.element, "value");
    }

    public int getTimeUnitMultiplier(String attributeName, int defaultMultiplier) throws ConfigException {
        String val = this.getOptionalAttributeValue(attributeName);
        if (val == null) {
            return defaultMultiplier;
        }
        if (SECOND.startsWith(val.toLowerCase())) {
            return 1;
        }
        if (MINUTE.startsWith(val.toLowerCase())) {
            return 60;
        }
        if (HOUR.startsWith(val.toLowerCase())) {
            return 3600;
        }
        throw new ConfigException("Invalid unit for time for property  '" + this.getName() + "'; Value: " + val);
    }

    public int getDataSizeUnitMultilplier(String attributeName, int defaultMultiplier) throws ConfigException {
        String val = this.getOptionalAttributeValue(attributeName);
        if (val == null) {
            return defaultMultiplier;
        }
        if (BYTES.startsWith(val.toLowerCase())) {
            return 1;
        }
        if (KBYTES.startsWith(val.toLowerCase())) {
            return 1024;
        }
        if (MBYTES.startsWith(val.toLowerCase())) {
            return 0x100000;
        }
        throw new ConfigException("Invalid unit for data size for property  '" + this.getName() + "'; Value: " + val);
    }

    public String toString() {
        try {
            return "'" + this.getName() + "' / '" + this.getValue() + "'";
        }
        catch (ConfigException e) {
            return e.getMessage();
        }
    }
}

