/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.rave.agent.RaveAgent;
import com.wily.rave.agent.cache.IRaveContentCache;
import com.wily.rave.agent.cache.IRaveContentFullCache;
import com.wily.rave.agent.cache.RaveCache;
import com.wily.rave.agent.ds.IAgentContentChangeEvent;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.exception.ADataSourceCollectionException;
import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.rave.agent.ds.states.IAgentDataSourceState;
import com.wily.rave.agent.ds.states.StartState;
import com.wily.rave.agent.ds.task.DataSourceTaskExecutor;
import com.wily.rave.agent.ds.task.IDataSourceTask;
import com.wily.rave.agent.task.ITaskId;
import com.wily.rave.agent.task.Schedule;
import com.wily.rave.exceptions.ACommException;
import com.wily.rave.server.api.IWatchedAgent;
import com.wily.rave.spec.DataSourceInstance;
import com.wily.rave.spec.IContentChangeEvent;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.utils.IStateEngineAdminInterface;
import com.wily.rave.utils.PersistentState;
import com.wily.rave.utils.StateEngine;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataSourceListener
implements IDataSourceListener {
    private static final String STATE_FILE_NAME = "state.dat";
    private static final String CACHE_FILE_NAME = "cache.dat";
    private static final long SAMPLING_PERIOD = 15000L;
    private RaveAgent raveAgent;
    private IAgent coreAgent;
    private IntervalHeartbeat heartbeat;
    private RaveCache dataCache;
    private IAgentDataSourceState stateEngine;
    private PersistentState persistState;
    private IAgentDataSourceState state;
    private IStateEngineAdminInterface stateEngineAdmin;
    private Serializable stateCtx;
    private IWatchedAgent watchedAgent;
    private DataSourceInstance dsInstance;
    private LinkedList collectionTasks;
    private boolean collectionResumed;
    private boolean collectionStopped;
    private boolean restartScanThrown;
    private boolean restartCollectionThrown;
    private IModuleFeedbackChannel feedback;
    private IRegisteredBehavior metricBehavior;
    private int dataPointsTotalCounter;
    private final ILongIntervalCounterDataAccumulator fDataPointsPerIntervalAccumulator;
    private int additionsTotalCounter;
    private int deletionsTotalCounter;
    private int modificationsTotalCounter;
    private int scansCompletedCounter;
    private boolean dbDeleted;
    private boolean firstScanAfterRestart;
    private int batchSize;
    private List changeEventBuffer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceListener(RaveAgent raveAgent, IModuleFeedbackChannel feedback, String dsInstanceName, String dsInstanceDisplayName, String dsInstanceType, boolean dsDeletionSupport, int batchSize, IAgent coreAgent, IntervalHeartbeat heartbeat) throws StopCollectionException {
        block33: {
            this.batchSize = 10;
            this.raveAgent = raveAgent;
            this.coreAgent = coreAgent;
            this.heartbeat = heartbeat;
            this.feedback = feedback;
            this.dbDeleted = false;
            this.batchSize = batchSize < 1 ? 1 : batchSize;
            this.changeEventBuffer = new ArrayList(batchSize);
            this.dataPointsTotalCounter = 0;
            this.additionsTotalCounter = 0;
            this.deletionsTotalCounter = 0;
            this.modificationsTotalCounter = 0;
            this.scansCompletedCounter = 0;
            this.collectionTasks = new LinkedList();
            this.collectionStopped = false;
            this.collectionResumed = false;
            this.restartScanThrown = false;
            this.restartCollectionThrown = false;
            this.firstScanAfterRestart = true;
            this.dsInstance = DataSourceInstance.get((String)dsInstanceName, (String)dsInstanceDisplayName, (String)dsInstanceType, (String)raveAgent.getName(), (boolean)dsDeletionSupport);
            String rootDir = this.getRootDirPath();
            try {
                File rootDirFile = new File(rootDir);
                if (!rootDirFile.exists() && !rootDirFile.mkdirs()) {
                    this.getFeedback().error("Failed creating state directory: " + rootDirFile.getAbsolutePath());
                    throw new StopCollectionException("Failed creating state directory: " + rootDirFile.getAbsolutePath());
                }
                this.persistState = new PersistentState(rootDir, STATE_FILE_NAME, false);
                Object[] persisted = (Object[])this.persistState.read2(this.getClass().getClassLoader());
                if (persisted == null) {
                    this.setState(StartState.getDataSourceState());
                    this.newCache();
                } else {
                    this.state = (IAgentDataSourceState)persisted[0];
                    this.stateCtx = (Serializable)persisted[1];
                    this.dataCache = this.loadCache();
                    if (this.dataCache == null) {
                        this.setState(StartState.getDataSourceState());
                        this.newCache();
                    }
                }
                Object[] args = new Object[]{this};
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.wily.rave.agent.ds.DataSourceListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class[] classes = classArray;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("com.wily.rave.agent.ds.states.IAgentDataSourceState");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray2 = new Class[2];
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("com.wily.rave.exceptions.ACommException");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz3;
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("com.wily.isengard.messageprimitives.ConnectionException");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[1] = clazz4;
                StateEngine.StateEngineTuple tuple = StateEngine.getStateEngine((Object)this.state, (String)"transitionToState", (String)"crash", (Object[])args, (Class[])classes, clazz2, (Class[])classArray2);
                this.stateEngine = (IAgentDataSourceState)tuple.getStateEngine();
                this.stateEngineAdmin = tuple.getStateEngineAdmin();
                DataAccumulatorFactory factory = null;
                if (coreAgent != null) {
                    factory = coreAgent.IAgent_getDataAccumulatorFactory();
                    if (factory == null) {
                        this.getFeedback().error("DataAccumulatorFactory was null! Some supportability metrics may not be created!");
                    }
                } else {
                    this.getFeedback().error("CoreAgent was null! Some supportability metrics may not be created!");
                }
                this.fDataPointsPerIntervalAccumulator = this.createClosesPerIntervalAccumulator(factory);
                if (this.fDataPointsPerIntervalAccumulator != null) {
                    this.fDataPointsPerIntervalAccumulator.ILongIntervalCounterDataAccumulator_addBatchIncidents(0L);
                }
                if (heartbeat == null) break block33;
                IntervalHeartbeat intervalHeartbeat = this.heartbeat;
                synchronized (intervalHeartbeat) {
                    if (this.metricBehavior == null) {
                        this.metricBehavior = this.heartbeat.addBehavior(this.createMetricBehavior(), "ChangeDetector Data Source (" + this.dsInstance.getDisplayName() + ") Metric Behavior", true, 15000L, true);
                    }
                }
            }
            catch (IOException e) {
                this.getFeedback().error("Failed loading state!", e);
                throw new StopCollectionException("Failed loading state! " + e.getMessage());
            }
            catch (SecurityException e) {
                this.getFeedback().error("Failed loading state!", e);
                throw new StopCollectionException("Failed loading state! " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                this.getFeedback().error("Failed loading state!", e);
                throw new StopCollectionException("Failed loading state! " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.getFeedback().error("Failed loading state!", e);
                throw new StopCollectionException("Failed loading state! " + e.getMessage());
            }
        }
    }

    private final ILongIntervalCounterDataAccumulator createClosesPerIntervalAccumulator(DataAccumulatorFactory factory) {
        if (factory != null) {
            return factory.safeGetLongIntervalCounterDataAccumulator("ChangeDetector|DataSources|" + this.dsInstance.getName() + ":" + "Changes Sent Per Interval");
        }
        return null;
    }

    private ITimestampedRunnable createMetricBehavior() {
        return new ITimestampedRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                try {
                    DataSourceListener.this.sendAdditionsTotalDataPointsMetricValue();
                    DataSourceListener.this.sendDeletionsTotalDataPointsMetricValue();
                    DataSourceListener.this.sendModificationsTotalDataPointsMetricValue();
                    DataSourceListener.this.sendTotalDataPointsMetricValue();
                    DataSourceListener.this.sendCompletedScansMetricValue();
                }
                catch (BadlyFormedNameException e) {
                    DataSourceListener.this.feedback.error("Failed sending metric with addition total changes count.", e);
                }
                catch (ConflictingTypesException e) {
                    DataSourceListener.this.feedback.error("Failed sending metric with addition total changes count.", e);
                }
            }
        };
    }

    private synchronized void sendAdditionsTotalDataPointsMetricValue() throws BadlyFormedNameException, ConflictingTypesException {
        IIntegerFluctuatingCounterDataAccumulator dataPointsTotalAccumulator = this.coreAgent.IAgent_getDataAccumulatorFactory().getIntegerFluctuatingCounterDataAccumulator("ChangeDetector|DataSources|" + this.dsInstance.getDisplayName() + ":" + "Total Addition Changes");
        dataPointsTotalAccumulator.IIntegerCounterDataAccumulator_setValue(this.additionsTotalCounter);
    }

    private synchronized void sendDeletionsTotalDataPointsMetricValue() throws BadlyFormedNameException, ConflictingTypesException {
        IIntegerFluctuatingCounterDataAccumulator dataPointsTotalAccumulator = this.coreAgent.IAgent_getDataAccumulatorFactory().getIntegerFluctuatingCounterDataAccumulator("ChangeDetector|DataSources|" + this.dsInstance.getDisplayName() + ":" + "Total Deletion Changes");
        dataPointsTotalAccumulator.IIntegerCounterDataAccumulator_setValue(this.deletionsTotalCounter);
    }

    private synchronized void sendModificationsTotalDataPointsMetricValue() throws BadlyFormedNameException, ConflictingTypesException {
        IIntegerFluctuatingCounterDataAccumulator dataPointsTotalAccumulator = this.coreAgent.IAgent_getDataAccumulatorFactory().getIntegerFluctuatingCounterDataAccumulator("ChangeDetector|DataSources|" + this.dsInstance.getDisplayName() + ":" + "Total Modification Changes");
        dataPointsTotalAccumulator.IIntegerCounterDataAccumulator_setValue(this.modificationsTotalCounter);
    }

    private synchronized void sendTotalDataPointsMetricValue() throws BadlyFormedNameException, ConflictingTypesException {
        IIntegerFluctuatingCounterDataAccumulator dataPointsTotalAccumulator = this.coreAgent.IAgent_getDataAccumulatorFactory().getIntegerFluctuatingCounterDataAccumulator("ChangeDetector|DataSources|" + this.dsInstance.getDisplayName() + ":" + "Total Changes");
        dataPointsTotalAccumulator.IIntegerCounterDataAccumulator_setValue(this.dataPointsTotalCounter);
    }

    private synchronized void sendCompletedScansMetricValue() throws BadlyFormedNameException, ConflictingTypesException {
        IIntegerFluctuatingCounterDataAccumulator dataPointsTotalAccumulator = this.coreAgent.IAgent_getDataAccumulatorFactory().getIntegerFluctuatingCounterDataAccumulator("ChangeDetector|DataSources|" + this.dsInstance.getDisplayName() + ":" + "Total Completed Scans");
        dataPointsTotalAccumulator.IIntegerCounterDataAccumulator_setValue(this.scansCompletedCounter);
    }

    private String getDSInstanceFullName() {
        return String.valueOf(this.dsInstance.getName()) + "_" + this.dsInstance.getType();
    }

    private String getRootDirPath() {
        return String.valueOf(this.raveAgent.getDataDir()) + this.getDSInstanceFullName();
    }

    public void newCache() throws IOException {
        if (this.dataCache == null) {
            this.dataCache = new RaveCache(String.valueOf(this.raveAgent.getDataDir()) + this.getDSInstanceFullName(), CACHE_FILE_NAME);
        } else {
            this.dataCache.clear();
        }
        this.dataCache.writeAndCommit();
    }

    private RaveCache loadCache() {
        try {
            return RaveCache.deSerialize2(String.valueOf(this.raveAgent.getDataDir()) + this.getDSInstanceFullName(), CACHE_FILE_NAME, this.getClass().getClassLoader());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IRaveContentCache getCache() {
        return this.dataCache;
    }

    public IRaveContentFullCache getFullCache() {
        return this.dataCache;
    }

    public IAgentDataSourceState getStateEngine() {
        return this.stateEngine;
    }

    public IStateEngineAdminInterface getStateEngineAdmin() {
        return this.stateEngineAdmin;
    }

    public void setState(IAgentDataSourceState state) {
        this.setStateAndCtx(state, this.stateCtx);
    }

    public IAgentDataSourceState getState() {
        return this.state;
    }

    public void setStateContext(Serializable stateCtx) {
        this.setStateAndCtx(this.state, stateCtx);
    }

    public Serializable getStateContext() {
        return this.stateCtx;
    }

    public void setStateAndCtx(IAgentDataSourceState state, Serializable stateCtx) {
        try {
            this.persistState.writeAndCommit((Serializable)new Object[]{state, stateCtx});
        }
        catch (IOException e) {
            this.getFeedback().error("Failed storing state!", e);
            throw new StopCollectionException("Failed storing state! " + e.getMessage());
        }
        this.state = state;
        this.stateCtx = stateCtx;
    }

    public IWatchedAgent getWatchedAgentBean() {
        if (this.watchedAgent == null) {
            this.watchedAgent = this.raveAgent.getWatchedAgentBean();
        }
        return this.watchedAgent;
    }

    public void notifyConnectionDeath() {
        this.watchedAgent = null;
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.feedback;
    }

    public IDataSourceInstance getDSInstance() {
        return this.dsInstance;
    }

    public void contentChangeEvent(IAgentContentChangeEvent contentChangeEvent) throws RestartScanException, RestartCollectionException {
        this.checkState();
        try {
            this.resumeCollectionIfNeeded();
            this.getStateEngine().contentChangeEvent(this, contentChangeEvent);
        }
        catch (ConnectionException e) {
            this.getFeedback().error("Unexpected exception!" + (Object)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
        catch (ACommException e) {
            this.getFeedback().error("Unexpected exception!" + (Object)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
        catch (ADataSourceCollectionException e) {
            this.handleADataSourceCollectionException(e);
        }
    }

    private void handleADataSourceCollectionException(ADataSourceCollectionException ex) throws RestartScanException, RestartCollectionException {
        if (ex instanceof RestartScanException) {
            this.restartScanThrown = true;
            throw (RestartScanException)ex;
        }
        if (ex instanceof RestartCollectionException) {
            this.restartCollectionThrown = true;
            throw (RestartCollectionException)ex;
        }
        this.getFeedback().error("Unexpected ADataSourceCollectionException!", (Throwable)((Object)ex));
        this.stopCollection();
        throw new StopCollectionException("Unexpected data source collection exception!" + ex.getMessage());
    }

    public void endOfScan() throws RestartCollectionException, RestartScanException {
        this.checkState();
        try {
            this.resumeCollectionIfNeeded();
            this.getStateEngine().endOfScan(this);
            ++this.scansCompletedCounter;
        }
        catch (ConnectionException e) {
            this.getFeedback().error("Unexpected exception!" + (Object)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
        catch (ACommException e) {
            this.getFeedback().error("Unexpected exception!" + (Object)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
        catch (ADataSourceCollectionException e) {
            this.handleADataSourceCollectionException(e);
        }
    }

    protected void resumeCollectionIfNeeded() throws ADataSourceCollectionException, ACommException, ConnectionException {
        if (this.collectionResumed) {
            return;
        }
        if (this.dbDeleted) {
            this.setState(StartState.getDataSourceState());
            this.getStateEngineAdmin().IStateEngineAdmin_setEngineState((Object)StartState.getDataSourceState());
            this.getStateEngine().transitionToState(this);
            this.dbDeleted = false;
        } else {
            this.getStateEngine().crash(this, null);
        }
        this.collectionResumed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDataSourceListener() {
        try {
            this.dataCache.clear();
            this.dataCache.writeAndCommit();
        }
        catch (IOException e) {
            this.feedback.error("Failed clearing cache!", e);
            throw new StopCollectionException("Failed clearing cache!");
        }
        DataSourceListener dataSourceListener = this;
        synchronized (dataSourceListener) {
            this.dataPointsTotalCounter = 0;
            this.additionsTotalCounter = 0;
            this.deletionsTotalCounter = 0;
            this.modificationsTotalCounter = 0;
        }
    }

    public void forceCleanStart() throws RestartCollectionException {
        this.cleanDataSourceListener();
        this.dbDeleted = true;
        this.collectionResumed = false;
        this.changeEventBuffer.clear();
        throw new RestartCollectionException(this.getDSInstanceFullName());
    }

    public void requestScanRestart() throws RestartScanException, RestartCollectionException {
        this.checkState();
        try {
            this.resumeCollectionIfNeeded();
            this.getStateEngine().crash(this, new ConnectionException("Fake conn exception!"));
        }
        catch (ACommException e) {
            this.getFeedback().error("Unexpected exception!" + (Object)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
        catch (ConnectionException e) {
            this.getFeedback().error("Unexpected exception!" + (Object)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
        catch (ADataSourceCollectionException e) {
            this.handleADataSourceCollectionException(e);
        }
    }

    public void forceScanRestart() throws RestartScanException {
        try {
            this.dataCache.read();
            this.collectionResumed = false;
            this.changeEventBuffer.clear();
            throw new RestartScanException(this.getDSInstanceFullName());
        }
        catch (IOException e) {
            this.getFeedback().error("Failed reloading cache for data source " + this.getDSInstanceFullName(), e);
            this.stopCollection();
            throw new StopCollectionException("Failed reading cache file!");
        }
    }

    public ITaskId addCollectionTask(IDataSourceTask task, Schedule schedule, String taskName) {
        ITaskId taskId = this.raveAgent.addRaveTask(new DataSourceTaskExecutor(this, task, taskName), schedule);
        if (schedule.isRepetitive()) {
            this.collectionTasks.add(taskId);
        }
        return taskId;
    }

    public void stopCollectionTask(ITaskId taskId) {
        this.raveAgent.rmRaveTask(taskId);
        this.collectionTasks.remove(taskId);
    }

    public void commit() {
        try {
            this.dataCache.commit();
            this.firstScanAfterRestart = false;
        }
        catch (IOException e) {
            this.getFeedback().error("Failed committing cache for data source " + this.dsInstance.getDisplayName(), e);
            this.stopCollection();
            throw new StopCollectionException("Failed committing cache file!");
        }
    }

    public boolean needToCommit() {
        return this.firstScanAfterRestart || this.dataCache.dirty() || this.watchedAgent == null || this.raveAgent.staleWatchedAgent(this.watchedAgent);
    }

    public void writeCache() {
        try {
            this.dataCache.write();
        }
        catch (IOException e) {
            this.getFeedback().error("Failed writing cache to tmp file for data source " + this.getDSInstance(), e);
            this.stopCollection();
            throw new StopCollectionException("Failed writing cache to tmp file!");
        }
    }

    public String getTmpDir() {
        return this.raveAgent.getTmpDir();
    }

    public boolean collectionStopped() {
        return this.collectionStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCollection() {
        if (this.collectionStopped) {
            return;
        }
        Iterator iter = ((List)this.collectionTasks.clone()).iterator();
        while (iter.hasNext()) {
            this.stopCollectionTask((ITaskId)iter.next());
        }
        if (this.heartbeat != null) {
            IntervalHeartbeat intervalHeartbeat = this.heartbeat;
            synchronized (intervalHeartbeat) {
                if (this.metricBehavior != null) {
                    this.heartbeat.removeBehavior(this.metricBehavior);
                    this.metricBehavior = null;
                }
            }
        }
        this.collectionStopped = true;
    }

    protected List getTasks() {
        return this.collectionTasks;
    }

    private final void checkState() throws RestartCollectionException, RestartScanException {
        if (this.restartCollectionThrown) {
            throw new RestartCollectionException("Collection must be restarted before proceeding!");
        }
        if (this.restartScanThrown) {
            throw new RestartCollectionException("Scan must be restarted before proceeding!");
        }
        if (this.collectionStopped) {
            throw new StopCollectionException("Collection has been stopped! Cannot proceed.");
        }
    }

    public void restartScan() {
        this.restartScanThrown = false;
        this.firstScanAfterRestart = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartCollection() {
        if (this.heartbeat != null) {
            IntervalHeartbeat intervalHeartbeat = this.heartbeat;
            synchronized (intervalHeartbeat) {
                if (this.metricBehavior == null) {
                    this.metricBehavior = this.heartbeat.addBehavior(this.createMetricBehavior(), "ChangeDetector Data Source (" + this.dsInstance.getName() + ") Metric Behavior", true, 15000L, true);
                }
            }
        }
        this.restartCollectionThrown = false;
        this.firstScanAfterRestart = true;
    }

    public final IContentChangeEvent[] bufferEvent(IContentChangeEvent contentChangeEvent) {
        this.changeEventBuffer.add(contentChangeEvent);
        if (this.changeEventBuffer.size() == this.batchSize) {
            return this.getEventsBuffer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IContentChangeEvent[] getEventsBuffer() {
        IContentChangeEvent[] oldBuffer = null;
        if (this.changeEventBuffer.size() != 0) {
            oldBuffer = this.changeEventBuffer.toArray(new IContentChangeEvent[this.changeEventBuffer.size()]);
            this.changeEventBuffer.clear();
            DataSourceListener dataSourceListener = this;
            synchronized (dataSourceListener) {
                int x = 0;
                while (x < oldBuffer.length) {
                    if (oldBuffer[x].isAdditionEvent()) {
                        ++this.additionsTotalCounter;
                    } else if (oldBuffer[x].isDeletionEvent()) {
                        ++this.deletionsTotalCounter;
                    } else {
                        ++this.modificationsTotalCounter;
                    }
                    ++x;
                }
                this.dataPointsTotalCounter += oldBuffer.length;
                if (this.fDataPointsPerIntervalAccumulator != null) {
                    this.coreAgent.IAgent_getDataAccumulatorFactory().trackAccumulatorForMetric(this.fDataPointsPerIntervalAccumulator.IDataAccumulator_getMetric(), (IDataAccumulator)this.fDataPointsPerIntervalAccumulator);
                    this.fDataPointsPerIntervalAccumulator.ILongIntervalCounterDataAccumulator_addBatchIncidents((long)oldBuffer.length);
                }
            }
        }
        return oldBuffer;
    }
}

