/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.rave.agent.ds.classmonitor.CompressionHelper;

public final class ClassInfoContainer {
    private final ClassLoader classloader;
    private final String className;
    private byte[] classBytes;
    private String assemblyPath;
    private String assemblyVersion;
    private final boolean fIsCompressed;

    ClassInfoContainer(ClassLoader classLoader, String className, byte[] classBytes, boolean isCompressed) {
        this.assemblyPath = null;
        this.classloader = classLoader;
        this.className = className;
        this.classBytes = classBytes;
        this.fIsCompressed = isCompressed;
    }

    ClassInfoContainer(String assemblyPath, String version, ClassLoader classLoader, String className, byte[] classBytes, boolean isCompressed) {
        this.assemblyPath = assemblyPath;
        this.assemblyVersion = version;
        this.classloader = classLoader;
        this.className = className;
        this.classBytes = classBytes;
        this.fIsCompressed = isCompressed;
    }

    final byte[] getClassBytes() {
        if (this.isCompressed()) {
            byte[] result = CompressionHelper.getInstance().decompress(this.classBytes);
            this.classBytes = CompressionHelper.getInstance().substituteBytes(this.classBytes);
            return result;
        }
        return this.classBytes;
    }

    public final ClassLoader getClassloader() {
        return this.classloader;
    }

    public final String getClassName() {
        String retVal = this.assemblyPath != null ? String.valueOf(this.assemblyPath) + "\\" + this.className : this.className;
        return retVal;
    }

    public static final ClassInfoContainer getCompressedEntry(ClassInfoContainer c) {
        return CompressionHelper.getInstance().compress(c);
    }

    public boolean isCompressed() {
        return this.fIsCompressed;
    }

    public String getAssemblyPath() {
        return this.assemblyPath;
    }

    public String getAssemblyVersion() {
        return this.assemblyVersion;
    }
}

