/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.rave.agent.ds.classmonitor.ClassInfoContainer;
import com.wily.rave.agent.ds.classmonitor.ClassSpec;
import com.wily.rave.utils.FastMD5Encoder;

public final class ClassInfoContainerDecorator {
    private byte[] digest;
    private ClassSpec cSpec;
    private ClassInfoContainer classInfo;
    private String className;
    private byte[] actualBytes;

    ClassInfoContainerDecorator(ClassInfoContainer classInfo) {
        this.classInfo = classInfo;
        this.actualBytes = classInfo.getClassBytes();
    }

    public final byte[] getClassBytes() {
        return this.actualBytes;
    }

    public final ClassLoader getClassloader() {
        return this.classInfo.getClassloader();
    }

    public final String getClassName() {
        if (this.className == null) {
            this.className = this.classInfo.getClassName().replace('/', '.');
        }
        return this.className;
    }

    public final byte[] getDigest(FastMD5Encoder encoder) {
        if (this.digest == null) {
            this.digest = encoder.encode(this.getClassBytes());
        }
        return this.digest;
    }

    public final ClassSpec getClassSpec() {
        if (this.cSpec == null) {
            this.cSpec = ClassSpec.getClassSpec(this.getClassName(), this.getClassloader());
        }
        return this.cSpec;
    }

    public final String getAssemblyPath() {
        return this.classInfo.getAssemblyPath();
    }

    public final String getAssemblyVersion() {
        return this.classInfo.getAssemblyVersion();
    }
}

