/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.ClassFileTransformerShouldNotRunException;
import com.wily.rave.agent.cache.IRaveContentCache;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.IPolledDataSource;
import com.wily.rave.agent.ds.classmonitor.AgentClassAdditionEvent;
import com.wily.rave.agent.ds.classmonitor.AgentClassModificationEvent;
import com.wily.rave.agent.ds.classmonitor.ClassCacheEntry;
import com.wily.rave.agent.ds.classmonitor.ClassInfoContainer;
import com.wily.rave.agent.ds.classmonitor.ClassInfoContainerDecorator;
import com.wily.rave.agent.ds.classmonitor.ClassMonitorDataSourceProps;
import com.wily.rave.agent.ds.classmonitor.ClassTransformerWrapper;
import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.spec.ds.classmonitor.ClassContent;
import com.wily.rave.spec.ds.classmonitor.ClassContentValue;
import com.wily.rave.utils.FastMD5Encoder;
import com.wily.util.ExcludePattern;
import java.util.Arrays;
import java.util.Date;

public class RuntimeClassMonitor
implements IPolledDataSource {
    private IDataSourceListener listener;
    private ClassTransformerWrapper transformer;
    private ExcludePattern[] excludePatterns;
    private ClassMonitorDataSourceProps configProps;
    private FastMD5Encoder encoder;
    private boolean needEndOfScan;

    public RuntimeClassMonitor(IAgent agent, ExcludePattern[] excludePatterns, ClassMonitorDataSourceProps configProps) throws ClassFileTransformerShouldNotRunException {
        this.excludePatterns = excludePatterns == null || excludePatterns.length == 0 ? null : excludePatterns;
        this.transformer = new ClassTransformerWrapper(agent);
        this.configProps = configProps;
        this.needEndOfScan = true;
        this.encoder = FastMD5Encoder.getInstance();
    }

    public void init(IDataSourceListener listener) throws RestartCollectionException, RestartScanException {
        this.listener = listener;
    }

    public void collect() throws RestartCollectionException, RestartScanException {
        int classesProcessedCount = 0;
        IRaveContentCache cache = this.listener.getCache();
        ClassInfoContainer classInfoContainerRaw = this.transformer.getNextClass(false);
        while (classInfoContainerRaw != null) {
            ClassInfoContainerDecorator classInfoContainer = new ClassInfoContainerDecorator(classInfoContainerRaw);
            if (this.excludePatterns == null || !ExcludePattern.matches(this.excludePatterns, classInfoContainer.getClassName())) {
                ClassCacheEntry cacheEntry = (ClassCacheEntry)cache.get(classInfoContainer.getClassSpec());
                if (cacheEntry == null) {
                    this.listener.contentChangeEvent(new AgentClassAdditionEvent(new Date().getTime(), classInfoContainer.getClassSpec(), this.getContent(classInfoContainer), this.createEntry(classInfoContainer)));
                    this.needEndOfScan = true;
                } else if (cacheEntry.getSize() != (long)classInfoContainer.getClassBytes().length || !Arrays.equals(cacheEntry.getDigest(), classInfoContainer.getDigest(this.encoder))) {
                    this.listener.contentChangeEvent(new AgentClassModificationEvent(new Date().getTime(), classInfoContainer.getClassSpec(), this.getContent(classInfoContainer), this.createEntry(classInfoContainer)));
                    this.needEndOfScan = true;
                }
                ++classesProcessedCount;
            }
            if ((long)classesProcessedCount >= this.configProps.maxClassesPerRun) {
                return;
            }
            classInfoContainerRaw = this.transformer.getNextClass(false);
        }
        if (this.needEndOfScan) {
            this.listener.endOfScan();
        }
        this.needEndOfScan = false;
    }

    private final ClassCacheEntry createEntry(ClassInfoContainerDecorator classInfoContainer) {
        return new ClassCacheEntry(classInfoContainer.getDigest(this.encoder), classInfoContainer.getClassBytes().length, classInfoContainer.getClassloader());
    }

    private final ClassContent getContent(ClassInfoContainerDecorator classInfoContainer) {
        if (this.configProps.maxFileSizeToUpload >= (long)classInfoContainer.getClassBytes().length) {
            return new ClassContent(classInfoContainer.getClassSpec().getFullName(), new ClassContentValue(classInfoContainer.getClassBytes()), (long)classInfoContainer.getClassBytes().length, classInfoContainer.getDigest(this.encoder), this.listener.getDSInstance());
        }
        return new ClassContent(classInfoContainer.getClassSpec().getFullName(), (long)classInfoContainer.getClassBytes().length, classInfoContainer.getDigest(this.encoder), this.listener.getDSInstance());
    }

    public void restartScan() {
        this.listener.restartScan();
    }

    public void restartCollection() {
        this.listener.restartCollection();
    }

    public void stop() throws RestartCollectionException, RestartScanException {
        this.transformer.disable();
    }
}

