/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.agent.ds.file.ArchiveFileInfoHolder;
import com.wily.rave.agent.ds.file.FileSet;
import com.wily.rave.agent.ds.file.FileSystemMonitor;
import com.wily.rave.agent.ds.file.JarFileWalker;
import com.wily.rave.agent.ds.file.fileSpec.AFileSpec;
import com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpec;
import com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpecRuntime;
import com.wily.rave.agent.ds.task.IDataSourceTask;
import com.wily.rave.agent.task.Schedule;
import com.wily.rave.spec.ds.filemonitor.BinaryFileContent;
import com.wily.rave.spec.ds.filemonitor.FileContent;
import com.wily.rave.utils.FastMD5Encoder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ArchiveMonitor
implements IDataSourceTask {
    private final FileSystemMonitor fMonitor;
    private Set fJarFiles;
    private final IModuleFeedbackChannel fFeedback;
    private HashMap fFileSets;

    protected ArchiveMonitor(FileSystemMonitor monitor) {
        this.fMonitor = monitor;
        this.fFeedback = this.fMonitor.getDSListener().getFeedback();
        this.reset();
        ZipEntryFileSpecRuntime.setTmpDirName(this.fMonitor.getDSListener().getTmpDir());
    }

    static final ArchiveMonitor getArchiveMonitor(FileSystemMonitor monitor) {
        if (!monitor.getConfigurationProps().explodeArchiveFiles) {
            return null;
        }
        return new ArchiveMonitor(monitor);
    }

    public void schedule() {
        Schedule schedule = Schedule.getRepetetiveSchedule(this.fMonitor.getConfigurationProps().delayBetweenArchiveIterations);
        ArchiveMonitor dataSourceCollection = this;
        this.fMonitor.getDSListener().addCollectionTask(dataSourceCollection, schedule, String.valueOf(this.fMonitor.getDataSourceName()) + ":" + dataSourceCollection.getClass().getName());
    }

    void handleArchiveFileChange(ArchiveFileInfoHolder archiveFileHolder) throws RestartCollectionException, RestartScanException {
        if (!this.fMonitor.getConfigurationProps().explodeArchiveFiles) {
            if (this.fMonitor.getConfigurationProps().useDigest == 0 && archiveFileHolder.getDigest() == null) {
                try {
                    archiveFileHolder.setDigest(FastMD5Encoder.getInstance().encode(archiveFileHolder.getFile()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            BinaryFileContent fileContent = null;
            fileContent = archiveFileHolder.getDigest() != null ? new BinaryFileContent(this.fMonitor.getDSListener().getDSInstance(), archiveFileHolder.getFileSpec().getFullName(), archiveFileHolder.getFileSpec().getFileOwner(), archiveFileHolder.getLastModifiedTime(), archiveFileHolder.getSize(), archiveFileHolder.getDigest()) : new BinaryFileContent(this.fMonitor.getDSListener().getDSInstance(), archiveFileHolder.getFileSpec().getFullName(), archiveFileHolder.getFileSpec().getFileOwner(), archiveFileHolder.getLastModifiedTime(), archiveFileHolder.getSize());
            this.fMonitor.reportChangeEvent((FileContent)fileContent, archiveFileHolder.getFileSpec(), archiveFileHolder.newFile());
        } else {
            this.fFeedback.debug("Adding to list of jar files to be processed: " + archiveFileHolder.getFileSpec());
            this.fJarFiles.add(archiveFileHolder);
        }
    }

    public void collect() throws RestartCollectionException, RestartScanException {
        int i = this.fMonitor.getConfigurationProps().filesPerArchiveIteration;
        do {
            JarFileWalker jarFileWalker;
            if ((jarFileWalker = this.getNextJarFileWalker()) == null) {
                return;
            }
            jarFileWalker.collectContent();
        } while (--i > 0);
    }

    protected boolean moreFiles() {
        return !this.fJarFiles.isEmpty();
    }

    private JarFileWalker getNextJarFileWalker() {
        AFileSpec archiveFileS = null;
        if (this.fJarFiles.isEmpty()) {
            return null;
        }
        ArchiveFileInfoHolder archiveFileHolder = (ArchiveFileInfoHolder)this.fJarFiles.iterator().next();
        archiveFileS = archiveFileHolder.getFileSpec();
        this.fJarFiles.remove(archiveFileHolder);
        FileSet prevFileSet = (FileSet)this.fFileSets.get(archiveFileS);
        if (prevFileSet == null) {
            prevFileSet = new FileSet(this.fFeedback);
            this.fFileSets.put(archiveFileS, prevFileSet);
        }
        JarFileWalker walker = new JarFileWalker(this, archiveFileHolder, prevFileSet);
        return walker;
    }

    public boolean isDone() {
        return !this.moreFiles();
    }

    public FileSystemMonitor getFileSystemMonitor() {
        return this.fMonitor;
    }

    public void init(IDataSourceListener listener) {
    }

    public void loadZipEntry(ZipEntryFileSpec fSpec) {
        AFileSpec parentSpec = fSpec.getParentFileSpec();
        FileSet prevFileSet = (FileSet)this.fFileSets.get(parentSpec);
        if (prevFileSet == null) {
            prevFileSet = new FileSet(this.fFeedback);
            this.fFileSets.put(parentSpec, prevFileSet);
        }
        prevFileSet.addFile(fSpec);
    }

    void deleteArchive(AFileSpec archive) throws RestartCollectionException, RestartScanException {
        this.deleteArchiveMembers(archive);
        this.fMonitor.reportDeleteEvent(archive);
    }

    private void deleteArchiveMembers(AFileSpec archive) throws RestartCollectionException, RestartScanException {
        IDataSourceListener listener = this.fMonitor.getDSListener();
        if (listener.getCache().get(archive) == null) {
            return;
        }
        FileSet memberFiles = (FileSet)this.fFileSets.get(archive);
        if (memberFiles == null) {
            return;
        }
        Iterator iter = memberFiles.getFileIterator();
        while (iter.hasNext()) {
            ZipEntryFileSpec memberFile = (ZipEntryFileSpec)iter.next();
            this.fMonitor.reportDeletion(memberFile);
        }
        this.fFileSets.remove(archive);
    }

    public void stop() {
    }

    void reset() {
        this.fJarFiles = new HashSet();
        this.fFileSets = new HashMap();
    }

    public void restartScan() {
        this.fMonitor.restartScan();
    }

    public void restartCollection() {
        this.fMonitor.restartCollection();
    }
}

