/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.introscope.agent.IAgent;
import com.wily.rave.agent.config.ADataSourceConfig;
import com.wily.rave.agent.config.ConfigException;
import com.wily.rave.agent.config.DirectoryScanSpec;
import com.wily.rave.agent.config.IUpdatingDataSourceConfig;
import com.wily.rave.agent.config.parser.ElementParserHelper;
import com.wily.rave.agent.config.parser.PropertyParser;
import com.wily.rave.agent.ds.IPolledDataSource;
import com.wily.rave.agent.ds.file.FileDataSourceConfigProps;
import com.wily.rave.agent.ds.file.FilePatternFilter;
import com.wily.rave.agent.ds.file.FileSystemMonitor;
import com.wily.rave.agent.task.Schedule;
import com.wily.util.ExcludePattern;
import com.wily.util.GlobToRegularExpression;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.SystemOutFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.crimson.tree.CommentNode;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.TextNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileDataSourceConfig
extends ADataSourceConfig
implements IUpdatingDataSourceConfig {
    private static final String PROP_EXPLODE_ARCHIVE_FILES = "explodeArchiveFiles";
    private static final String PROP_DELAY_BETWEEN_ITERATIONS = "delayBetweenIterations";
    private static final String PROP_FILES_PER_ITERATION = "filesPerIteration";
    private static final String PROP_DELAY_BETWEEN_ARCHIVE_ITERATIONS = "delayBetweenArchiveIterations";
    private static final String PROP_ARCHIVE_FILES_PER_ITERATION = "archiveFilesPerIteration";
    private static final String PROP_MAX_FILE_SIZE_TO_UPLOAD = "maxFileSizeToUpload";
    private static final String PROP_USE_DIGEST = "useDigest";
    private static final String UNIT = "unit";
    protected Map fFileSets = new HashMap();
    protected Map fOldFileSets = new HashMap();
    protected List fScanDirectories;
    private FileDataSourceConfigProps fDataSourceConfigProps;
    protected Element updatedXMLElement;
    private boolean fAssumeCurrent;
    private IModuleFeedbackChannel fFeedback = new SystemOutFeedbackChannel("ChangeDetector_uninitialized");

    public IPolledDataSource parseConfig(Element dataSourceRoot, IAgent agent, IModuleFeedbackChannel feedback, IStringLocalizer localizer) throws ConfigException {
        this.fFeedback = feedback;
        this.fScanDirectories = new LinkedList();
        this.fDataSourceConfigProps = new FileDataSourceConfigProps();
        this.doParse(dataSourceRoot);
        if (this.fScanDirectories.isEmpty()) {
            throw new ConfigException("No scan-directory elements defined for this datasource: " + dataSourceRoot.getAttribute("name"));
        }
        return new FileSystemMonitor(this.fScanDirectories, this.fDataSourceConfigProps);
    }

    public Schedule getMainTaskSchedule() {
        return Schedule.getRepetetiveSchedule(this.fDataSourceConfigProps.delayBetweenIterations);
    }

    protected void doParse(Element dataSourceRoot) throws ConfigException {
        Element clonedElement = (Element)dataSourceRoot.cloneNode(true);
        String version = ElementParserHelper.getOptionalAttribute(dataSourceRoot, "version");
        this.updatedXMLElement = null;
        this.fAssumeCurrent = true;
        if (version == null) {
            clonedElement.setAttribute("version", "8.0");
            this.fAssumeCurrent = false;
        } else if (version.equals("7.1")) {
            clonedElement.setAttribute("version", "8.0");
            this.updatedXMLElement = clonedElement;
        } else if (!version.equals("8.0")) {
            throw new ConfigException("Unknown File Monitor DataSource Config Version: " + version);
        }
        Node child = clonedElement.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                this.parseElement((Element)child);
            }
            child = child.getNextSibling();
        }
        if (!clonedElement.toString().equals(dataSourceRoot.toString())) {
            TextNode textNode = new TextNode("\n\t\t");
            CommentNode commentNode = new CommentNode("One or more fileset elements were updated to fit the new schema.  Please refer to the documentation on possible implications for the update");
            Node firstChild = clonedElement.getFirstChild();
            if (firstChild != null) {
                clonedElement.insertBefore(commentNode, firstChild);
                clonedElement.insertBefore(textNode, commentNode);
            } else {
                clonedElement.appendChild(commentNode);
                clonedElement.insertBefore(textNode, commentNode);
            }
            ElementNode useDigestElementNode = new ElementNode("property");
            useDigestElementNode.setAttribute("name", PROP_USE_DIGEST);
            useDigestElementNode.setAttribute("value", "needed");
            if (firstChild != null) {
                boolean inserted = false;
                Node currentNode = firstChild;
                Node lastProperty = null;
                while (!inserted) {
                    if (currentNode instanceof Element) {
                        if (!currentNode.getNodeName().equals("property")) {
                            if (lastProperty != null) {
                                currentNode = lastProperty.getNextSibling();
                            } else {
                                currentNode = firstChild;
                                while (currentNode instanceof TextNode && currentNode != null) {
                                    currentNode = currentNode.getNextSibling();
                                }
                            }
                            if (currentNode == null) {
                                this.insertUseDigestElement(clonedElement, null);
                            } else {
                                this.insertUseDigestElement(clonedElement, currentNode);
                            }
                            inserted = true;
                            continue;
                        }
                        if (currentNode.getNextSibling() == null) {
                            this.insertUseDigestElement(clonedElement, null);
                            inserted = true;
                            continue;
                        }
                        lastProperty = currentNode;
                        currentNode = currentNode.getNextSibling();
                        continue;
                    }
                    if (currentNode.getNextSibling() == null) {
                        this.insertUseDigestElement(clonedElement, null);
                        inserted = true;
                        continue;
                    }
                    currentNode = currentNode.getNextSibling();
                }
            } else {
                this.insertUseDigestElement(clonedElement, null);
            }
            this.updatedXMLElement = clonedElement;
        }
    }

    private void insertUseDigestElement(Element clonedElement, Node currentNode) {
        TextNode beforeCommentTextNode = new TextNode("\n\n\t\t");
        CommentNode useDigestCommentNode = new CommentNode("The useDigest property has been added to your config file with the default setting of \"needed\".  Please refer to the documentation for more information.");
        TextNode beforeElementTextNode = new TextNode("\n\t\t");
        TextNode afterElementTextNode = new TextNode("\n\n\t\t");
        ElementNode useDigestElementNode = new ElementNode("property");
        useDigestElementNode.setAttribute("name", PROP_USE_DIGEST);
        useDigestElementNode.setAttribute("value", "needed");
        if (currentNode == null) {
            clonedElement.appendChild(afterElementTextNode);
        } else {
            clonedElement.insertBefore(afterElementTextNode, currentNode);
        }
        clonedElement.insertBefore(useDigestElementNode, afterElementTextNode);
        clonedElement.insertBefore(beforeElementTextNode, useDigestElementNode);
        clonedElement.insertBefore(useDigestCommentNode, beforeElementTextNode);
        clonedElement.insertBefore(beforeCommentTextNode, useDigestCommentNode);
    }

    private void updateFilesetElement(Element element) throws ConfigException {
        try {
            OldFileSetParser ofsp = new OldFileSetParser();
            ofsp.doParse(this.fOldFileSets, element);
            Node child = element.getFirstChild();
            while (child != null) {
                if (!(child instanceof CommentNode)) {
                    Node previousSibling = child.getPreviousSibling();
                    element.removeChild(child);
                    if (previousSibling == null) {
                        child = element.getFirstChild();
                        continue;
                    }
                    child = previousSibling;
                }
                child = child.getNextSibling();
            }
            String[] includes = ofsp.fIncludePatterns;
            String[] excludes = ofsp.fExcludePatterns;
            if (includes == null) {
                includes = new String[]{};
            }
            if (excludes == null) {
                excludes = new String[]{};
            }
            String lineSeparator = "\n";
            if (excludes.length > 0) {
                int x = 0;
                while (x < excludes.length) {
                    ElementNode excludeElement = new ElementNode("exclude");
                    excludeElement.setAttribute("pattern", GlobToRegularExpression.convertGlobPattern(excludes[x]));
                    if (includes.length > 0) {
                        int y = 0;
                        while (y < includes.length) {
                            ElementNode includeElement = new ElementNode("include");
                            includeElement.setAttribute("pattern", GlobToRegularExpression.convertGlobPattern(includes[y]));
                            excludeElement.appendChild(new TextNode(String.valueOf(lineSeparator) + "\t\t\t\t"));
                            excludeElement.appendChild(includeElement);
                            ++y;
                        }
                    }
                    excludeElement.appendChild(new TextNode(String.valueOf(lineSeparator) + "\t\t\t"));
                    element.appendChild(new TextNode(String.valueOf(lineSeparator) + "\t\t\t"));
                    element.appendChild(excludeElement);
                    ++x;
                }
            } else if (includes.length > 0) {
                CommentNode commentNode = new CommentNode("Since there are no exclude elements in this fileset, there is no semantic equivalent for the current version.");
                element.appendChild(new TextNode(String.valueOf(lineSeparator) + "\t\t\t"));
                element.appendChild(commentNode);
                element.appendChild(new TextNode(String.valueOf(lineSeparator) + "\t\t\t"));
                commentNode = new CommentNode("The conversion process will comment out the include elements.");
                element.appendChild(commentNode);
                CommentNode includeComment = new CommentNode();
                StringBuffer includeNodes = new StringBuffer();
                if (includes.length > 0) {
                    int y = 0;
                    while (y < includes.length) {
                        includeNodes.append(lineSeparator);
                        includeNodes.append("\t\t\t\t");
                        includeNodes.append("<include pattern=\"");
                        includeNodes.append(GlobToRegularExpression.convertGlobPattern(includes[y]));
                        includeNodes.append("\" />");
                        ++y;
                    }
                }
                includeNodes.append(lineSeparator);
                includeNodes.append("\t\t\t");
                includeComment.setData(includeNodes.toString());
                element.appendChild(new TextNode(String.valueOf(lineSeparator) + "\t\t\t"));
                element.appendChild(includeComment);
            }
            element.appendChild(new TextNode(String.valueOf(lineSeparator) + "\t\t"));
        }
        catch (ConfigException ce) {
            if (ce.getMessage().equals("exclude has sub-nodes!")) {
                this.fAssumeCurrent = false;
                return;
            }
            throw ce;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseElement(Element element) throws ConfigException {
        String elementName = element.getNodeName();
        if (elementName.equals("scan-directory")) {
            ScanDirectoryParser parser = new ScanDirectoryParser();
            parser.doParse(this.fFileSets, this.fScanDirectories, element);
            return;
        } else if (elementName.equals("fileset")) {
            if (!this.fAssumeCurrent) {
                this.updateFilesetElement(element);
            }
            FileSetParser parser = new FileSetParser();
            parser.doParse(this.fFileSets, element);
            return;
        } else {
            if (!elementName.equals("property")) throw new ConfigException("Invalid element: " + elementName);
            PropertyParser propParser = new PropertyParser(element);
            String propName = propParser.getName();
            if (PROP_EXPLODE_ARCHIVE_FILES.equals(propName)) {
                this.fDataSourceConfigProps.explodeArchiveFiles = propParser.getBooleanValue();
                return;
            } else if (PROP_DELAY_BETWEEN_ITERATIONS.equals(propName)) {
                this.fDataSourceConfigProps.delayBetweenIterations = propParser.getIntValue() * propParser.getTimeUnitMultiplier(UNIT, 1);
                return;
            } else if (PROP_FILES_PER_ITERATION.equals(propName)) {
                this.fDataSourceConfigProps.filesPerIteration = propParser.getIntValue();
                return;
            } else if (PROP_DELAY_BETWEEN_ARCHIVE_ITERATIONS.equals(propName)) {
                this.fDataSourceConfigProps.delayBetweenArchiveIterations = propParser.getIntValue() * propParser.getTimeUnitMultiplier(UNIT, 1);
                return;
            } else if (PROP_ARCHIVE_FILES_PER_ITERATION.equals(propName)) {
                this.fDataSourceConfigProps.filesPerArchiveIteration = propParser.getIntValue();
                return;
            } else if (PROP_MAX_FILE_SIZE_TO_UPLOAD.equals(propName)) {
                this.fDataSourceConfigProps.maxFileSizeToUpload = propParser.getIntValue() * propParser.getDataSizeUnitMultilplier(UNIT, 1);
                return;
            } else {
                if (!PROP_USE_DIGEST.equals(propName)) throw new ConfigException("Invalid property " + propParser);
                String useDigestValue = propParser.getOptionalAttributeValue("value");
                if (useDigestValue == null || useDigestValue.equalsIgnoreCase("needed")) return;
                if (useDigestValue.equalsIgnoreCase("always")) {
                    this.fDataSourceConfigProps.useDigest = 1;
                    return;
                } else {
                    if (!useDigestValue.equalsIgnoreCase("never")) throw new ConfigException("Invalid value for property " + propName + ": " + useDigestValue);
                    this.fDataSourceConfigProps.useDigest = 2;
                }
            }
        }
    }

    public Element getUpdatedXMLElement() {
        return this.updatedXMLElement;
    }

    public boolean shouldExistingElementBeBackedUp() {
        return true;
    }

    public String getDataSourceType() {
        return "FSMonitor";
    }

    private static class FileSetParser {
        private String fName;
        private ExcludePattern[] fExcludePatterns;

        private FileSetParser() {
        }

        public void doParse(Map fileSets, Element element) throws ConfigException {
            this.fName = ElementParserHelper.getRequiredAttribute(element, "name");
            HashSet excludePatterns = new HashSet();
            Node child = element.getFirstChild();
            while (child != null) {
                if (child instanceof Element) {
                    this.parseChild((Element)child, excludePatterns, fileSets);
                }
                child = child.getNextSibling();
            }
            this.fExcludePatterns = new ExcludePattern[excludePatterns.size()];
            excludePatterns.toArray(this.fExcludePatterns);
            fileSets.put(FileSetParser.getUniqueIdentifier(this.fName), this);
        }

        private void parseChild(Element child, HashSet excludeSet, Map fileSets) throws ConfigException {
            String name = child.getNodeName();
            if (name.equals("exclude")) {
                String exclude = ElementParserHelper.getRequiredAttribute(child, "pattern", false);
                ExcludePattern excludePattern = new ExcludePattern(exclude);
                excludeSet.add(excludePattern);
                Node includeChild = child.getFirstChild();
                while (includeChild != null) {
                    if (includeChild instanceof Element) {
                        if (!includeChild.getNodeName().equals("include")) {
                            throw new ConfigException("Unexpected or invalid node: " + includeChild.getNodeName());
                        }
                        String include = ElementParserHelper.getRequiredAttribute((Element)includeChild, "pattern", false);
                        excludePattern.addIncludePattern(include);
                    }
                    includeChild = includeChild.getNextSibling();
                }
            } else if (name.equals("include-fileset")) {
                String fileSetName = child.getAttribute("name");
                if (fileSetName == null) {
                    throw new ConfigException("Expected File set name for include-fileset");
                }
                FileSetParser fsp = (FileSetParser)fileSets.get(FileSetParser.getUniqueIdentifier(fileSetName));
                if (fsp == null) {
                    throw new ConfigException("Could not find included fileset: " + fileSetName);
                }
                if (fsp.fExcludePatterns != null) {
                    int i = 0;
                    while (i < fsp.fExcludePatterns.length) {
                        excludeSet.add(fsp.fExcludePatterns[i]);
                        ++i;
                    }
                }
            } else {
                throw new ConfigException("Unexpected Node: " + name);
            }
        }

        public FilePatternFilter createFileSet() {
            return new FilePatternFilter(this.fExcludePatterns);
        }

        public FilePatternFilter createFileSetFullPath() {
            FilePatternFilter filePatrnFilter = new FilePatternFilter(this.fExcludePatterns);
            filePatrnFilter.setFullPath(true);
            return filePatrnFilter;
        }

        public static String getUniqueIdentifier(String name) {
            return "file-set:" + name;
        }
    }

    private static class OldFileSetParser {
        public static final String EXCLUDE_HAS_SUB_NODES_ERROR = "exclude has sub-nodes!";
        public String fName;
        public String[] fExcludePatterns;
        public String[] fIncludePatterns;

        private OldFileSetParser() {
        }

        public void doParse(Map fileSets, Element element) throws ConfigException {
            this.fName = ElementParserHelper.getRequiredAttribute(element, "name");
            HashSet excludePatterns = new HashSet();
            HashSet includePatterns = new HashSet();
            Node child = element.getFirstChild();
            while (child != null) {
                if (child instanceof Element) {
                    this.parseChild((Element)child, excludePatterns, includePatterns, fileSets);
                }
                child = child.getNextSibling();
            }
            this.fExcludePatterns = new String[excludePatterns.size()];
            excludePatterns.toArray(this.fExcludePatterns);
            this.fIncludePatterns = new String[includePatterns.size()];
            includePatterns.toArray(this.fIncludePatterns);
            fileSets.put(OldFileSetParser.getUniqueIdentifier(this.fName), this);
        }

        private void parseChild(Element child, HashSet excludeSet, HashSet includeSet, Map fileSets) throws ConfigException {
            String name = child.getNodeName();
            if (name.equals("exclude")) {
                String pattern = child.getAttribute("pattern");
                excludeSet.add(pattern);
                if (child.getChildNodes().getLength() > 0) {
                    throw new ConfigException(EXCLUDE_HAS_SUB_NODES_ERROR);
                }
            } else if (name.equals("include")) {
                String pattern = child.getAttribute("pattern");
                includeSet.add(pattern);
            } else if (name.equals("include-fileset")) {
                int i;
                String fileSetName = child.getAttribute("name");
                if (fileSetName == null) {
                    throw new ConfigException("Expected File set name for include-fileset");
                }
                OldFileSetParser fsp = (OldFileSetParser)fileSets.get(OldFileSetParser.getUniqueIdentifier(fileSetName));
                if (fsp == null) {
                    throw new ConfigException("Could not find included fileset: " + fileSetName);
                }
                if (fsp.fExcludePatterns != null) {
                    i = 0;
                    while (i < fsp.fExcludePatterns.length) {
                        excludeSet.add(fsp.fExcludePatterns[i]);
                        ++i;
                    }
                }
                if (fsp.fIncludePatterns != null) {
                    i = 0;
                    while (i < fsp.fIncludePatterns.length) {
                        includeSet.add(fsp.fIncludePatterns[i]);
                        ++i;
                    }
                }
            } else {
                throw new ConfigException("Unexpected Node: " + name);
            }
        }

        public static String getUniqueIdentifier(String name) {
            return "file-set:" + name;
        }
    }

    private class ScanDirectoryParser {
        private ScanDirectoryParser() {
        }

        public void doParse(Map fileSets, List scanDirectories, Element element) throws ConfigException {
            String directoryName = ElementParserHelper.getRequiredAttribute(element, "name");
            boolean recursive = ElementParserHelper.getBooleanAttribute(element, "recursive", true);
            String fileSetName = ElementParserHelper.getRequiredAttribute(element, "fileset");
            boolean enabled = ElementParserHelper.getBooleanAttribute(element, "enabled", true);
            boolean fullPath = ElementParserHelper.getBooleanAttribute(element, "fullpath", false);
            FileDataSourceConfig.this.fFeedback.debug("fullpath property is set to : " + fullPath);
            FileSetParser fsp = (FileSetParser)fileSets.get(FileSetParser.getUniqueIdentifier(fileSetName));
            if (fsp == null) {
                throw new ConfigException("Referenced fileset not defined before scan-directory element: " + fileSetName);
            }
            File rootDirectory = new File(directoryName);
            HashSet excludeSubDirectoriesSet = new HashSet();
            Node child = element.getFirstChild();
            while (child != null) {
                if (child instanceof Element) {
                    this.parseChild((Element)child, excludeSubDirectoriesSet, rootDirectory);
                }
                child = child.getNextSibling();
            }
            File[] excludeSubDirectories = new File[excludeSubDirectoriesSet.size()];
            excludeSubDirectoriesSet.toArray(excludeSubDirectories);
            DirectoryScanSpec spec = null;
            spec = fullPath ? new DirectoryScanSpec(rootDirectory, recursive, fsp.createFileSetFullPath(), excludeSubDirectories) : new DirectoryScanSpec(rootDirectory, recursive, fsp.createFileSet(), excludeSubDirectories);
            if (enabled) {
                scanDirectories.add(spec);
            }
        }

        private void parseChild(Element child, HashSet excludeSubDirectoriesSet, File rootDirectory) throws ConfigException {
            String name = child.getNodeName();
            if (!name.equals("exclude")) {
                throw new ConfigException("Unexpected Node: " + name);
            }
            String subDirectory = ElementParserHelper.getRequiredAttribute(child, "name");
            File subDirectoryFile = new File(rootDirectory, subDirectory);
            excludeSubDirectoriesSet.add(subDirectoryFile);
        }
    }
}

