/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file.fileSpec;

import com.wily.rave.agent.ds.file.fileSpec.AFileSpec;
import com.wily.rave.utils.HashCodeUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class RealFileSpec
extends AFileSpec {
    private static final long serialVersionUID = 1L;
    private static final Map fEntries = new WeakHashMap();
    private static final String kEmptyString = "".intern();
    private String fDirectory;

    public RealFileSpec() {
    }

    private RealFileSpec(String directory, String name) {
        super(name);
        this.fDirectory = directory != null ? directory.intern() : kEmptyString;
    }

    public static RealFileSpec get(File file) throws IOException {
        return RealFileSpec.get(file.getCanonicalFile().getParent(), file.getCanonicalFile().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RealFileSpec) {
            RealFileSpec entry = (RealFileSpec)o;
            return entry.fDirectory == this.fDirectory && entry.fName == this.fName;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeUtils.accumulateHashCode((int)this.fDirectory.hashCode(), (Object)this.fName);
    }

    public String toString() {
        return this.getFullName();
    }

    public String getFullName() {
        return String.valueOf(this.fDirectory) + File.separator + this.fName;
    }

    public String getDirectory() {
        return this.fDirectory;
    }

    private Object readResolve() throws ObjectStreamException {
        return RealFileSpec.get(this.fDirectory, this.fName);
    }

    private static RealFileSpec get(String directory, String name) {
        RealFileSpec fileSpec = new RealFileSpec(directory, name);
        RealFileSpec oldFileSpec = null;
        WeakReference prevRef = (WeakReference)fEntries.get(fileSpec);
        if (prevRef != null) {
            oldFileSpec = (RealFileSpec)prevRef.get();
        }
        if (oldFileSpec == null) {
            fEntries.put(fileSpec, new WeakReference<RealFileSpec>(fileSpec));
            return fileSpec;
        }
        return oldFileSpec;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.fDirectory = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.fDirectory);
    }
}

