/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.states;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.rave.agent.ds.DataSourceListener;
import com.wily.rave.agent.ds.IAgentContentChangeEvent;
import com.wily.rave.agent.ds.exception.ADataSourceCollectionException;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.rave.agent.ds.states.IAgentDataSourceState;
import com.wily.rave.agent.ds.states.InvalidMsgToDSStateException;
import com.wily.rave.agent.ds.states.ReadyForData;
import com.wily.rave.exceptions.ACommException;
import com.wily.rave.exceptions.InvalidMessageInStateException;
import com.wily.rave.exceptions.ServerInternalError;
import com.wily.rave.exceptions.UnknownDataSourceException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AAgentDataSourceState
implements IAgentDataSourceState {
    public IAgentDataSourceState contentChangeEvent(DataSourceListener dsCtx, IAgentContentChangeEvent agentContentChangeEvent) throws ACommException, ConnectionException, ADataSourceCollectionException {
        throw new InvalidMsgToDSStateException("The event contentChangeEvent() is not supported on the current state [" + this.getClass() + "]. Data Source: " + dsCtx.getDSInstance());
    }

    public IAgentDataSourceState endOfScan(DataSourceListener dsCtx) throws ACommException, ConnectionException, ADataSourceCollectionException {
        throw new InvalidMsgToDSStateException("The event endOfScan() is not supported on the current state [" + this.getClass() + "]. Data Source: " + dsCtx.getDSInstance());
    }

    public IAgentDataSourceState crash(DataSourceListener dsCtx, Throwable ex) throws ACommException, ConnectionException, ADataSourceCollectionException {
        if (ex == null) {
            dsCtx.getWatchedAgentBean().crash(dsCtx.getDSInstance());
            return ReadyForData.getDataSourceState();
        }
        if (ex instanceof ConnectionException) {
            dsCtx.notifyConnectionDeath();
            dsCtx.getFeedback().info("Restarting collection for data source " + dsCtx.getDSInstance() + " due to: " + ex.getMessage());
            dsCtx.getFeedback().verbose(ex);
            dsCtx.forceScanRestart();
        }
        if (ex instanceof UnknownDataSourceException || ex instanceof InvalidMessageInStateException) {
            dsCtx.getFeedback().info("Restarting collection for data source " + dsCtx.getDSInstance() + " due to: " + ex.getMessage());
            dsCtx.getFeedback().verbose(ex);
            dsCtx.forceCleanStart();
        }
        if (ex instanceof ServerInternalError) {
            dsCtx.getFeedback().error("Server internal error for collection " + dsCtx.getDSInstance(), ex);
            throw new StopCollectionException("Server internal error: " + ex.getMessage());
        }
        dsCtx.getFeedback().error("Invalid exception!", ex);
        throw new InvalidMsgToDSStateException("This exception is not supported by the crash() method. Data Source: " + dsCtx.getDSInstance());
    }

    public IAgentDataSourceState transitionToState(DataSourceListener dsCtx) throws ACommException, ConnectionException, ADataSourceCollectionException {
        dsCtx.setState(this);
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

