/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.states;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.rave.agent.cache.IRaveContentFullCache;
import com.wily.rave.agent.ds.DataSourceListener;
import com.wily.rave.agent.ds.IAgentContentChangeEvent;
import com.wily.rave.agent.ds.exception.ADataSourceCollectionException;
import com.wily.rave.agent.ds.states.AAgentDataSourceState;
import com.wily.rave.agent.ds.states.IAgentDataSourceState;
import com.wily.rave.agent.ds.states.ReadyToCommit;
import com.wily.rave.exceptions.ACommException;
import com.wily.rave.spec.IContentChangeEvent;

public class ReadyForData
extends AAgentDataSourceState {
    private static final long serialVersionUID = 1L;
    private static ReadyForData singletonState = new ReadyForData();

    public static AAgentDataSourceState getDataSourceState() {
        return singletonState;
    }

    public IAgentDataSourceState transitionToState(DataSourceListener dsCtx) throws ConnectionException, ACommException, ADataSourceCollectionException {
        super.transitionToState(dsCtx);
        return this.startScan(dsCtx);
    }

    private IAgentDataSourceState startScan(DataSourceListener dsCtx) throws ConnectionException, ACommException {
        dsCtx.getWatchedAgentBean().startScan(dsCtx.getDSInstance());
        return null;
    }

    public IAgentDataSourceState contentChangeEvent(DataSourceListener dsCtx, IAgentContentChangeEvent agentContentChangeEvent) throws ConnectionException, ACommException {
        IRaveContentFullCache cache = dsCtx.getFullCache();
        IContentChangeEvent contentChangeEvent = agentContentChangeEvent.getContentChangeEvent();
        if (contentChangeEvent.isDeletionEvent()) {
            cache.remove(agentContentChangeEvent.getKey());
        } else {
            cache.set(agentContentChangeEvent.getKey(), agentContentChangeEvent.getValue());
        }
        IContentChangeEvent[] buffer = dsCtx.bufferEvent(contentChangeEvent);
        if (buffer != null) {
            this.sendChangeEvents(dsCtx, buffer);
        }
        return null;
    }

    private final void sendChangeEvents(DataSourceListener dsCtx, IContentChangeEvent[] contentChangeEvents) throws ConnectionException, ACommException {
        if (dsCtx.getFeedback().isDebugEnabled()) {
            dsCtx.getFeedback().debug("Sending ChangeDetector changes for data source " + dsCtx.getDSInstance());
        }
        dsCtx.getWatchedAgentBean().contentChangeEvent(contentChangeEvents);
        dsCtx.getFeedback().debug("Sent change(s)!");
    }

    public IAgentDataSourceState endOfScan(DataSourceListener dsCtx) throws ACommException, ConnectionException {
        IContentChangeEvent[] contentChangeEvents = dsCtx.getEventsBuffer();
        if (contentChangeEvents != null) {
            this.sendChangeEvents(dsCtx, contentChangeEvents);
        }
        if (dsCtx.needToCommit()) {
            dsCtx.writeCache();
            return ReadyToCommit.getDataSourceState();
        }
        return null;
    }

    private Object readResolve() {
        return singletonState;
    }
}

