/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.task;

import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.exception.DataSourceRuntimeException;
import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.rave.agent.ds.task.IDataSourceTask;
import com.wily.rave.agent.task.IRaveTask;

public class DataSourceTaskExecutor
implements IRaveTask {
    private static final short COLLECT = 0;
    private static final short INIT = 1;
    private static final short STOP = 2;
    protected IDataSourceListener listener;
    private IDataSourceTask task;
    private String taskName;

    public DataSourceTaskExecutor(IDataSourceListener listener, IDataSourceTask collection, String taskName) {
        this.listener = listener;
        this.task = collection;
        this.taskName = taskName;
    }

    public void init() {
        this.handleCall((short)1);
    }

    public void collect() {
        this.handleCall((short)0);
    }

    public void stop() {
        this.handleCall((short)2);
    }

    public String getTaskName() {
        return this.taskName;
    }

    private void handleCall(short callToMake) {
        while (!this.listener.collectionStopped()) {
            try {
                if (callToMake == 0) {
                    this.task.collect();
                } else if (callToMake == 1) {
                    this.task.init(this.listener);
                } else {
                    this.task.stop();
                }
                return;
            }
            catch (RestartCollectionException restartCollectionException) {
                this.listener.getFeedback().debug("Restarting collection...");
                this.task.restartCollection();
                continue;
            }
            catch (RestartScanException restartScanException) {
                this.listener.getFeedback().debug("Restarting scan...");
                this.task.restartScan();
                continue;
            }
            catch (StopCollectionException ex) {
                this.listener.getFeedback().debug("Stopping collection due to: " + ex.getMessage());
                this.stopCollection();
                return;
            }
            catch (DataSourceRuntimeException ex) {
                this.listener.getFeedback().error("Stopping collection of data source" + this.listener.getDSInstance() + " due to an unexpected exception in the task " + this.getTaskName() + ". Exception: ", (Throwable)((Object)ex));
                this.stopCollection();
                return;
            }
            break;
        }
        return;
    }

    private void stopCollection() {
        this.listener.stopCollection();
    }
}

