/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.bloom;

import com.wily.utilities.properties.Messages;

public final class PowerOf2BloomFilter {
    private int[] fFilter;
    private int fFilterMask;

    public PowerOf2BloomFilter(int filterSize) {
        if (filterSize > 0x70000000) {
            throw new IllegalArgumentException(Messages.getString("PowerOf2BloomFilter.FilterSizeError_Log"));
        }
        int p2FilterSize = 1;
        while (p2FilterSize < filterSize) {
            p2FilterSize <<= 1;
        }
        this.fFilterMask = p2FilterSize - 1;
        this.fFilter = new int[p2FilterSize >> 5];
    }

    public void add(Object obj) {
        int hashCode = obj.hashCode() & this.fFilterMask;
        int arrayIndex = hashCode >> 5;
        int bitIndex = hashCode & 0x1F;
        this.fFilter[arrayIndex] = this.fFilter[arrayIndex] | 1 << bitIndex;
    }

    public boolean contains(Object obj) {
        int bitIndex;
        int hashCode = obj.hashCode() & this.fFilterMask;
        int arrayIndex = hashCode >> 5;
        return (this.fFilter[arrayIndex] & 1 << (bitIndex = hashCode & 0x1F)) != 0;
    }
}

