/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.ICloseable;
import com.wily.util.event.AListenerEvent;
import com.wily.util.event.BadEventException;
import com.wily.util.event.ITrackableListener;
import com.wily.util.event.ITrackableListenerAllListeners;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.utilities.properties.Messages;
import java.io.PrintWriter;
import java.util.Vector;

public class ListenerTracker
implements ICloseable {
    public static final ITrackableListener kBroadcastToAllListeners = new DummyListener();
    private static final ITrackableListener[] kZeroLengthTrackableListenerArray = new ITrackableListener[0];
    private final IModuleFeedbackChannel fFeedback;
    private final Vector fAsyncListeners;
    private static final boolean sDebug = false;
    private static Vector sTrackers;

    static {
        ListenerTracker.debug_init();
    }

    public ListenerTracker(IModuleFeedbackChannel feedback, String name, Class listenerClass) {
        this.fFeedback = feedback;
        this.fAsyncListeners = new Vector(2);
        ListenerTracker.debug_track(this);
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public boolean isListener(ITrackableListener listener) {
        return this.fAsyncListeners.contains(listener);
    }

    public void close() {
        this.fAsyncListeners.clear();
    }

    String getName() {
        return "ListenerTracker";
    }

    void addBroadcastListener(ITrackableListener newListener) {
        this.fAsyncListeners.addElement(newListener);
    }

    void removeBroadcastListener(ITrackableListener listenerToRemove) {
        this.fAsyncListeners.removeElement(listenerToRemove);
    }

    Runnable getAddListenerRunnable(final ITrackableListener listener) {
        return new Runnable(){

            public void run() {
                ListenerTracker.this.addBroadcastListener(listener);
            }
        };
    }

    Runnable getRemoveListenerRunnable(final ITrackableListener listener) {
        return new Runnable(){

            public void run() {
                ListenerTracker.this.removeBroadcastListener(listener);
            }
        };
    }

    void sendEventToAllAsyncListeners(AListenerEvent event) {
        Vector asyncListenersSnapshot = (Vector)this.fAsyncListeners.clone();
        int i = asyncListenersSnapshot.size() - 1;
        while (i >= 0) {
            this.sendEventToOneListener((ITrackableListener)asyncListenersSnapshot.elementAt(i), event);
            --i;
        }
    }

    ITrackableListener[] getBroadcastListenerSnapshot() {
        return this.fAsyncListeners.toArray(kZeroLengthTrackableListenerArray);
    }

    void sendEventToOneListener(ITrackableListener listener, AListenerEvent event) {
        try {
            listener.handleEvent(event);
        }
        catch (Throwable e) {
            IModuleFeedbackChannel feedbackChannel = this.getModuleFeedback();
            feedbackChannel.error(Messages.getString("ListenerTracker.ListenerTrackerSendEventError_Log", event, (Object)listener), e);
        }
    }

    private static void debug_init() {
    }

    private static void debug_track(ListenerTracker tracker) {
    }

    public static void debugLogAll(IModuleFeedbackChannel feedback) {
        feedback.debug(Messages.getString("ListenerTracker.DebugLogMsg_Log"));
    }

    public void debugLog(IModuleFeedbackChannel feedback) {
        feedback.debug(String.valueOf(Messages.getString("ListenerTracker.DebugName_Log")) + this.getName());
        feedback.debug(String.valueOf(Messages.getString("ListenerTracker.ListenerCount_Log")) + this.fAsyncListeners.size());
        int i = 0;
        while (i < this.fAsyncListeners.size()) {
            feedback.debug("\t" + i + "\t" + this.fAsyncListeners.elementAt(i).toString());
            ++i;
        }
    }

    public void debugLog(PrintWriter log) {
        log.println(String.valueOf(Messages.getString("ListenerTracker.DebugName_Log")) + this.getName());
        log.println(String.valueOf(Messages.getString("ListenerTracker.ListenerCount_Log")) + this.fAsyncListeners.size());
        int i = 0;
        while (i < this.fAsyncListeners.size()) {
            log.println("\t" + i + "\t" + this.fAsyncListeners.elementAt(i).toString());
            ++i;
        }
    }

    private static class DummyListener
    implements ITrackableListener,
    ITrackableListenerAllListeners {
        private DummyListener() {
        }

        public void handleEvent(AListenerEvent event) throws BadEventException {
        }

        public String getTrackableListenerName() {
            return "DummyListener";
        }
    }
}

