/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FileUtils {
    private static final Charset UTF8CHARSET = Charset.forName("UTF-8");
    public final int NATIVE_FILE_SEPARATOR = 0;
    public final int WINDOWS_FILE_SEPARATOR = 1;
    public final int UNIX_FILE_SEPARATOR = 2;

    public static boolean isExpressionInFile(String regEx, File fileToSearch) throws IOException {
        boolean result = false;
        try {
            Pattern p = Pattern.compile(regEx);
            FileReader fr = new FileReader(fileToSearch);
            BufferedReader in = new BufferedReader(fr);
            String line = in.readLine();
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.find()) {
                    result = true;
                    break;
                }
                line = in.readLine();
            }
            in.close();
            fr.close();
        }
        catch (PatternSyntaxException pse) {
            System.out.println("Invalid regular expression: " + regEx);
            pse.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File not found: " + fileToSearch.toString());
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("Error accessing file: " + fileToSearch.toString());
            ioe.printStackTrace();
        }
        return result;
    }

    public static boolean isStringInFile(String strToSearch, String filename) throws IOException {
        boolean result = false;
        try {
            InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
            BufferedReader in = new BufferedReader(fr);
            String line = in.readLine();
            while (line != null) {
                if (line.indexOf(strToSearch) >= 0) {
                    result = true;
                    break;
                }
                line = in.readLine();
            }
            in.close();
            ((Reader)fr).close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File not found: " + filename);
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("Error accessing file: " + filename);
            ioe.printStackTrace();
        }
        return result;
    }

    public static void appendLineToFile(String lineToAdd, String fileStr) throws IOException {
        FileUtils.appendLineToFile(lineToAdd, new File(fileStr));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void appendLineToFile(String lineToAdd, File fileToAppendTo) throws IOException {
        FileWriter fw = new FileWriter(fileToAppendTo, true);
        BufferedWriter out = new BufferedWriter(fw);
        try {
            try {
                out.write(lineToAdd);
                out.newLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            out.close();
            fw.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        out.close();
        fw.close();
    }

    public static void appendNewLineToFile(String fileStr) throws IOException {
        FileUtils.appendNewLineToFile(new File(fileStr));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void appendNewLineToFile(File fileToAppendTo) throws IOException {
        FileWriter fw = new FileWriter(fileToAppendTo, true);
        BufferedWriter out = new BufferedWriter(fw);
        try {
            try {
                out.newLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            out.close();
            fw.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        out.close();
        fw.close();
    }

    public static String convertFileToString(String fileStr) throws IOException {
        return FileUtils.convertFileToString(new File(fileStr));
    }

    public static String convertFileToString(File f) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        char[] buf = new char[1024];
        int num = 0;
        while ((num = br.read(buf)) != -1) {
            sb.append(String.valueOf(buf, 0, num));
            buf = new char[1024];
        }
        br.close();
        fr.close();
        return sb.toString();
    }

    public static void convertStringToFile(String s, String fileStr) throws IOException {
        FileUtils.convertStringToFile(s, new File(fileStr));
    }

    public static void convertStringToFile(String s, File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        StringReader sr = new StringReader(s);
        BufferedReader br = new BufferedReader(sr);
        BufferedWriter bw = new BufferedWriter(fw);
        String ln = null;
        while ((ln = br.readLine()) != null) {
            bw.write(ln);
            bw.newLine();
        }
        br.close();
        bw.close();
        sr.close();
        fw.close();
    }

    public static File getAbsoluteInstallPath(File f, String installDir) {
        File returnfile = !f.isAbsolute() ? new File(String.valueOf(installDir) + System.getProperty("file.separator") + f) : f;
        return returnfile;
    }

    public static String getAbsoluteInstallPath(String fileStr, String installDir) {
        File returnfile = FileUtils.getAbsoluteInstallPath(new File(fileStr), installDir);
        return returnfile.toString();
    }

    public String getRelativeParent(File file, int level, int fileSeparator) {
        String fileSep = fileSeparator == 1 ? "\\" : (fileSeparator == 2 ? "/" : System.getProperty("file.separator"));
        if (level <= 0) {
            return "";
        }
        String fileSepRegex = System.getProperty("file.separator").replaceAll("\\\\", "\\\\\\\\");
        int pathLevels = file.toString().split(fileSepRegex).length - 1;
        if (level > pathLevels) {
            level = pathLevels;
        }
        File parentDir = file.getParentFile();
        String[] dirStack = new String[level];
        int j = 0;
        while (j < level) {
            dirStack[j] = parentDir.getName();
            parentDir = parentDir.getParentFile();
            ++j;
        }
        StringBuffer sb = new StringBuffer();
        int j2 = level - 1;
        while (j2 >= 0) {
            sb.append(dirStack[j2]);
            if (j2 > 0) {
                sb.append(fileSep);
            }
            --j2;
        }
        return sb.toString();
    }

    public String getRelativeParent(File file, int level) {
        return this.getRelativeParent(file, level, 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File writeResourceToFile(URL sourceUrl, String fileStr) throws IOException {
        InputStream in;
        File dest;
        block7: {
            dest = new File(fileStr);
            in = null;
            OutputStream out = null;
            try {
                try {
                    System.out.println("target = " + fileStr);
                    System.out.println("resource = " + sourceUrl.toString());
                    in = sourceUrl.openStream();
                    out = new FileOutputStream(dest);
                    FileUtils.copyBufferStream(in, out);
                    out.flush();
                    out.close();
                    in.close();
                }
                catch (IOException ioe) {
                    System.out.println("Exception caught.");
                    if (out == null) {
                        System.out.println("out = null.");
                    }
                    if (in != null) throw new IOException(ioe.getMessage());
                    System.out.println("in == null");
                    throw new IOException(ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (out != null) {
                    out.flush();
                    out.close();
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (out == null) break block7;
            }
            out.flush();
            out.close();
        }
        if (in == null) return dest;
        in.close();
        return dest;
    }

    public static long copyBufferStream(InputStream is, OutputStream os, int bufferSizeInBytes) throws IOException {
        byte[] b = new byte[bufferSizeInBytes];
        return FileUtils.copyBufferStream(is, os, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyBufferStream(InputStream is, OutputStream os) throws IOException {
        byte[] BUFFER;
        byte[] byArray = BUFFER = new byte[65536];
        synchronized (BUFFER) {
            long l = FileUtils.copyBufferStream(is, os, BUFFER);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return l;
        }
    }

    public static long copyBufferStream(InputStream is, OutputStream os, byte[] b) throws IOException {
        long bytes = 0L;
        int read = is.read(b, 0, b.length);
        while (read != -1) {
            os.write(b, 0, read);
            bytes += (long)read;
            read = is.read(b, 0, b.length);
        }
        os.flush();
        return bytes;
    }

    public boolean rename(String origFileStr, String newFileStr) {
        File origFile = new File(origFileStr);
        File newFile = new File(newFileStr);
        File newFileParent = new File(newFile.getParent());
        if (!newFileParent.exists()) {
            newFileParent.mkdirs();
        }
        boolean success = origFile.renameTo(new File(newFileStr));
        return success;
    }

    public boolean renameInPlace(String origFileStr, String newName) {
        File origFile = new File(origFileStr);
        boolean success = origFile.renameTo(new File(origFile.getParent(), newName));
        return success;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convertStringToFileUtf8(String s, String outputFileName, Charset charset) throws IOException {
        OutputStreamWriter writer;
        block5: {
            FileOutputStream fw = new FileOutputStream(outputFileName);
            writer = new OutputStreamWriter((OutputStream)fw, charset != null ? charset : UTF8CHARSET);
            StringReader sr = new StringReader(s);
            BufferedReader br = new BufferedReader(sr);
            try {
                String ln = null;
                while ((ln = br.readLine()) != null) {
                    writer.write(String.valueOf(ln) + "\n");
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (br != null) {
                    br.close();
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (br == null) break block5;
            }
            br.close();
        }
        if (writer == null) return;
        writer.close();
    }

    /*
     * Exception decompiling
     */
    public static String convertFileToStringUtf8(String inputFileName, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 103->106)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

