/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.task;

import com.wily.util.task.ATask;
import com.wily.util.task.IInterruptSource;
import com.wily.util.task.IInterruptableTask;
import com.wily.util.task.ITaskCompletionHandler;
import com.wily.util.task.TaskAlreadyStartedException;

public abstract class AAsynchTask
extends ATask
implements IInterruptableTask,
IInterruptSource {
    private static final String kTaskThreadName = "Asynchronous Task Thread";
    protected static final int kPausedState = 4;
    protected static final int kCancelledState = 5;
    private boolean fIsPaused = false;
    private double fPercentage;
    private int fTotalCount;
    private int fCurrentCount;

    public AAsynchTask() {
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.ITask_setExecutionQueue(null);
        this.fPercentage = -1.0;
        this.fTotalCount = -1;
        this.fCurrentCount = -1;
    }

    public void ITask_startTask() throws TaskAlreadyStartedException {
        super.ITask_startTask(kTaskThreadName, false);
    }

    public void ITask_startTask(boolean isDaemon) throws TaskAlreadyStartedException {
        super.ITask_startTask(kTaskThreadName, isDaemon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceFinished() {
        Object object = this.getStateLock();
        synchronized (object) {
            int state = this.getState();
            if (!this.isFinishedState(state)) {
                this.setState(2);
            }
        }
    }

    protected boolean isFinishedState(int state) {
        return super.isFinishedState(state) || state == 5;
    }

    public boolean IInterruptableTask_hasProgressInfo() {
        return this.fPercentage >= 0.0 || this.fTotalCount >= 0;
    }

    public double IInterruptableTask_getProgressPercentage() {
        if (this.fPercentage >= 0.0) {
            return this.fPercentage;
        }
        if (this.fTotalCount >= 0) {
            return (double)this.fCurrentCount / (double)this.fTotalCount;
        }
        return 0.0;
    }

    public boolean IInterruptableTask_wasCancelled() {
        return this.getState() == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IInterruptableTask_pauseAsynch() {
        Object object = this.getStateLock();
        synchronized (object) {
            this.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IInterruptableTask_pauseSynch() {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.pause()) {
                while (!this.fIsPaused) {
                    try {
                        this.getStateLock().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private boolean pause() {
        int state = this.getState();
        if (state == 1) {
            this.setState(4);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IInterruptableTask_resume() {
        Object object = this.getStateLock();
        synchronized (object) {
            int state = this.getState();
            if (state == 4) {
                this.setState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IInterruptableTask_cancelAsynch() {
        Object object = this.getStateLock();
        synchronized (object) {
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IInterruptableTask_cancelSynch() {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.cancel()) {
                while (!this.ITask_isCompleted()) {
                    try {
                        this.getStateLock().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private boolean cancel() {
        int curState = this.getState();
        if (curState == 0 || curState == 4 || curState == 1) {
            this.setState(5);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void IInterruptableTask_waitForTask() {
        Object object = this.getStateLock();
        synchronized (object) {
            while (true) {
                if (this.ITask_isCompleted()) {
                    return;
                }
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean IInterruptableTask_isActive() {
        return this.ITask_isStarted() && !this.ITask_isCompleted();
    }

    public void IInterruptSource_setProgress(double percentage) {
        if (percentage < 0.0) {
            percentage = 0.0;
        }
        if (percentage > 1.0) {
            percentage = 1.0;
        }
        this.fPercentage = percentage;
    }

    public void IInterruptSource_setProgress(int currentCount, int totalCount) {
        if (totalCount < 0) {
            totalCount = 0;
        }
        if (currentCount < 0) {
            currentCount = 0;
        }
        if (currentCount > totalCount) {
            currentCount = totalCount;
        }
        this.fCurrentCount = currentCount;
        this.fTotalCount = totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void IInterruptSource_pauseIfNecessary() {
        Thread.yield();
        Object object = this.getStateLock();
        synchronized (object) {
            while (true) {
                if (this.getState() != 4) {
                    return;
                }
                this.fIsPaused = true;
                this.getStateLock().notifyAll();
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
                break;
            }
            finally {
                this.fIsPaused = false;
            }
        }
    }

    public boolean IInterruptSource_shouldStop() {
        return this.getState() == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IInterruptSource_hasFinished() {
        Object object = this.getStateLock();
        synchronized (object) {
            this.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IInterruptSource_hasCancelled() {
        Object object = this.getStateLock();
        synchronized (object) {
            this.setState(5);
        }
    }

    protected boolean isValidState(int state) {
        return super.isValidState(state) || state == 4 || state == 5;
    }

    public boolean ITask_isCompleted() {
        return super.ITask_isCompleted() || this.getState() == 5;
    }

    protected void notifyCompletionHandler(ITaskCompletionHandler handler) {
        if (this.getState() == 5) {
            handler.ITaskCompletionHandler_taskCancelled();
        } else {
            super.notifyCompletionHandler(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITask_resetTask() {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.ITask_isStarted() && !this.ITask_isCompleted()) {
                this.IInterruptableTask_cancelSynch();
            }
            this.initialize();
        }
    }
}

